/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.model.SrmAutoCalCtxModel;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.service.ISrmCalIsBatchService;
import kd.scm.srm.common.formula.service.SrmAutoCalServiceFactory;
import kd.scm.srm.common.formula.utils.ScDataHandleLogInfoUtils;
import kd.scm.srm.common.formula.utils.SrmAutoCalCtxBuildUtils;
import kd.scm.srm.common.formula.utils.SrmCalResultHelper;

public class SrmCalSingleService
implements ISrmCalIsBatchService {
    private static final Log LOG = LogFactory.getLog(SrmCalSingleService.class);

    @Override
    public List<SrmGetAutoScoreReq> doAutoCal(SrmAutoFormulaReq srmAutoFormulaReq, DynamicObject formulaDy, Boolean isAlgox, Integer timeOut) {
        LOG.info("\u5e73\u94fa\u5904\u7406\u8ba1\u7b97\u4e2d\uff0csrmAutoFormulaReq={}", (Object)srmAutoFormulaReq.toString());
        ArrayList<SrmGetAutoScoreReq> list = new ArrayList<SrmGetAutoScoreReq>(8);
        Long orgId = srmAutoFormulaReq.getOrgId();
        String evaDimension = srmAutoFormulaReq.getEvaDimension();
        Date startDate = srmAutoFormulaReq.getStartDate();
        Date endDate = srmAutoFormulaReq.getEndDate();
        Long evaplanId = srmAutoFormulaReq.getEvaplanId();
        List<SrmAutoFormulaReq.SrmAutoFormulaData> datas = srmAutoFormulaReq.getData();
        SrmAutoFormulaReq.SrmAutoFormulaData firstData = datas.get(0);
        Long indexId = firstData.getIndexId();
        List<SrmFormulaModel> srmFormulaModelList = this.buildSingleSrmFormulaModel(orgId, evaplanId, evaDimension, startDate, endDate, datas);
        for (SrmFormulaModel model : srmFormulaModelList) {
            DynamicObject loadCal = SrmCalResultHelper.getCalResult(model.getOrgId(), evaplanId, indexId, evaDimension);
            loadCal = this.doAutoCal(loadCal, model, formulaDy, isAlgox, timeOut);
            List<SrmGetAutoScoreReq> calResultList = SrmCalResultHelper.getCalResultList(loadCal, model);
            list.addAll(calResultList);
        }
        LOG.info("\u5e73\u94fa\u5904\u7406\u8ba1\u7b97\u7ed3\u679c={}", (Object)JSON.toJSONString(list));
        String config = "isBatch:false;isAlgox:" + isAlgox;
        String resultDesc = ResManager.loadKDString((String)"\u5e73\u94fa\u8ba1\u7b97\u5b50\u8868\u8fbe\u5f0fresult", (String)"SrmCalSingleService_0", (String)"scm-srm-common", (Object[])new Object[0]);
        ScDataHandleLogInfoUtils.info(srmAutoFormulaReq, config, resultDesc, list);
        return list;
    }

    private DynamicObject doAutoCal(DynamicObject loadCal, SrmFormulaModel req, DynamicObject formulaDy, Boolean isAlgox, Integer timeOut) {
        String config = "isBatch:false;isAlgox:" + isAlgox;
        try {
            String formula = formulaDy.getString("formula");
            DynamicObjectCollection entryEntitys = formulaDy.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntitys.size(); ++i) {
                DynamicObject dy = (DynamicObject)entryEntitys.get(i);
                String entitycode = dy.getString("entitycode");
                SrmAutoCalCtxModel ctx = SrmAutoCalCtxBuildUtils.buildCtx(req, dy, timeOut);
                SrmGetAutoScoreReq model = SrmAutoCalServiceFactory.getISrmAutoCalAlgoService(isAlgox).queryDataSet(req, dy, ctx);
                String resultDesc = ResManager.loadKDString((String)"\u5e73\u94fa\u8ba1\u7b97\u5b50\u8868\u8fbe\u5f0fresult", (String)"SrmCalSingleService_0", (String)"scm-srm-common", (Object[])new Object[0]);
                String resultStr = resultDesc + (i + 1) + ":";
                ScDataHandleLogInfoUtils.info(req, ctx.toString(), config, config, resultStr, model);
                if (model == null) continue;
                loadCal = SrmCalResultHelper.saveOrNewCalResult(loadCal, model, req, formula, entitycode);
                SrmCalResultHelper.saveCalResult(loadCal);
            }
            return SrmCalResultHelper.calFinalFormula(loadCal, req, formula);
        }
        catch (Exception e) {
            ScDataHandleLogInfoUtils.error(req, config, e);
            return null;
        }
    }

    private List<SrmFormulaModel> buildSingleSrmFormulaModel(Long orgId, Long evaplanId, String evaDimension, Date startDate, Date endDate, List<SrmAutoFormulaReq.SrmAutoFormulaData> datas) {
        ArrayList<SrmFormulaModel> srmFormulaModelList = new ArrayList<SrmFormulaModel>(8);
        for (SrmAutoFormulaReq.SrmAutoFormulaData data : datas) {
            SrmFormulaModel model = new SrmFormulaModel();
            model.setEndDate(endDate);
            model.setEvaDimension(evaDimension);
            model.setOrgId(data.getGroupOrgId());
            model.setStartDate(startDate);
            model.setEvaplanId(evaplanId);
            model.setIndexId(data.getIndexId());
            model.setIndexScoreDetailId(data.getIndexScoreDetailId());
            model.setMaterialId(data.getMaterialId());
            model.setCategoryId(data.getCategoryId());
            model.setSupplierId(data.getSupplierId());
            model.setScoreTaskId(data.getScoreTaskId());
            model.setFormulaId(data.getFormulaId());
            model.setIndexId(data.getIndexId());
            model.setBatch(false);
            srmFormulaModelList.add(model);
        }
        return srmFormulaModelList;
    }
}

