/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.CompoundId;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.Operator;
import kd.bos.formula.excel.Paren;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.srm.common.enums.SrmEvaDimensionEnum;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.model.CalFunctionModel;
import kd.scm.srm.common.formula.model.SrmAutoCalCtxModel;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.utils.FormulaHelper;

public class AutoFormulaUtils {
    private static final Log log = LogFactory.getLog(AutoFormulaUtils.class);
    public static final BigDecimal DEFALULT_VALUE_VAL = new BigDecimal(-999999999);
    public static final String BEFOREFILTER = "beforefilter";
    public static final String CHILDFORMULA = "childformula";
    public static final String FORMULA = "formula";
    public static final String METADATA = "metadata";
    public static final String GROUPBY = "groupby";
    public static final String DEFAULFILTER = "defaulfilter";
    public static final String FILTER = "filter";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ORGFIELD = "orgfield";
    public static final String SUPPLIERFIELD = "supplierfield";
    public static final String MATERIALFIELD = "materialfield";
    public static final String CATEGORYFIELD = "categoryfield";
    public static final String EVALPERIODFIELD = "evalperiodfield";
    public static final String ENTITYCODE = "entitycode";
    public static final String ORDERBYFIELD = "orderbyfield";
    public static final String ORDERBYTYPE = "orderbytype";
    public static final String INCLUDESUBORG = "includesuborg";
    public static final String DEFAULTFILTER_A = "A";
    public static final String DEFAULTRESULT = "defaultresult";
    public static final String CONDITIONBILLID = "conditionbillid";
    public static final String CONDITIONFIELD = "conditionfield";
    public static final String CONDITIONNAME = "conditionname";
    public static final String CONDITIONSCORE = "conditionscore";
    public static final String CONDITIONID = "conditionid";
    public static final String CONDITIONENTITY = "conditionentity";
    public static final String CONDITIONSUPPLIERFIELD = "conditionsupplierfield";
    public static final String CONDITIONORDERBYFIELD = "conditionorderbyfield";
    public static final String CONDITIONORDERBYTYPE = "conditionorderbytype";

    public static void checkAutoFormulaReq(SrmAutoFormulaReq req, String calmethod) {
        if (req == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_8", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        String evaDimension = req.getEvaDimension();
        Long orgId = req.getOrgId();
        Date startDate = req.getStartDate();
        Date endDate = req.getEndDate();
        Long evaplanId = req.getEvaplanId();
        if (evaplanId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bc4\u4f30\u8ba1\u5212\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_2", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)evaDimension)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bc4\u4f30\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_4", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        List<SrmAutoFormulaReq.SrmAutoFormulaData> datas = req.getData();
        if (CollectionUtils.isEmpty(datas)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bc4\u4f30\u8ba1\u5212\u7ec6\u5219\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_6", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        for (SrmAutoFormulaReq.SrmAutoFormulaData data : datas) {
            Long formulaId = data.getFormulaId();
            Long supplierId = data.getSupplierId();
            Long materialId = data.getMaterialId();
            Long categoryId = data.getCategoryId();
            if (formulaId == null || formulaId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef,\u8ba1\u7b97\u516c\u5f0f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_0", (String)"scm-srm-common", (Object[])new Object[0]));
            }
            if (supplierId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef,\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_3", (String)"scm-srm-common", (Object[])new Object[0]));
            }
            if (materialId == null && SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_5", (String)"scm-srm-common", (Object[])new Object[0]));
            }
            if (categoryId != null || !SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u54c1\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_12", (String)"scm-srm-common", (Object[])new Object[0]));
        }
    }

    public static String buildHashKey(Long orgId, String evaDimension, Long supplierId, Long materiaOrGrouplId) {
        if (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension)) {
            return String.valueOf(orgId) + String.valueOf(supplierId) + String.valueOf(materiaOrGrouplId);
        }
        if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension)) {
            return String.valueOf(orgId) + String.valueOf(supplierId) + String.valueOf(materiaOrGrouplId);
        }
        return String.valueOf(orgId) + String.valueOf(supplierId);
    }

    public static String buildQueryField(String fomulaQueryField, String filterQueryField, String groupbyField, String orderby) {
        String[] groupfields;
        boolean isContains;
        ArrayList<String> queryFields = new ArrayList<String>(8);
        if (StringUtils.isNotEmpty((String)fomulaQueryField)) {
            String[] fomulaQueryFields;
            for (String f : fomulaQueryFields = fomulaQueryField.split(",")) {
                isContains = queryFields.stream().anyMatch(s -> s.equals(f));
                if (!StringUtils.isNotEmpty((String)f) || isContains) continue;
                queryFields.add(f);
            }
        }
        if (StringUtils.isNotEmpty((String)filterQueryField)) {
            String[] filterqueryfields;
            for (String f : filterqueryfields = filterQueryField.split(",")) {
                isContains = queryFields.stream().anyMatch(s -> s.equals(f));
                if (!StringUtils.isNotEmpty((String)f) || isContains) continue;
                queryFields.add(f);
            }
        }
        if (StringUtils.isNotEmpty((String)orderby)) {
            queryFields.add(orderby);
        }
        for (String g : groupfields = groupbyField.split(",")) {
            isContains = queryFields.stream().anyMatch(s -> s.equals(g));
            if (!StringUtils.isNotEmpty((String)g) || isContains) continue;
            queryFields.add(g);
        }
        if (!CollectionUtils.isEmpty(queryFields)) {
            return String.join((CharSequence)",", queryFields);
        }
        return null;
    }

    public static String getQueryField(String expression) {
        if (StringUtils.isEmpty((String)expression)) {
            return "";
        }
        String[] vars = FormulaHelper.extractVariables(expression);
        StringBuilder queryField = new StringBuilder();
        if (vars == null || vars.length == 0 || StringUtils.isBlank((String)vars[0])) {
            return "";
        }
        for (String s : vars) {
            queryField.append(s).append(",");
        }
        if (queryField.length() > 0) {
            queryField = queryField.deleteCharAt(queryField.length() - 1);
        }
        return queryField.toString();
    }

    public static Map<String, String> buildGroupByFields(DynamicObject dy, SrmFormulaModel req) {
        String groupbyField;
        HashMap<String, String> groupbyMap = new HashMap<String, String>(8);
        ArrayList<String> specialGroupby = new ArrayList<String>(8);
        String defaultfilter = dy.getString(DEFAULFILTER);
        Boolean bool = StringUtils.isEmpty((String)defaultfilter) || DEFAULTFILTER_A.equals(defaultfilter);
        if (bool.booleanValue()) {
            boolean contains;
            if (SrmEvaDimensionEnum.SUPPLIER_DIMENSION.getVal().equals(req.getEvaDimension())) {
                String supplierfield = dy.getString(SUPPLIERFIELD);
                contains = specialGroupby.stream().anyMatch(s -> s.equals(supplierfield));
                if (!contains) {
                    specialGroupby.add(supplierfield);
                }
            }
            if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(req.getEvaDimension())) {
                String categoryfield = dy.getString(CATEGORYFIELD);
                contains = specialGroupby.stream().anyMatch(s -> s.equals(categoryfield));
                if (!contains) {
                    specialGroupby.add(categoryfield);
                }
            }
            if (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(req.getEvaDimension())) {
                String materialfield = dy.getString(MATERIALFIELD);
                contains = specialGroupby.stream().anyMatch(s -> s.equals(materialfield));
                if (!contains) {
                    specialGroupby.add(materialfield);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(groupbyField = dy.getString(GROUPBY)))) {
            String[] split = groupbyField.split(",");
            for (int i = 0; i < split.length; ++i) {
                String groupField = split[i];
                boolean contains = specialGroupby.stream().anyMatch(s -> s.equals(groupField));
                if (contains) continue;
                specialGroupby.add(groupField);
            }
        }
        if (!CollectionUtils.isEmpty(specialGroupby)) {
            for (int i = 0; i < specialGroupby.size(); ++i) {
                String alias = "group" + i;
                groupbyMap.put(alias, (String)specialGroupby.get(i) + " " + alias);
            }
        }
        return groupbyMap;
    }

    public static Object tranValue(String value) {
        Object params = null;
        if (AutoFormulaUtils.isNum(value)) {
            params = Double.valueOf(value.trim());
        } else {
            String replace = AutoFormulaUtils.replace(value);
            try {
                Date string2date = DateUtil.string2date((String)replace, (String)"yyyy-MM-dd");
                params = string2date;
            }
            catch (Exception e) {
                log.error("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                params = replace;
            }
        }
        return params;
    }

    private static String replace(String value) {
        char[] charArray = value.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : charArray) {
            String a = String.valueOf(c);
            String replace = a.replace("'", "").replace("\"", "");
            sb.append(replace);
        }
        return sb.toString();
    }

    public static DynamicObject getCalFormulaById(Long formulaId) {
        QFilter filter = new QFilter("id", "=", (Object)formulaId);
        filter.and("enable", "=", (Object)true);
        filter.and("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        StringBuilder sb = new StringBuilder();
        sb.append("name,number,enable,formulapreview,pluginname,calmethod,conditionbillid,conditionfield,conditionsupplierfield,conditionorderbyfield,conditionorderbytype,").append(FORMULA).append(",").append(ENTRYENTITY).append(".").append("id").append(",").append(ENTRYENTITY).append(".").append(METADATA).append(",").append(ENTRYENTITY).append(".").append(GROUPBY).append(",").append(ENTRYENTITY).append(".").append(FILTER).append(",").append(ENTRYENTITY).append(".").append(BEFOREFILTER).append(",").append(ENTRYENTITY).append(".").append(CHILDFORMULA).append(",").append(ENTRYENTITY).append(".").append(ORGFIELD).append(",").append(ENTRYENTITY).append(".").append(SUPPLIERFIELD).append(",").append(ENTRYENTITY).append(".").append(CATEGORYFIELD).append(",").append(ENTRYENTITY).append(".").append(MATERIALFIELD).append(",").append(ENTRYENTITY).append(".").append(EVALPERIODFIELD).append(",").append(ENTRYENTITY).append(".").append(DEFAULFILTER).append(",").append(ENTRYENTITY).append(".").append(ENTITYCODE).append(",").append(ENTRYENTITY).append(".").append(ORDERBYFIELD).append(",").append(ENTRYENTITY).append(".").append(ORDERBYTYPE).append(",").append(ENTRYENTITY).append(".").append(INCLUDESUBORG).append(",").append(ENTRYENTITY).append(".").append(DEFAULTRESULT).append(",").append(CONDITIONENTITY).append(".").append(CONDITIONNAME).append(",").append(CONDITIONENTITY).append(".").append(CONDITIONSCORE).append(",").append(CONDITIONENTITY).append(".").append(CONDITIONID).append(",");
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingleFromCache((String)"srm_cal_formula", (String)sb.toString(), (QFilter[])new QFilter[]{filter});
        return loadSingle;
    }

    public static boolean isNum(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        String string = "^[-\\+]?[\\d]*$";
        Pattern pattern = Pattern.compile(string);
        return pattern.matcher(str.trim()).matches();
    }

    public static String bulidNodesJson(DynamicObject entity, String entryEntity, Boolean tran) {
        if (entity != null) {
            DataEntityPropertyCollection properties = entity.getDataEntityType().getProperties();
            String loadKDString = ResManager.loadKDString((String)"\u5206\u5f55", (String)"AutoFormulaUtils_10", (String)"scm-srm-common", (Object[])new Object[0]);
            TreeNode root = new TreeNode("", entryEntity, loadKDString);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                LocaleString displayName = property.getDisplayName();
                if (displayName == null) continue;
                String text = "";
                text = tran != false ? displayName.getLocaleValue() : entryEntity + "." + name;
                TreeNode child = new TreeNode(entryEntity, name, text);
                root.addChild(child);
            }
            String nodesJson = SerializationUtils.toJsonString((Object)root);
            return nodesJson;
        }
        return null;
    }

    public static Map<String, List<CalFunctionModel>> getCalFunctionMaps(String formulapreview) {
        HashMap<String, List<CalFunctionModel>> map = new HashMap<String, List<CalFunctionModel>>(8);
        Expr childformula = FormulaHelper.parseFormula(formulapreview);
        List<CalFunctionModel> calFunctions = AutoFormulaUtils.parseFormula(childformula);
        map.put(childformula.toString(), calFunctions);
        return map;
    }

    public static List<CalFunctionModel> getCalFunctions(String formulapreview) {
        Expr childformula = FormulaHelper.parseFormula(formulapreview);
        List<CalFunctionModel> calFunctions = AutoFormulaUtils.parseFormula(childformula);
        return calFunctions;
    }

    public static List<CalFunctionModel> parseFormula(Expr parseFormula) {
        ArrayList<CalFunctionModel> list = new ArrayList<CalFunctionModel>(8);
        if (parseFormula instanceof FunCall) {
            FunCall parseFormulaFunCall = (FunCall)parseFormula;
            String name = parseFormulaFunCall.getName();
            Expr[] params = parseFormulaFunCall.getParams();
            if (params == null || params.length == 0) {
                return list;
            }
            Expr childFormula = params[0];
            if (childFormula instanceof BinaryExpr) {
                CalFunctionModel calFunctionModel;
                BinaryExpr parseFormulaBinaryExpr = (BinaryExpr)childFormula;
                Expr left = parseFormulaBinaryExpr.getLeft();
                if ("now()".equals(left.toString())) {
                    calFunctionModel = new CalFunctionModel();
                    calFunctionModel.setFunctionName(name);
                    calFunctionModel.setFunctionExpr(parseFormula.toString());
                    calFunctionModel.setChildExpr(params[0].toString());
                    list.add(calFunctionModel);
                }
                if (!(left instanceof FunCall) && !(left instanceof BinaryExpr)) {
                    calFunctionModel = new CalFunctionModel();
                    calFunctionModel.setFunctionName(name);
                    calFunctionModel.setFunctionExpr(parseFormula.toString());
                    calFunctionModel.setChildExpr(params[0].toString());
                    list.add(calFunctionModel);
                }
                list.addAll(AutoFormulaUtils.parseFormula(childFormula));
            } else if (childFormula instanceof FunCall) {
                list.addAll(AutoFormulaUtils.parseFormula(childFormula));
            } else {
                CalFunctionModel calFunctionModel = new CalFunctionModel();
                calFunctionModel.setFunctionName(name);
                calFunctionModel.setFunctionExpr(parseFormula.toString());
                calFunctionModel.setChildExpr(params[0].toString());
                list.add(calFunctionModel);
            }
        } else if (parseFormula instanceof BinaryExpr) {
            BinaryExpr parseFormulaBinaryExpr = (BinaryExpr)parseFormula;
            Expr left = parseFormulaBinaryExpr.getLeft();
            list.addAll(AutoFormulaUtils.parseFormula(left));
            Expr right = parseFormulaBinaryExpr.getRight();
            list.addAll(AutoFormulaUtils.parseFormula(right));
        }
        return list;
    }

    public static void parseFilterLeft(Expr parseFormula, List<String> list) {
        if (parseFormula instanceof BinaryExpr) {
            Operator operator = ((BinaryExpr)parseFormula).getOperator();
            if (Operator.AND.equals(operator) || Operator.OR.equals(operator)) {
                Expr left = ((BinaryExpr)parseFormula).getLeft();
                AutoFormulaUtils.parseFilterLeft(left, list);
                Expr right = ((BinaryExpr)parseFormula).getRight();
                AutoFormulaUtils.parseFilterLeft(right, list);
            } else {
                Expr right;
                Expr left = ((BinaryExpr)parseFormula).getLeft();
                if (left instanceof CompoundId) {
                    list.add(left.toString());
                }
                if ((right = ((BinaryExpr)parseFormula).getRight()) instanceof CompoundId) {
                    list.add(right.toString());
                }
            }
        } else if (parseFormula instanceof Paren) {
            AutoFormulaUtils.parseFilterLeft(((Paren)parseFormula).getExpr(), list);
        }
    }

    public static List<String> parseFilter(String filter) {
        LinkedList<String> filterLeft = new LinkedList<String>();
        Expr filterFormula = FormulaHelper.parseFormula(filter);
        AutoFormulaUtils.parseFilterLeft(filterFormula, filterLeft);
        return filterLeft;
    }

    public static void buildFilterParam(SrmAutoCalCtxModel ctx, String newFilter) {
        Expr newFilterFormula = FormulaHelper.parseFormula(newFilter);
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        AutoFormulaUtils.buildFilterParam(newFilterFormula, sb, params, "fvar", 0);
        ctx.setAfterFilterParams(params);
        ctx.setAfterFilterExpr(sb.toString());
    }

    public static void buildBeforeFilterParam(String beforefilter, List<Object> list, StringBuilder sb) {
        Expr parseFormula = FormulaHelper.parseFormula(beforefilter);
        AutoFormulaUtils.buildFilterParam(parseFormula, sb, list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void buildFilterParam(Expr parseFormula, StringBuilder sb, Map<String, Object> map, String str, int i) {
        if (parseFormula == null) {
            return;
        }
        if (parseFormula instanceof BinaryExpr) {
            Operator operator = ((BinaryExpr)parseFormula).getOperator();
            String operatorStr = "";
            if (operator != null) {
                operatorStr = operator.toString();
            }
            if (Operator.AND.equals(operator) || Operator.OR.equals(operator)) {
                Expr left = ((BinaryExpr)parseFormula).getLeft();
                AutoFormulaUtils.buildFilterParam(left, sb, map, str, ++i);
                sb.append(" ").append(operatorStr).append(" ");
                Expr right = ((BinaryExpr)parseFormula).getRight();
                AutoFormulaUtils.buildFilterParam(right, sb, map, str, ++i);
                return;
            } else {
                Expr left = ((BinaryExpr)parseFormula).getLeft();
                Expr right = ((BinaryExpr)parseFormula).getRight();
                String leftStr = "";
                if (left != null) {
                    leftStr = left.toString();
                }
                String rightStr = "";
                if (right != null) {
                    rightStr = right.toString();
                }
                if (right instanceof CompoundId && left instanceof CompoundId) {
                    sb.append(" ").append(leftStr).append(operatorStr).append(rightStr);
                    return;
                } else {
                    if (right instanceof CompoundId || !(left instanceof CompoundId)) throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u5206\u7ec4\u540e\u8fc7\u6ee4\u5668\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_9", (String)"scm-srm-common", (Object[])new Object[0]));
                    Object tranValue = AutoFormulaUtils.tranValue(rightStr);
                    String param = str + i;
                    sb.append(" ").append(leftStr).append(operatorStr).append(param);
                    map.put(param, tranValue);
                }
            }
            return;
        } else {
            if (!(parseFormula instanceof Paren)) return;
            sb.append("(");
            AutoFormulaUtils.buildFilterParam(((Paren)parseFormula).getExpr(), sb, map, str, ++i);
            sb.append(")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void buildFilterParam(Expr parseFormula, StringBuilder sb, List<Object> list) {
        if (parseFormula == null) {
            return;
        }
        if (parseFormula instanceof BinaryExpr) {
            Operator operator = ((BinaryExpr)parseFormula).getOperator();
            if (Operator.AND.equals(operator) || Operator.OR.equals(operator)) {
                Expr left = ((BinaryExpr)parseFormula).getLeft();
                AutoFormulaUtils.buildFilterParam(left, sb, list);
                sb.append(" ").append(operator.toString()).append(" ");
                Expr right = ((BinaryExpr)parseFormula).getRight();
                AutoFormulaUtils.buildFilterParam(right, sb, list);
                return;
            } else {
                Expr left = ((BinaryExpr)parseFormula).getLeft();
                Expr right = ((BinaryExpr)parseFormula).getRight();
                String leftStr = "";
                if (left != null) {
                    leftStr = left.toString();
                }
                String rightStr = "";
                if (right != null) {
                    rightStr = right.toString();
                }
                String operatorStr = "";
                if (operator != null) {
                    operatorStr = operator.toString();
                }
                if (right instanceof CompoundId && left instanceof CompoundId) {
                    sb.append(" ").append(leftStr).append(operatorStr).append(rightStr);
                    return;
                } else {
                    if (right instanceof CompoundId || !(left instanceof CompoundId)) throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u5206\u7ec4\u524d\u8fc7\u6ee4\u5668\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AutoFormulaUtils_13", (String)"scm-srm-common", (Object[])new Object[0]));
                    sb.append(" ").append(leftStr).append(operatorStr).append("? ");
                    Object tranValue = AutoFormulaUtils.tranValue(rightStr);
                    list.add(tranValue);
                }
            }
            return;
        } else {
            if (!(parseFormula instanceof Paren)) return;
            sb.append("(");
            AutoFormulaUtils.buildFilterParam(((Paren)parseFormula).getExpr(), sb, list);
            sb.append(")");
        }
    }

    public static String getMetadataCode(DynamicObject dy) {
        DynamicObject metadataDynamicObject = dy.getDynamicObject(METADATA);
        if (metadataDynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u914d\u7f6e\u5143\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SrmAutoCalServiceImpl_3", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        return metadataDynamicObject.getString("number");
    }
}

