/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.srm.common.enums.SrmEvaDimensionEnum;
import kd.scm.srm.common.formula.model.CalFunctionModel;
import kd.scm.srm.common.formula.model.SrmAutoCalCtxModel;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.utils.AutoFormulaUtils;

public class SrmAutoCalCtxBuildUtils {
    private static final Log LOG = LogFactory.getLog(SrmAutoCalCtxBuildUtils.class);

    public static SrmAutoCalCtxModel buildCtx(SrmFormulaModel req, DynamicObject dy, Integer timeout) {
        SrmAutoCalCtxModel ctx = new SrmAutoCalCtxModel();
        String metadatacode = AutoFormulaUtils.getMetadataCode(dy);
        ctx.setTimeOut(timeout);
        ctx.setMetadataCode(metadatacode);
        String evalperiodfield = dy.getString("evalperiodfield");
        ctx.setDateField(evalperiodfield);
        BigDecimal defaultresult = dy.getBigDecimal("defaultresult");
        ctx.setDefaultresult(defaultresult);
        QFilter beforeQFilterByAlgo = SrmAutoCalCtxBuildUtils.buildQFilter(dy, req);
        ctx.setBeforeQFilter(beforeQFilterByAlgo);
        Map<String, String> groupbyMap = AutoFormulaUtils.buildGroupByFields(dy, req);
        SrmAutoCalCtxBuildUtils.buildGroupByMap(ctx, groupbyMap);
        SrmAutoCalCtxBuildUtils.buildQueryByField(dy, ctx, groupbyMap.values());
        SrmAutoCalCtxBuildUtils.buildOrderBy(dy, ctx);
        SrmAutoCalCtxBuildUtils.buildExprFunctions(dy, ctx);
        SrmAutoCalCtxBuildUtils.buildAfterFilters(dy, ctx);
        SrmAutoCalCtxBuildUtils.buildDefaultFilters(dy, ctx);
        return ctx;
    }

    private static void buildDefaultFilters(DynamicObject dy, SrmAutoCalCtxModel ctx) {
        String defaultfilter = dy.getString("defaulfilter");
        ctx.setDefaultfilter(defaultfilter);
    }

    private static void buildOrderBy(DynamicObject dy, SrmAutoCalCtxModel ctx) {
        String conditionorderbyfield = dy.getString("orderbyfield");
        String conditionorderbytype = dy.getString("orderbytype");
        String orderBy = null;
        if (StringUtils.isNotEmpty((String)conditionorderbyfield)) {
            orderBy = conditionorderbyfield + " " + conditionorderbytype;
            ctx.setOrderby(orderBy);
        }
    }

    private static void buildGroupByMap(SrmAutoCalCtxModel ctx, Map<String, String> groupbyMap) {
        String groupbyJoin = String.join((CharSequence)",", groupbyMap.keySet());
        if (LOG.isDebugEnabled()) {
            LOG.info("groupby\u5b57\u6bb5\u5904\u7406={}", (Object)groupbyJoin);
        }
        ctx.setGroupFields(groupbyJoin);
    }

    private static QFilter buildTopLevelQFilter(DynamicObject dy, SrmFormulaModel req) {
        String beforefilter;
        String evalperiodfield;
        Long orgId = req.getOrgId();
        Date startDate = req.getStartDate();
        Date endDate = req.getEndDate();
        String orgfield = dy.getString("orgfield");
        QFilter filter = QFilter.of((String)"1==1", (Object[])new Object[0]);
        Boolean includesuborg = dy.getBoolean("includesuborg");
        if (StringUtils.isNotEmpty((String)orgfield)) {
            if (includesuborg.booleanValue()) {
                ArrayList<Long> orgIds = new ArrayList<Long>(8);
                orgIds.add(orgId);
                List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)Boolean.TRUE);
                filter.and(orgfield, "in", (Object)subOrgIds);
            } else {
                filter.and(orgfield, "=", (Object)orgId);
            }
        }
        if (StringUtils.isNotEmpty((String)(evalperiodfield = dy.getString("evalperiodfield")))) {
            filter.and(new QFilter(evalperiodfield, ">=", (Object)startDate));
            filter.and(new QFilter(evalperiodfield, "<=", (Object)endDate));
        }
        if (StringUtils.isNotEmpty((String)(beforefilter = dy.getString("beforefilter")))) {
            QFilter filter0 = QFilter.of((String)"1==1", (Object[])new Object[0]);
            LinkedList<Object> list = new LinkedList<Object>();
            StringBuilder sb = new StringBuilder();
            AutoFormulaUtils.buildBeforeFilterParam(beforefilter, list, sb);
            filter0.and(QFilter.of((String)sb.toString(), (Object[])list.toArray()));
            filter.and(filter0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("\u5206\u7ec4\u524d\u56fa\u5b9a\u67e5\u8be2\u5b57\u6bb5\u5904\u7406\u7ed3\u679c={}", (Object)filter.toString());
        }
        return filter;
    }

    private static QFilter buildQFilter(DynamicObject dy, SrmFormulaModel req) {
        QFilter filter = SrmAutoCalCtxBuildUtils.buildTopLevelQFilter(dy, req);
        String supplierfield = dy.getString("supplierfield");
        String materialfield = dy.getString("materialfield");
        String categoryfield = dy.getString("categoryfield");
        String defaultfilter = dy.getString("defaulfilter");
        String evaDimension = req.getEvaDimension();
        if (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension)) {
            filter.and(supplierfield, "=", (Object)req.getSupplierId());
            if (StringUtils.isEmpty((String)defaultfilter) || "A".equals(defaultfilter)) {
                if (req.isBatch()) {
                    ArrayList<Long> list = new ArrayList<Long>(req.getMaterialIds().keySet());
                    filter.and(materialfield, "in", list);
                } else {
                    filter.and(new QFilter(materialfield, "=", (Object)req.getMaterialId()));
                }
            }
        } else if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension)) {
            filter.and(supplierfield, "=", (Object)req.getSupplierId());
            if (StringUtils.isEmpty((String)defaultfilter) || "A".equals(defaultfilter)) {
                if (req.isBatch()) {
                    ArrayList<Long> list = new ArrayList<Long>(req.getCategoryIds().keySet());
                    filter.and(categoryfield, "in", list);
                } else {
                    filter.and(new QFilter(categoryfield, "=", (Object)req.getCategoryId()));
                }
            }
        } else if (StringUtils.isEmpty((String)defaultfilter) || "A".equals(defaultfilter)) {
            if (req.isBatch()) {
                ArrayList<Long> list = new ArrayList<Long>(req.getSupplierIds().keySet());
                filter.and(supplierfield, "in", list);
            } else {
                filter.and(supplierfield, "=", (Object)req.getSupplierId());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("filter\u5b57\u6bb5\u5904\u7406\u7ed3\u679c={}", (Object)filter.toString());
        }
        return filter;
    }

    private static void buildQueryByField(DynamicObject dy, SrmAutoCalCtxModel ctx, Collection<String> groupbyCol) {
        String formulapreview = dy.getString("childformula");
        String filter = dy.getString("filter");
        String orderby = dy.getString("orderbyfield");
        String groupbyJoin = String.join((CharSequence)",", groupbyCol);
        String queryfield = AutoFormulaUtils.getQueryField(formulapreview);
        String filterfield = AutoFormulaUtils.getQueryField(filter);
        String queryFields = AutoFormulaUtils.buildQueryField(queryfield, filterfield, orderby, groupbyJoin);
        if (LOG.isDebugEnabled()) {
            LOG.info("query\u5b57\u6bb5\u5904\u7406\u7ed3\u679c={}", (Object)queryFields);
        }
        ctx.setQueryFields(queryFields);
    }

    private static void buildAfterFilters(DynamicObject dy, SrmAutoCalCtxModel ctx) {
        String filter = dy.getString("filter");
        List<CalFunctionModel> functions = ctx.getFunctions();
        if (CollectionUtils.isEmpty(functions)) {
            functions = new ArrayList<CalFunctionModel>(8);
        }
        if (StringUtils.isNotEmpty((String)filter)) {
            String newFilter = filter;
            List<String> filterLeft = AutoFormulaUtils.parseFilter(filter);
            if (!CollectionUtils.isEmpty(filterLeft)) {
                for (int j = 0; j < filterLeft.size(); ++j) {
                    String key = filterLeft.get(j);
                    String alias = "filter" + j;
                    newFilter = newFilter.replace(key, alias);
                    CalFunctionModel model = new CalFunctionModel();
                    model.setChildExpr(key);
                    model.setFunctionExpr("sum(" + key + ")");
                    model.setFunctionName("sum");
                    model.setAlias(alias);
                    functions.add(model);
                }
            }
            ctx.setFunctions(functions);
            AutoFormulaUtils.buildFilterParam(ctx, newFilter);
            if (LOG.isDebugEnabled()) {
                LOG.info("\u5206\u7ec4\u540e\u5b57\u6bb5\u5904\u7406={}", (Object)JSON.toJSONString(functions));
            }
        }
    }

    private static void buildExprFunctions(DynamicObject dy, SrmAutoCalCtxModel ctx) {
        String formulapreview = dy.getString("childformula");
        Map<String, List<CalFunctionModel>> calFunctionMap = AutoFormulaUtils.getCalFunctionMaps(formulapreview);
        if (CollectionUtils.isEmpty(calFunctionMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u8868\u8fbe\u5f0f\u672a\u89e3\u6790\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SrmAutoCalCtxBuildUtils_0", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        Optional findFirst = calFunctionMap.keySet().stream().findFirst();
        StringBuilder sb = new StringBuilder();
        sb.append(ctx.getQueryFields());
        if (findFirst.isPresent()) {
            String newExpr = (String)findFirst.get();
            List<CalFunctionModel> calFunctions = calFunctionMap.get(newExpr);
            for (int j = 0; j < calFunctions.size(); ++j) {
                CalFunctionModel calFunction = calFunctions.get(j);
                String alias = calFunction.getChildExpr();
                calFunction.setAlias(alias);
                sb.append(",(").append(calFunction.getChildExpr()).append(") ").append(alias);
                newExpr = newExpr.replace(calFunction.getFunctionExpr(), alias);
            }
            ctx.setExpr(newExpr);
            ctx.setFunctions(calFunctions);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("\u8868\u8fbe\u5f0f\u5b57\u6bb5\u5904\u7406={}", (Object)JSON.toJSONString(calFunctionMap));
        }
    }
}

