/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.srm.common.enums.SrmEvaDimensionEnum;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.model.CalFunctionModel;
import kd.scm.srm.common.formula.model.SrmAutoCalCtxModel;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.utils.AutoFormulaUtils;
import kd.scm.srm.common.formula.utils.FormulaHelper;

public class SrmDataSetTranFormUtils {
    private static final Log log = LogFactory.getLog(SrmDataSetTranFormUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SrmGetAutoScoreReq dataSetChangeToMap(DataSet dataSet, SrmFormulaModel req, SrmAutoCalCtxModel ctx) {
        HashMap result = new HashMap(8);
        log.info("==============DataSet\u8f6c\u6362\u5f00\u59cb==============");
        try {
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(row -> {
                    Map<String, Object> varMap = SrmDataSetTranFormUtils.setVarMap(ctx, row);
                    BigDecimal curResult = FormulaHelper.execFormula(ctx.getExpr(), varMap);
                    String defaultfilter = ctx.getDefaultfilter();
                    if (curResult != null && StringUtils.isNotEmpty((String)defaultfilter) && !"A".equals(defaultfilter)) {
                        if (result.isEmpty()) {
                            result.put("result", curResult);
                        } else {
                            BigDecimal middle = (BigDecimal)result.get("result");
                            result.put("result", middle.add(curResult));
                        }
                    } else if (curResult != null) {
                        if (result.isEmpty()) {
                            result.put("result", curResult);
                        } else if (StringUtils.isEmpty((String)ctx.getOrderby())) {
                            BigDecimal middle = (BigDecimal)result.get("result");
                            result.put("result", middle.add(curResult));
                        }
                    }
                });
            }
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
        }
        SrmGetAutoScoreReq autoFormulaResp = new SrmGetAutoScoreReq();
        autoFormulaResp.setSupplierId(req.getSupplierId());
        autoFormulaResp.setMaterialId(req.getMaterialId());
        autoFormulaResp.setCategoryId(req.getCategoryId());
        if (CollectionUtils.isEmpty(result)) {
            autoFormulaResp.setResult(SrmDataSetTranFormUtils.setDefaultByValue(ctx));
        } else {
            autoFormulaResp.setResult((BigDecimal)result.get("result"));
        }
        autoFormulaResp.setScoreTaskId(req.getScoreTaskId());
        autoFormulaResp.setIndexScoreDetailId(req.getIndexScoreDetailId());
        autoFormulaResp.setIndexId(req.getIndexId());
        log.info("SrmAutoCalServiceImpl dataSetChangeToMap resp:{} ", (Object)JSON.toJSONString((Object)autoFormulaResp));
        log.info("==============DataSet\u8f6c\u6362\u7ed3\u675f==============");
        return autoFormulaResp;
    }

    private static BigDecimal setDefaultByValue(SrmAutoCalCtxModel ctx) {
        BigDecimal defaultResult = ctx.getDefaultresult();
        if (defaultResult != null && defaultResult.compareTo(AutoFormulaUtils.DEFALULT_VALUE_VAL) != 0) {
            return defaultResult;
        }
        return SrmDataSetTranFormUtils.setDefaultByCount(ctx);
    }

    private static BigDecimal setDefaultByCount(SrmAutoCalCtxModel ctx) {
        String functionName;
        List<CalFunctionModel> functions = ctx.getFunctions();
        if (!CollectionUtils.isEmpty(functions) && ("count".equals(functionName = functions.get(0).getFunctionName()) || "countDistinct".equals(functionName))) {
            return BigDecimal.ZERO;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SrmGetAutoScoreReq> dataSetChangeToMapBatch(DataSet dataSet, SrmFormulaModel req, DynamicObject dy, SrmAutoCalCtxModel ctx) {
        log.info("==============DataSet\u8f6c\u6362\u5f00\u59cb==============");
        ArrayList<SrmGetAutoScoreReq> resultList = new ArrayList<SrmGetAutoScoreReq>(8);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(8);
        String defaultfilter = ctx.getDefaultfilter();
        try {
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(row -> {
                    Long supplierId = 0L;
                    Long materialId = 0L;
                    if (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(req.getEvaDimension())) {
                        materialId = row.getLong("group0");
                        supplierId = req.getSupplierId();
                    } else if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(req.getEvaDimension())) {
                        materialId = row.getLong("group0");
                        supplierId = req.getSupplierId();
                    } else {
                        supplierId = row.getLong("group0");
                    }
                    Map<String, Object> varMap = SrmDataSetTranFormUtils.setVarMap(ctx, row);
                    BigDecimal curResult = FormulaHelper.execFormula(ctx.getExpr(), varMap);
                    curResult = curResult.setScale(10, RoundingMode.HALF_UP);
                    String key = AutoFormulaUtils.buildHashKey(req.getOrgId(), req.getEvaDimension(), supplierId, materialId);
                    log.info("\u6309\u7ec4\u7ec7+\u4f9b\u5e94\u5546+\u7269\u6599\u751f\u6210\u7684key\u4e3a:{}", (Object)key);
                    if (curResult != null && StringUtils.isNotEmpty((String)defaultfilter) && !"A".equals(defaultfilter)) {
                        if (!result.containsKey(key)) {
                            result.put(key, curResult);
                        } else {
                            BigDecimal subResult = (BigDecimal)result.get(key);
                            result.put(key, curResult.add(subResult));
                        }
                    } else if (curResult != null) {
                        if (!result.containsKey(key)) {
                            result.put(key, curResult);
                        } else if (StringUtils.isEmpty((String)ctx.getOrderby())) {
                            BigDecimal subResult = (BigDecimal)result.get(key);
                            result.put(key, curResult.add(subResult));
                        }
                    }
                    log.info("SrmAutoCalServiceImpl dataSetChangeToMap resp:{} ", (Object)JSON.toJSONString((Object)result));
                });
            }
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
        }
        Long orgId = req.getOrgId();
        String evaDimension = req.getEvaDimension();
        if (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension)) {
            Long supplierId = req.getSupplierId();
            Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> materialIds = req.getMaterialIds();
            for (Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> entry : materialIds.entrySet()) {
                Long materialId = entry.getKey();
                SrmGetAutoScoreReq autoFormulaResp = SrmDataSetTranFormUtils.buildAudoFormulaReq(ctx, result, entry, evaDimension, defaultfilter, orgId, supplierId, null, materialId);
                resultList.add(autoFormulaResp);
            }
        } else if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension)) {
            Long supplierId = req.getSupplierId();
            Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> categoryIds = req.getCategoryIds();
            for (Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> entry : categoryIds.entrySet()) {
                Long categoryId = entry.getKey();
                SrmGetAutoScoreReq autoFormulaResp = SrmDataSetTranFormUtils.buildAudoFormulaReq(ctx, result, entry, evaDimension, defaultfilter, orgId, supplierId, categoryId, null);
                resultList.add(autoFormulaResp);
            }
        } else {
            Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> supplierIds = req.getSupplierIds();
            for (Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> entry : supplierIds.entrySet()) {
                Long supplierId = entry.getKey();
                SrmGetAutoScoreReq autoFormulaResp = SrmDataSetTranFormUtils.buildAudoFormulaReq(ctx, result, entry, evaDimension, defaultfilter, orgId, supplierId, null, null);
                resultList.add(autoFormulaResp);
            }
        }
        log.info("==============DataSet\u8f6c\u6362\u7ed3\u675f==============");
        return resultList;
    }

    private static SrmGetAutoScoreReq buildAudoFormulaReq(SrmAutoCalCtxModel ctx, Map<String, BigDecimal> result, Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> entry, String evaDimension, String defaultfilter, Long orgId, Long supplierId, Long categoryId, Long materialId) {
        List<SrmAutoFormulaReq.SrmAutoFormulaData> list = entry.getValue();
        SrmGetAutoScoreReq autoFormulaResp = new SrmGetAutoScoreReq();
        if (!CollectionUtils.isEmpty(list)) {
            SrmAutoFormulaReq.SrmAutoFormulaData srmAutoFormulaData = list.get(0);
            autoFormulaResp.setIndexScoreDetailId(srmAutoFormulaData.getIndexScoreDetailId());
            autoFormulaResp.setScoreTaskId(srmAutoFormulaData.getScoreTaskId());
            autoFormulaResp.setIndexId(srmAutoFormulaData.getIndexId());
        }
        autoFormulaResp.setMaterialId(materialId);
        autoFormulaResp.setCategoryId(categoryId);
        autoFormulaResp.setSupplierId(supplierId);
        if (CollectionUtils.isEmpty(result)) {
            autoFormulaResp.setResult(SrmDataSetTranFormUtils.setDefaultByValue(ctx));
        } else {
            String defaultKey = "result";
            if (StringUtils.isNotEmpty((String)defaultfilter) && "A".equals(defaultfilter)) {
                String key = "";
                key = SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension) ? AutoFormulaUtils.buildHashKey(orgId, evaDimension, supplierId, materialId) : (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension) ? AutoFormulaUtils.buildHashKey(orgId, evaDimension, supplierId, categoryId) : AutoFormulaUtils.buildHashKey(orgId, evaDimension, supplierId, 0L));
                BigDecimal resultValue = result.get(key);
                if (resultValue == null) {
                    autoFormulaResp.setResult(SrmDataSetTranFormUtils.setDefaultByValue(ctx));
                } else {
                    autoFormulaResp.setResult(resultValue);
                }
            } else {
                autoFormulaResp.setResult(result.get(defaultKey));
            }
        }
        return autoFormulaResp;
    }

    public static DataSet transFormDataSet(DataSet dataSet, SrmAutoCalCtxModel ctx) {
        String groupfields = ctx.getGroupFields();
        if (StringUtils.isNotEmpty((String)groupfields)) {
            String[] groupby = groupfields.split(",");
            GroupbyDataSet groupBy = dataSet.groupBy(groupby);
            List<CalFunctionModel> functions = ctx.getFunctions();
            if (CollectionUtils.isEmpty(functions)) {
                return dataSet;
            }
            for (CalFunctionModel function : functions) {
                String childExpr = SrmDataSetTranFormUtils.getChildExpr(function.getChildExpr());
                groupBy = SrmDataSetTranFormUtils.buildGroupDataSet(groupBy, function.getFunctionName(), childExpr, childExpr);
            }
            DataSet finishDataSet = groupBy.finish();
            if (finishDataSet.isEmpty()) {
                return null;
            }
            Map<String, Object> params = ctx.getAfterFilterParams();
            String newAfterFilterExpr = ctx.getAfterFilterExpr();
            if (StringUtils.isNotEmpty((String)newAfterFilterExpr)) {
                finishDataSet = CollectionUtils.isEmpty(params) ? finishDataSet.filter(newAfterFilterExpr) : finishDataSet.filter(newAfterFilterExpr, params);
            }
            return finishDataSet;
        }
        return dataSet;
    }

    private static Map<String, Object> setVarMap(SrmAutoCalCtxModel ctx, Row row) {
        HashMap<String, Object> varMap = new HashMap<String, Object>(8);
        List<CalFunctionModel> functions = ctx.getFunctions();
        if (CollectionUtils.isEmpty(functions)) {
            String[] vars;
            for (String str : vars = FormulaHelper.extractVariables(ctx.getExpr())) {
                Object value = row.get(str);
                varMap.put(str, value);
            }
        }
        for (CalFunctionModel function : functions) {
            String[] vars;
            for (String str : vars = FormulaHelper.extractVariables(function.getChildExpr())) {
                Object value = row.get(str);
                varMap.put(str, value);
            }
        }
        return varMap;
    }

    private static String getChildExpr(String childExpr) {
        Expr parseFormula = FormulaHelper.parseFormula(childExpr);
        if (parseFormula instanceof BinaryExpr) {
            BinaryExpr expr = (BinaryExpr)parseFormula;
            Expr left = expr.getLeft();
            Expr right = expr.getRight();
            if (left.toString().equals("now()")) {
                childExpr = right.toString();
            } else if (right.toString().equals("now()")) {
                childExpr = left.toString();
            }
        }
        return childExpr;
    }

    public static void buildFilterFunctions(Map<String, CalFunctionModel> functions, Map<String, String> filterAliasMap) {
        if (!CollectionUtils.isEmpty(filterAliasMap)) {
            for (Map.Entry<String, String> entry : filterAliasMap.entrySet()) {
                String alias = entry.getKey();
                String filerExpr = entry.getValue();
                CalFunctionModel model = new CalFunctionModel();
                model.setChildExpr(filerExpr);
                model.setFunctionExpr("sum(" + filerExpr + ")");
                model.setFunctionName("sum");
                functions.put(alias, model);
            }
        }
    }

    public static GroupbyDataSet buildGroupDataSet(GroupbyDataSet groupBy, String function, String column, String alias) {
        switch (function) {
            case "sum": {
                groupBy = groupBy.sum(column, alias);
                break;
            }
            case "avg": {
                groupBy = groupBy.avg(column, alias);
                break;
            }
            case "min": {
                groupBy = groupBy.min(column, alias);
                break;
            }
            case "max": {
                groupBy = groupBy.max(column, alias);
                break;
            }
            case "count": {
                groupBy = groupBy.count(column);
                break;
            }
            case "countDistinct": {
                groupBy = groupBy.countDistinct(new String[]{column});
                break;
            }
        }
        return groupBy;
    }
}

