/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.scm.srm.common.formula.model.CalFunctionModel;
import kd.scm.srm.common.formula.utils.FormulaHelper;

public class SrmReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 3872395037778332642L;
    private RowMeta srcRowMeta;
    private RowMeta tarRowMeta;
    private List<CalFunctionModel> functions;

    public SrmReduceGroupFunction(RowMeta srcRowMeta, RowMeta tarRowMeta, List<CalFunctionModel> functions) {
        this.srcRowMeta = srcRowMeta;
        this.tarRowMeta = tarRowMeta;
        this.functions = functions;
    }

    public RowMeta getResultRowMeta() {
        return this.tarRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        RowX resultRow = new RowX(this.tarRowMeta.getFieldCount());
        Integer sumRowIndex = 0;
        HashMap<String, BigDecimal> sum = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(8);
        for (RowX row : rows) {
            for (String field : this.srcRowMeta.getFieldNames()) {
                int fieldIndex = this.srcRowMeta.getFieldIndex(field);
                Object object = row.get(fieldIndex);
                int fieldIndexNew = this.tarRowMeta.getFieldIndex(field);
                resultRow.set(fieldIndexNew, object);
            }
            Integer n = sumRowIndex;
            Integer n2 = sumRowIndex = Integer.valueOf(sumRowIndex + 1);
            for (CalFunctionModel function : this.functions) {
                String alias = function.getAlias();
                String childExpr = function.getChildExpr();
                String functionName = function.getFunctionName();
                String[] vars = FormulaHelper.extractVariables(childExpr);
                HashMap<String, Object> varMap = new HashMap<String, Object>(8);
                for (String str : vars) {
                    int fieldIndex = this.srcRowMeta.getFieldIndex(str);
                    Object value = row.get(fieldIndex);
                    varMap.put(str, value);
                }
                BigDecimal execFormula = FormulaHelper.execFormula(childExpr, varMap);
                BigDecimal res = BigDecimal.ZERO;
                if ("avg".equals(functionName)) {
                    BigDecimal addSum = this.function("sum", (BigDecimal)sum.get(alias), execFormula);
                    sum.put(alias, addSum);
                    res = this.function(functionName, addSum, BigDecimal.valueOf(sumRowIndex.intValue()));
                } else {
                    res = this.function(functionName, (BigDecimal)result.get(alias), execFormula);
                }
                result.put(alias, res);
                int fieldIndex = this.tarRowMeta.getFieldIndex(alias);
                resultRow.set(fieldIndex, (Object)res);
            }
        }
        out.collect(resultRow);
    }

    private BigDecimal function(String functionName, BigDecimal temp, BigDecimal execFormula) {
        if (temp == null) {
            temp = BigDecimal.ZERO;
        }
        switch (functionName) {
            case "sum": {
                temp = temp.add(execFormula);
                break;
            }
            case "min": {
                if (BigDecimal.ZERO.compareTo(temp) != 0 && execFormula.compareTo(temp) >= 0) break;
                temp = execFormula;
                break;
            }
            case "max": {
                if (BigDecimal.ZERO.compareTo(temp) != 0 && execFormula.compareTo(temp) <= 0) break;
                temp = execFormula;
                break;
            }
            case "avg": {
                temp = temp.divide(execFormula, RoundingMode.HALF_DOWN);
                break;
            }
            default: {
                temp = execFormula;
            }
        }
        return temp;
    }
}

