/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.service.imp;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.isc.util.ApiOperateUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.srm.common.service.AbstractSrmCategoryInvoke;
import kd.scm.srm.common.service.SrmInvokeServive;

public class SrmCateGoryAddXkInvokeImp
extends AbstractSrmCategoryInvoke
implements SrmInvokeServive<Object, Map<String, Object>, Map<String, Object>> {
    private static Log log = LogFactory.getLog(SrmCateGoryAddXkInvokeImp.class);

    @Override
    public Object bulidReq(Object req) {
        HashMap outdata = new HashMap(12);
        HashMap data = new HashMap(12);
        if (Objects.isNull(req)) {
            return null;
        }
        List dysReq = (List)req;
        List<Map<String, Object>> addXkReq = this.bulidReqXk(dysReq);
        for (Map<String, Object> map : addXkReq) {
            HashMap<String, Object> entryMap = new HashMap<String, Object>(12);
            HashMap entrys = new HashMap(12);
            HashMap<String, String> parm = new HashMap<String, String>(12);
            Object org = map.get("org");
            Object sup = map.get("supplier");
            Object id = map.get("id");
            Object expirydate = map.get("expirydate");
            Object effectdate = map.get("effectdate");
            Object material = map.get("material");
            if (Objects.isNull(id) || Objects.isNull(material)) continue;
            parm.put("material", material.toString());
            if (Objects.nonNull(sup)) {
                parm.put("supplier", sup.toString());
            }
            if (Objects.nonNull(effectdate)) {
                parm.put("dateto", DateUtil.date2str((Date)((Date)expirydate), (String)"yyyy-MM-dd"));
            }
            if (Objects.nonNull(expirydate)) {
                parm.put("datefrom", DateUtil.date2str((Date)((Date)effectdate), (String)"yyyy-MM-dd"));
            }
            entrys.put(id.toString(), parm);
            entryMap.put("entry", entrys);
            if (Objects.nonNull(org)) {
                entryMap.put("purorg", org.toString());
            }
            data.put(id.toString(), entryMap);
        }
        outdata.put("data", data);
        return outdata;
    }

    @Override
    public Map<String, Object> dealInvoke(Object req) {
        if (Objects.isNull(req)) {
            return null;
        }
        Map reqXk = (Map)req;
        if (reqXk.size() == 0) {
            return null;
        }
        Object data = reqXk.get("data");
        Map dataValue = (Map)data;
        if (CollectionUtils.isEmpty((Map)dataValue)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap(12);
        try {
            String resultOb = ApiOperateUtil.doExec((Map)reqXk, null, (String)"doEffectPurCatalog");
            result = (Map)JacksonJsonUtil.fromJSON((String)resultOb, Map.class);
        }
        catch (Exception e) {
            log.error("SrmCateGoryAddXkInvokeImp doEffectPurCatalog is fail e:" + e.getMessage());
            Set keySet = ((Map)data).keySet();
            List<Long> reIds = keySet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            this.updateSynchrosourcelist(reIds, Boolean.FALSE);
            return null;
        }
        return result;
    }

    @Override
    public Map<String, Object> dealRsp(Map<String, Object> rsp, Object req) {
        HashMap<String, Object> result = new HashMap<String, Object>(32);
        if (Objects.isNull(req)) {
            return result;
        }
        Map reqXk = (Map)req;
        if (reqXk.size() <= 0) {
            return result;
        }
        if (CollectionUtils.isEmpty(rsp)) {
            log.info("SrmCateGoryAddXkInvokeImp dealRsp rsp  is Empty");
            if (!CollectionUtils.isEmpty((Map)reqXk)) {
                result.put("total", reqXk.size());
                result.put("success", 0);
            }
            return result;
        }
        log.info("SrmCateGoryAddXkInvokeImp dealRsp :" + rsp.toString());
        Set<Map.Entry<String, Object>> entries = rsp.entrySet();
        int successNum = 0;
        StringBuilder failMessage = new StringBuilder(32);
        ArrayList<Long> successIds = new ArrayList<Long>(12);
        for (Map.Entry<String, Object> entry : entries) {
            String Msg_Catalog;
            String id = entry.getKey();
            Object valueMap = entry.getValue();
            if (!(valueMap instanceof Map)) continue;
            Map value = (Map)valueMap;
            String status_catalog = (String)value.get("status_Catalog");
            if ("200".equals(status_catalog)) {
                ++successNum;
                successIds.add(Long.valueOf(id));
                continue;
            }
            String error_catalog = (String)value.get("error_Catalog");
            if (!StringUtils.isEmpty((Object)error_catalog)) {
                failMessage.append(error_catalog).append("\n");
            }
            if (StringUtils.isEmpty((Object)(Msg_Catalog = (String)value.get("Msg_Catalog")))) continue;
            failMessage.append(Msg_Catalog).append("\n");
        }
        if (successIds.size() > 0) {
            this.updateSynchrosourcelist(successIds, Boolean.TRUE);
        }
        result.put("success", successNum);
        result.put("total", reqXk.size());
        if (failMessage.length() > 0) {
            result.put("message", failMessage.toString());
        }
        return result;
    }

    public List<Map<String, Object>> bulidReqXk(List<DynamicObject> selectedRows) {
        ArrayList<Map<String, Object>> addXkReq = new ArrayList<Map<String, Object>>(selectedRows.size());
        ArrayList<Long> materialIds = new ArrayList<Long>(12);
        ArrayList<Long> supIds = new ArrayList<Long>(12);
        ArrayList<Long> orgIds = new ArrayList<Long>(12);
        for (DynamicObject selectedRow : selectedRows) {
            long supId = selectedRow.getLong("supplier_id");
            long orgId = selectedRow.getLong("org_id");
            long materialId = selectedRow.getLong("material_id");
            boolean issourcelist = selectedRow.getBoolean("issourcelist");
            String status = selectedRow.getString("auditstatus");
            if (!issourcelist) continue;
            if (0L != materialId && "1".equals(status)) {
                materialIds.add(materialId);
            }
            supIds.add(supId);
            orgIds.add(orgId);
        }
        if (materialIds.size() == 0) {
            return addXkReq;
        }
        DynamicObjectCollection srmSups = QueryServiceHelper.query((String)"srm_supplier", (String)"id,number,supplier.number", (QFilter[])new QFilter[]{new QFilter("id", "in", supIds)});
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
        Map<Long, List<DynamicObject>> srmSupsMap = srmSups.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
        Map<Long, List<DynamicObject>> orgsMap = orgs.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
        Map<Long, List<DynamicObject>> materialsMap = materials.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
        for (DynamicObject dataEntity : selectedRows) {
            List<DynamicObject> material;
            List<DynamicObject> org;
            HashMap<String, Object> reqMap = new HashMap<String, Object>();
            long supId = dataEntity.getLong("supplier_id");
            long orgId = dataEntity.getLong("org_id");
            long materialId = dataEntity.getLong("material_id");
            String status = dataEntity.getString("auditstatus");
            if (0L == materialId || !"1".equals(status)) continue;
            List<DynamicObject> sups = srmSupsMap.get(supId);
            if (!CollectionUtils.isEmpty(sups)) {
                String number = sups.get(0).getString("supplier.number");
                reqMap.put("supplier", number);
            }
            if (!CollectionUtils.isEmpty(org = orgsMap.get(orgId))) {
                String number = org.get(0).getString("number");
                reqMap.put("org", number);
            }
            if (!CollectionUtils.isEmpty(material = materialsMap.get(materialId))) {
                String number = material.get(0).getString("number");
                reqMap.put("material", number);
            }
            reqMap.put("effectdate", dataEntity.getDate("effectdate"));
            reqMap.put("expirydate", dataEntity.getDate("expirydate"));
            reqMap.put("id", dataEntity.getPkValue());
            addXkReq.add(reqMap);
        }
        return addXkReq;
    }
}

