/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.util;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.srm.common.constant.SrmConstant;

public class AccessNodeUtil {
    public static Map<String, DynamicObject> getNodeNumberMap(String preset, String mandatory) {
        QFilter qFilter = new QFilter("status", "=", (Object)"1");
        if ("1".equals(preset)) {
            qFilter.and("preset", "=", (Object)preset);
        }
        if ("1".equals(mandatory)) {
            qFilter.and("mandatory", "=", (Object)mandatory);
        }
        String selectFields = "id,bizobject,mandatory,preset";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"srm_accessnode", (String)selectFields, (QFilter[])qFilter.toArray());
        HashMap<String, DynamicObject> nodeNumberMap = new HashMap<String, DynamicObject>(dynamicObjects.length);
        for (DynamicObject dyn : dynamicObjects) {
            String number = dyn.getString("bizobject_id");
            nodeNumberMap.put(number, dyn);
        }
        return nodeNumberMap;
    }

    public static Map<String, DynamicObject> getExistNumberMap(DynamicObjectCollection dynList) {
        LinkedHashMap<String, DynamicObject> oldNodeMap = new LinkedHashMap<String, DynamicObject>(5);
        if (dynList != null && !dynList.isEmpty()) {
            for (DynamicObject dyn : dynList) {
                DynamicObject accessnode;
                DynamicProperty temp = dyn.getDynamicObjectType().getProperty(SrmConstant.ACCESS_NODE);
                if (temp == null || (accessnode = dyn.getDynamicObject(SrmConstant.ACCESS_NODE)) == null) continue;
                String number = accessnode.getString("bizobject_id");
                oldNodeMap.put(number, dyn);
            }
        }
        return oldNodeMap;
    }

    public static void sortAccessNode(DynamicObject billObject, String entryKey, boolean addAptitudeexam) {
        DynamicObjectCollection entrys = billObject.getDynamicObjectCollection(entryKey);
        if (entrys != null && !entrys.isEmpty()) {
            Date billdate = null;
            if (!addAptitudeexam && billObject.getDynamicObjectType().getProperty("billdate") != null) {
                billdate = billObject.getDate("billdate");
            }
            Map<String, DynamicObject> existNumberMap = AccessNodeUtil.getExistNumberMap(entrys);
            DynamicObject aptitudeexam = existNumberMap.remove("srm_aptitudeexam");
            DynamicObject supapprove = existNumberMap.remove("srm_supapprove");
            entrys.clear();
            if (addAptitudeexam) {
                AccessNodeUtil.addNodeEntry(entrys, aptitudeexam, billdate);
            }
            if (!existNumberMap.isEmpty()) {
                for (DynamicObject temp : existNumberMap.values()) {
                    AccessNodeUtil.addNodeEntry(entrys, temp, billdate);
                }
            }
            AccessNodeUtil.addNodeEntry(entrys, supapprove, billdate);
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)billObject, (String)entryKey);
        }
    }

    private static void addNodeEntry(DynamicObjectCollection entrys, DynamicObject entry, Date billdate) {
        if (entry != null) {
            if (billdate != null) {
                entry.set("nodebilldate", (Object)billdate);
            }
            entrys.add((Object)entry);
        }
    }
}

