/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.JacksonJsonUtil;

public class BuildUrlToSrm
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(BuildUrlToSrm.class);
    private Map<String, String> BILL_FORM_ID = new HashMap<String, String>(32);

    public BuildUrlToSrm() {
        this.BILL_FORM_ID.put("srm_scorerpt", "adm_score");
        this.BILL_FORM_ID.put("srm_improve", "adm_improve");
        this.BILL_FORM_ID.put("srm_examine", "adm_examine");
        this.BILL_FORM_ID.put("srm_samplenotify", "adm_samplenotify_in");
        this.BILL_FORM_ID.put("srm_evaplan", "srm_scorehelper");
        this.BILL_FORM_ID.put("adm_questioncomp", "srm_supquestion");
        this.BILL_FORM_ID.put("srm_evaplan_batch", "srm_scorehelper_inh");
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> map;
        block8: {
            String domainContextUrl;
            block7: {
                map = new HashMap<String, String>(8);
                domainContextUrl = UrlService.getDomainContextUrl();
                if (!domainContextUrl.endsWith("/")) {
                    System.lineSeparator();
                    domainContextUrl = domainContextUrl + "/";
                }
                if (!(evt instanceof EntityEvent)) break block7;
                EntityEvent entityEvent = (EntityEvent)evt;
                String entityNumber = entityEvent.getEntityNumber();
                String accountId = RequestContext.get().getAccountId();
                List businessKeys = entityEvent.getBusinesskeys();
                HashMap<String, String> idMap = new HashMap<String, String>(12);
                if ("adm_questioncomp".equals(entityNumber)) {
                    List ids = businessKeys.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_questioncomp", (String)"id,srcsupquestionid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                    for (DynamicObject dynamicObject : query) {
                        String id = dynamicObject.get("id").toString();
                        idMap.put(id, dynamicObject.getString("srcsupquestionid"));
                    }
                }
                for (String businessKey : businessKeys) {
                    String s;
                    Long pkid = Long.valueOf(businessKey);
                    if (idMap.size() > 0 && StringUtils.isNotEmpty((CharSequence)(s = (String)idMap.get(businessKey)))) {
                        pkid = Long.valueOf(s);
                    }
                    StringBuilder url = new StringBuilder();
                    url.append(domainContextUrl).append("?accountId=").append(accountId).append("&formId=").append(this.BILL_FORM_ID.get(entityNumber)).append("&pkId=").append(pkid);
                    map.put(businessKey, url.toString());
                }
                break block8;
            }
            if (!(evt instanceof JsonEvent)) break block8;
            try {
                JsonEvent jsonEvent = (JsonEvent)evt;
                String source = jsonEvent.getSource();
                String substring = source.substring(1, source.length() - 1);
                Map paramMap = (Map)JacksonJsonUtil.fromJSON((String)substring, Map.class);
                String businesskey = (String)paramMap.get("rptbillid");
                String accountId = RequestContext.get().getAccountId();
                StringBuilder url = new StringBuilder();
                url.append(domainContextUrl).append("?accountId=").append(accountId).append("&formId=").append("srm_scorehelper_inh").append("&taskbillnos=").append(businesskey).append("&isworkbench=true");
                map.put(businesskey, url.toString());
            }
            catch (IOException e) {
                logger.error("\u9000\u56de\u91cd\u8bc4\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return map;
    }
}

