/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.srm.common.enums.SrmScoreResultEnum;

public class SrmEvaResultPlugin
extends AbstractFormPlugin {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Object billId;
        String key = evt.getItemKey();
        if ("refresh".equals(key) && (billId = this.getBillId()) != null) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("scorer_entry");
            QFilter filter = new QFilter("id", "=", billId);
            String selectFields = "billno,entryentity.supplier,entry_scorer.scorer";
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"srm_evaplan", (String)selectFields, (QFilter[])new QFilter[]{filter});
            this.buildSupData(obj);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "export": {
                this.export();
                break;
            }
        }
    }

    protected void export() {
        IFormView view = this.getView();
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity();
            excelDataEntity.createSheet();
            excelDataEntity.setFileName(ResManager.loadKDString((String)"\u8bc4\u5206\u7ed3\u679c.xlsx", (String)"SrmEvaResultPlugin_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            excelDataEntity.setEntityKey("srm_evaresult");
            excelDataEntity.setEntryKey("scorer_entry");
            this.setExcelHeader(excelDataEntity);
            this.setEexclBody(excelDataEntity);
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"SrmEvaResultPlugin_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            this.log.error("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void setExcelHeader(ExcelDataEntity excelDataEntity) throws IOException {
        ExcelUtil.setColumn((ExcelDataEntity)excelDataEntity);
        HashMap<String, String> scorerColumnKeyMap = new HashMap<String, String>(8);
        for (int i = 0; i < 10; ++i) {
            int index = i + 1;
            StringBuilder supPriceSb = new StringBuilder("scorer");
            supPriceSb.append(index);
            scorerColumnKeyMap.put(supPriceSb.toString(), supPriceSb.toString());
        }
        Map cache = this.getPageCache().getAll();
        List oldcolumnList = excelDataEntity.getColumnKeyList();
        ArrayList<String> columnList = new ArrayList<String>(oldcolumnList);
        ArrayList<String> unExportColList = new ArrayList<String>();
        for (String column : excelDataEntity.getColumnKeyList()) {
            String supName = (String)cache.get(column);
            if (null != supName || null == scorerColumnKeyMap.get(column)) continue;
            unExportColList.add(column);
        }
        if (!columnList.isEmpty()) {
            columnList.removeAll(unExportColList);
        }
        excelDataEntity.setColumnKeyList(columnList);
        List<String> columnTitle = this.getColumnTitle(columnList);
        excelDataEntity.setExcelHeader(columnTitle);
    }

    private List<String> getColumnTitle(List<String> columnList) {
        ArrayList<String> columnTitleList = new ArrayList<String>();
        IDataModel model = this.getModel();
        Map cache = this.getPageCache().getAll();
        for (String column : columnList) {
            String supName = (String)cache.get(column);
            if (null != supName) {
                columnTitleList.add(supName);
                continue;
            }
            DynamicProperty pro = (DynamicProperty)model.getDataEntityType().findProperty(column);
            if (pro == null) continue;
            columnTitleList.add(pro.getDisplayName().toString());
        }
        return columnTitleList;
    }

    private void setEexclBody(ExcelDataEntity excelDataEntity) throws IOException {
        int rowCount = this.getModel().getEntryRowCount("scorer_entry");
        List columnKeyList = excelDataEntity.getColumnKeyList();
        for (int i = 0; i < rowCount; ++i) {
            List<String> rowData = this.getRowDataByIndex(columnKeyList, i);
            excelDataEntity.createRow(0, i + 1);
            excelDataEntity.setRowValue(0, rowData, i + 1);
        }
    }

    private List<String> getRowDataByIndex(List<String> columnKeyList, int i) {
        ArrayList<String> rowData = new ArrayList<String>(columnKeyList.size());
        DynamicObject dyObj = this.getModel().getEntryRowEntity("scorer_entry", i);
        for (String column : columnKeyList) {
            Object columnVal = dyObj.get(column);
            Object val = "";
            if (columnVal == null) {
                val = "";
            } else if (null != columnVal && columnVal instanceof DynamicObject) {
                val = ((DynamicObject)columnVal).get("name");
            } else if (columnVal instanceof BigDecimal) {
                val = ((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : columnVal;
            } else {
                val = columnVal;
                val = SrmScoreResultEnum.fromVal((String)String.valueOf(val)).getName();
            }
            rowData.add(String.valueOf(val));
        }
        return rowData;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object billId = this.getBillId();
        if (billId != null) {
            QFilter filter = new QFilter("id", "=", billId);
            String selectFields = "billno,entryentity.supplier,entry_scorer.scorer";
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"srm_evaplan", (String)selectFields, (QFilter[])new QFilter[]{filter});
            this.buildSupData(obj);
        }
    }

    private Object getBillId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        return param.get("billid");
    }

    private void buildSupData(DynamicObject obj) {
        DynamicObjectCollection supCols = obj.getDynamicObjectCollection("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection scorerCols = obj.getDynamicObjectCollection("entry_scorer");
        Map<String, String> scoreColumRelMap = this.buildEntrySrorerColumns(scorerCols);
        HashMap<String, Boolean> scorerIsScoreMap = new HashMap<String, Boolean>(8);
        Object billId = this.getBillId();
        DynamicObjectCollection scoreTaskCols = this.getSrmScoreTaskData(billId);
        int supColSize = supCols.size();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < supColSize; ++i) {
            DynamicObject sup = ((DynamicObject)supCols.get(i)).getDynamicObject("supplier");
            for (DynamicObject scoreTaskCol : scoreTaskCols) {
                String column;
                Object scorerId;
                Object supId = scoreTaskCol.get("supplier");
                if (null == supId || !supId.toString().equals(String.valueOf(sup.getPkValue())) || null == (scorerId = scoreTaskCol.get("scorer")) || null == (column = scoreColumRelMap.get(scorerId.toString()))) continue;
                String scorerKey = supId + "_" + scorerId;
                Boolean hasScored = (Boolean)scorerIsScoreMap.get(scorerKey);
                if (null != hasScored && !hasScored.booleanValue()) {
                    ts.set(column, (Object)SrmScoreResultEnum.UNSCORED, i);
                    continue;
                }
                boolean isScore = scoreTaskCol.getBoolean("scorerscored");
                if (isScore) {
                    ts.set(column, (Object)SrmScoreResultEnum.HAVASCORED, i);
                } else {
                    ts.set(column, (Object)SrmScoreResultEnum.UNSCORED, i);
                }
                scorerIsScoreMap.put(scorerKey, isScore);
            }
            ts.set("supplier", sup.getPkValue(), i);
        }
        model.batchCreateNewEntryRow("scorer_entry", ts);
    }

    private Map<String, String> buildEntrySrorerColumns(DynamicObjectCollection scorerCols) {
        HashMap<String, String> scorerColumnNameMap = new HashMap<String, String>(8);
        HashMap<String, String> scorerColumnRelation = new HashMap<String, String>(8);
        int count = 10;
        ArrayList<String> scorePkIdCache = new ArrayList<String>();
        Iterator iterator = scorerCols.iterator();
        while (iterator.hasNext()) {
            String scorePkId = String.valueOf(((DynamicObject)iterator.next()).getDynamicObject("scorer").getPkValue());
            if (scorePkIdCache.contains(scorePkId)) {
                iterator.remove();
            }
            scorePkIdCache.add(scorePkId);
        }
        int supSize = scorerCols.size();
        EntryGrid inquiryGrid = (EntryGrid)this.getView().getControl("scorer_entry");
        for (int i = 0; i < count; ++i) {
            int index = i + 1;
            String columnName = ResManager.loadKDString((String)"\u8bc4\u59d4", (String)"SrmEvaResultPlugin_2", (String)"scm-srm-formplugin", (Object[])new Object[0]);
            StringBuilder scorerNameSb = new StringBuilder("scorer");
            scorerNameSb.append(index);
            if (i < supSize) {
                DynamicObject scorerCol = (DynamicObject)scorerCols.get(i);
                DynamicObject scorer = scorerCol.getDynamicObject("scorer");
                columnName = scorer.getString("name");
                scorerColumnNameMap.put(scorerNameSb.toString(), columnName);
                scorerColumnRelation.put(String.valueOf(scorer.getPkValue()), scorerNameSb.toString());
                LocaleString localStr = new LocaleString(columnName);
                inquiryGrid.setColumnProperty(scorerNameSb.toString(), "header", (Object)localStr);
                inquiryGrid.setColumnProperty(scorerNameSb.toString(), "text-align", (Object)"left");
                this.getView().setVisible(Boolean.TRUE, new String[]{scorerNameSb.toString()});
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{scorerNameSb.toString()});
        }
        this.getPageCache().put(scorerColumnNameMap);
        return scorerColumnRelation;
    }

    private DynamicObjectCollection getSrmScoreTaskData(Object billId) {
        QFilter filter = new QFilter("taskbillid", "=", billId);
        String selectFields = "billno,bizstatus,supplier.id supplier,entry.subentry.scorer.id scorer,entry.subentry.scorerscored scorerscored";
        DynamicObjectCollection scoreCols = QueryServiceHelper.query((String)"srm_score", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return scoreCols;
    }
}

