/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.util.RegExpUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.srm.formplugin.DataSheetHandler;

public class SrmImportSupPlugin
extends AbstractBillPlugIn
implements UploadListener {
    private static Log log = LogFactory.getLog(SrmImportSupPlugin.class);
    private static final String EXPORTTPL_OP = "exporttpl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        toolBar.addUploadListener((UploadListener)this);
        Toolbar advToolBar = (Toolbar)this.getControl("advcontoolbarap");
        advToolBar.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "exporttpl": {
                this.exportTpl();
                break;
            }
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String url = (String)evt.getUrls()[0];
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        fileService.download(url, (OutputStream)outStream, "httpclient");
        ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
        ExcelReader reader = new ExcelReader();
        DataSheetHandler handler = new DataSheetHandler();
        try {
            reader.read((InputStream)input, (SheetHandler)handler);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        this.importData(handler);
    }

    private void importData(DataSheetHandler handler) {
        Map<Integer, Map<Integer, String>> rows = handler.getRows();
        HashMap<String, Object> supName_idMap = new HashMap<String, Object>(16);
        HashSet<String> supNameSet = new HashSet<String>((int)((double)rows.size() / 0.75));
        Map<Integer, String> row = null;
        Iterator<Map.Entry<Integer, Map<Integer, String>>> iterator = rows.entrySet().iterator();
        Map.Entry<Integer, Map<Integer, String>> next2 = null;
        while (iterator.hasNext()) {
            next2 = iterator.next();
            row = next2.getValue();
            if (next2.getKey() == 0 || row == null) continue;
            supNameSet.add(row.get(0));
        }
        QFilter supFilter = new QFilter("name", "in", supNameSet);
        supFilter.and("supplier_status", "=", (Object)BillAssistConstant.SUPPLIER_STATUS_FORMAL);
        Long orgID = (Long)this.getModel().getValue("org_id");
        QFilter[] qFilters = null;
        if (orgID != null) {
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgID);
            qFilters = new QFilter[]{supFilter, qFilter};
        } else {
            qFilters = new QFilter[]{supFilter};
        }
        DynamicObjectCollection supCols = QueryServiceHelper.query((String)"bd_supplier", (String)"id,name", (QFilter[])qFilters);
        for (DynamicObject supCol : supCols) {
            supName_idMap.put(supCol.getString("name"), supCol.get("id"));
        }
        StringBuilder tipSb = new StringBuilder();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        String reg = "(?<=(?<!\\\\)\\$\\{)(.*?)(?=(?<!\\\\)\\})";
        if (rows.size() > 0) {
            HashMap<Integer, String> indexKeyMap = new HashMap<Integer, String>();
            String columnKey = null;
            row = rows.get(0);
            for (int j = 0; row != null && j < row.size(); ++j) {
                if (row.get(j) == null) continue;
                columnKey = RegExpUtil.findString((String)reg, (String)rows.get(0).get(j), (int)1);
                indexKeyMap.put(j, columnKey);
            }
            for (Map.Entry<Integer, Map<Integer, String>> next2 : rows.entrySet()) {
                row = next2.getValue();
                if (next2.getKey() == 0) continue;
                boolean isSuccess = true;
                for (int j = 0; row != null && j < row.size(); ++j) {
                    String rowVal;
                    columnKey = (String)indexKeyMap.get(j);
                    if (columnKey == null || columnKey.length() == 0) {
                        if (next2.getKey() != 1) break;
                        tipSb.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5f15\u5165\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u672a\u4fee\u6539\u5f15\u5165\u6a21\u677f\u3002", (String)"SrmImportSupPlugin_6", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String setVal = rowVal = row.get(j);
                    if ("supplier".equals(columnKey)) {
                        Object supId = supName_idMap.get(rowVal);
                        if (null == supId) {
                            isSuccess = false;
                            tipSb.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\uff1a", (String)"SrmImportSupPlugin_0", (String)"scm-srm-formplugin", (Object[])new Object[0])).append(rowVal).append(ResManager.loadKDString((String)"\u540d\u79f0\u9519\u8bef\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"SrmImportSupPlugin_7", (String)"scm-srm-formplugin", (Object[])new Object[0])).append('\n');
                            break;
                        }
                        setVal = supId;
                    }
                    ts.set(columnKey, (Object)setVal, rowIndex);
                }
                if (!isSuccess) continue;
                ++rowIndex;
            }
        }
        model.deleteEntryData("entryentity");
        if (rowIndex > 0) {
            model.batchCreateNewEntryRow("entryentity", ts);
        }
        if (tipSb.length() > 0) {
            if (rowIndex > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u5f15\u5165\u5931\u8d25", (String)"SrmImportSupPlugin_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), tipSb.toString(), MessageTypes.Default);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"SrmImportSupPlugin_3", (String)"scm-srm-formplugin", (Object[])new Object[0]), tipSb.toString(), MessageTypes.Default);
            }
        }
    }

    protected void exportTpl() {
        IFormView view = this.getView();
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity();
            excelDataEntity.createSheet();
            excelDataEntity.setFileName(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5f15\u5165\u6a21\u677f.xlsx", (String)"SrmImportSupPlugin_8", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            excelDataEntity.setEntityKey(this.getModel().getDataEntityType().getName());
            excelDataEntity.setEntryKey("entryentity");
            excelDataEntity.setAddColumnKeyToHeader(true);
            ExcelUtil.setExcelHeader((ExcelDataEntity)excelDataEntity, (IDataModel)this.getModel());
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"SrmImportSupPlugin_5", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            log.error("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

