/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.scm.common.util.SrmCommonUtil;
import kd.sdk.scm.srm.extpoint.ISrmAccessNodeService;

public class SrmImproveAuditWorkFlowData
implements IWorkflowPlugin {
    public void notify(AgentExecution execution) {
        List children;
        IApprovalRecordGroup iApprovalRecordGroup;
        String businessKey = execution.getBusinessKey();
        List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)businessKey);
        BizLog.log((String)"SrmImproveAuditWorkFlowData begin deal message");
        if (!CollectionUtils.isEmpty((Collection)allApprovalRecord) && Objects.nonNull(iApprovalRecordGroup = (IApprovalRecordGroup)allApprovalRecord.get(allApprovalRecord.size() - 1)) && !CollectionUtils.isEmpty((Collection)(children = iApprovalRecordGroup.getChildren()))) {
            StringBuilder message = new StringBuilder(32);
            boolean auditFlag = false;
            for (IApprovalRecordItem iApprovalRecordItem : children) {
                if (!Objects.nonNull(iApprovalRecordItem)) continue;
                if ("approve".equals(iApprovalRecordItem.getDecisionType())) {
                    auditFlag = true;
                    boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
                    if (enableNewAccessFlow) {
                        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(businessKey));
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"srm_improve", (String)"id,billno,srcbillid,confirmstatus", (QFilter[])qFilter.toArray());
                        long srcbillid = dynamicObject.getLong("srcbillid");
                        QFilter qFilter1 = new QFilter("id", "=", (Object)srcbillid);
                        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"srm_sceneexam", (String)"id,billno,aptitudeno,auditstatus,sceneresult", (QFilter[])qFilter1.toArray());
                        ArrayList<DynamicObject> sceneList = new ArrayList<DynamicObject>(dynamicObjects.length);
                        for (DynamicObject scene : dynamicObjects) {
                            scene.set("sceneresult", (Object)"1");
                            sceneList.add(scene);
                        }
                        if (!sceneList.isEmpty()) {
                            this.setSupapproveNodeStatus(sceneList.toArray(new DynamicObject[sceneList.size()]), true);
                        }
                    }
                }
                if (message.length() == 0) {
                    message.append(iApprovalRecordItem.getMessage());
                    continue;
                }
                message.append(";").append(iApprovalRecordItem.getMessage());
            }
            if (message.length() > 0) {
                StringBuilder logMsg = new StringBuilder("SrmImproveAuditWorkFlowData  deal message :");
                logMsg.append((CharSequence)message);
                logMsg.append("key");
                logMsg.append(businessKey);
                BizLog.log((String)logMsg.toString());
                this.dealMesage(message, businessKey, auditFlag);
            }
        }
    }

    protected void dealMesage(StringBuilder message, String businessKey, boolean flag) {
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)message.toString()) && !kd.bos.orm.util.StringUtils.isEmpty((Object)businessKey)) {
            String subMessage = "";
            subMessage = message.length() >= 255 ? message.substring(0, 255) : message.toString();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(businessKey))};
            DynamicObject srm_improve = BusinessDataServiceHelper.loadSingle((String)"srm_improve", (String)"confirmstatus,approver,auditopinion,approvedate,id", (QFilter[])qFilters);
            if (Objects.nonNull(srm_improve)) {
                srm_improve.set("auditopinion", (Object)subMessage);
                srm_improve.set("approvedate", (Object)TimeServiceHelper.now());
                srm_improve.set("approver", (Object)UserServiceHelper.getCurrentUserId());
                if (flag) {
                    srm_improve.set("confirmstatus", (Object)"E");
                } else {
                    srm_improve.set("confirmstatus", (Object)"F");
                }
                SaveServiceHelper.update((DynamicObject)srm_improve);
            }
        }
    }

    private Map<String, Object> setSupapproveNodeStatus(DynamicObject[] nodeobjects, boolean isAudit) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        String message = null;
        String objectNumber = nodeobjects[0].getDynamicObjectType().getName();
        ISrmAccessNodeService nodeService = this.getNodeService(objectNumber);
        message = nodeService != null ? nodeService.setSupapproveNodeStatus(objectNumber, nodeobjects, isAudit) : MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5355\u636e({0})\u5728\u4f9b\u5e94\u5546\u51c6\u5165\u8282\u70b9\u662f\u5426\u914d\u7f6e\u5e76\u542f\u7528\u6216\u670d\u52a1\u5904\u7406\u7c7b\u3002", (String)"SrmImproveAuditWorkFlowData_0", (String)"scm-srm-formplugin", (Object[])new Object[0]), objectNumber);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", message);
        }
        return resultMap;
    }

    private ISrmAccessNodeService getNodeService(String objectnumber) {
        String serviceclass;
        ISrmAccessNodeService nodeService = null;
        QFilter qFilter = new QFilter("status", "=", (Object)"1");
        qFilter.and("bizobject", "=", (Object)objectnumber);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"srm_accessnode", (String)"id,serviceclass", (QFilter[])qFilter.toArray());
        if (dyn != null && StringUtils.isNotBlank((CharSequence)(serviceclass = dyn.getString("serviceclass")))) {
            nodeService = (ISrmAccessNodeService)TypesContainer.createInstance((String)serviceclass);
        }
        return nodeService;
    }
}

