/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.srm.common.SrmScoreUtil;
import net.sf.json.JSONObject;

public class SrmScoreHelper
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
UploadListener {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private boolean isChanging = false;
    public static final String VERIFYTYPE_SAVE = "save";
    public static final String VERIFYTYPE_SUBMIT = "submit";
    private List<Map<String, Map<String, BigDecimal>>> accordanceList = new ArrayList<Map<String, Map<String, BigDecimal>>>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid grid = (EntryGrid)this.getView().getControl("score_entry");
        grid.addRowClickListener((RowClickEventListener)this);
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        toolBar.addUploadListener((UploadListener)this);
        TextEdit accordance = (TextEdit)this.getView().getControl("accordance");
        accordance.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isNode = this.getPageCache().get("isTreeNodeClick");
        if (isNode == null || isNode.equals("0")) {
            this.initAllTreeNodes();
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object datefrom = param.get("datefrom");
        Object dateto = param.get("dateto");
        Object scorestatus = param.get("scorestatus");
        if (Objects.nonNull(scorestatus)) {
            this.getPageCache().put("scorestatus", scorestatus.toString());
        }
        if (Objects.nonNull(datefrom) && Objects.nonNull(scorestatus)) {
            this.getPageCache().put("datefrom", datefrom.toString());
            this.getPageCache().put("dateto", dateto.toString());
        }
        Object supplier = param.get("supplier");
        Object isworkbench = param.get("isworkbench");
        if (isworkbench != null) {
            Object taskbillnos = param.get("taskbillnos");
            this.getPageCache().put("taskbillnos", taskbillnos.toString());
            this.getPageCache().put("isworkbench", "isworkbench");
            this.allotDynamicData(null, false);
        } else if (supplier != null) {
            this.allotDynamicData(supplier.toString(), false);
        } else {
            Object srmEvaplanPkId = param.get("pkId");
            if (srmEvaplanPkId != null) {
                this.setScoreTitleCache(srmEvaplanPkId);
                this.allotDynamicData(null, false);
            } else {
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_scorequery", (ShowType)ShowType.NonModal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "srm_scorequery"));
            }
        }
    }

    private void setScoreTitleCache(Object srmEvaplanPkId) {
        String selectFields = "id,billno,name";
        DynamicObject evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(srmEvaplanPkId.toString()))});
        if (evaplan == null) {
            evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan_batch", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(srmEvaplanPkId.toString()))});
        }
        if (evaplan != null) {
            String name = evaplan.getString("name");
            this.getPageCache().put("name", name);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (nodeId != null) {
            String nodeIdStr = nodeId.toString();
            IPageCache cache = this.getPageCache();
            cache.put("isTreeNodeClick", "1");
            String detailIdValueStr = cache.get("detailIDValue");
            if (null != detailIdValueStr) {
                this.updateImportData();
                this.importThenAllotDynamicData(nodeIdStr);
            } else if ("0".equals(nodeIdStr)) {
                cache.put("supplier", null);
                cache.put("isTreeNodeClick", "0");
                this.allotDynamicData(null, false);
            } else {
                cache.put("supplier", nodeIdStr);
                this.allotDynamicData(nodeIdStr, false);
            }
        }
    }

    private void updateImportData() {
        String detailIDValueStr = this.getPageCache().get("detailIDValue");
        JSONObject detailIDValueJo = JSONObject.fromObject((Object)detailIDValueStr);
        int rowCount = this.getModel().getEntryRowCount("score_entry");
        for (int i = 0; i < rowCount; ++i) {
            String detailId = String.valueOf(this.getModel().getValue("detailid_a", i));
            if (!detailIDValueJo.containsKey((Object)detailId)) continue;
            detailIDValueJo.put((Object)detailId, this.getModel().getValue("value_a", i));
        }
        this.getPageCache().put("detailIDValue", detailIDValueJo.toString());
        this.log.info("@@update!!detailIDValueStr\uff1a" + detailIDValueJo);
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.deleteEntryData("score_entry");
        model.deleteEntryData("rule_entry");
        model.deleteEntryData("refer_entry");
        Container headContainer = (Container)this.getControl("head_entity");
        List tempList = DynamicObjectUtil.getContainerProperties((Container)headContainer);
        for (int i = 0; i < tempList.size(); ++i) {
            model.setValue((String)tempList.get(i), null);
        }
    }

    private void initAllTreeNodes() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        TreeNode node = new TreeNode("", "0", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"SrmScoreHelper_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        treeView.deleteAllNodes();
        treeView.addNode(node);
        treeView.focusNode(node);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.itemClick((ItemClickEvent)evt);
        switch (itemKey = evt.getItemKey()) {
            case "tblsubmit": {
                evt.setCancel(true);
                DynamicObjectCollection scoreRows = this.getModel().getEntryEntity("score_entry");
                HashSet taskIds = new HashSet();
                HashSet scoreIds = new HashSet();
                HashMap<String, Object> scoreMap = new HashMap<String, Object>();
                Map resultMap = SrmScoreUtil.verifyData((DynamicObjectCollection)scoreRows, taskIds, scoreIds, scoreMap, (String)VERIFYTYPE_SUBMIT);
                boolean succed = (Boolean)resultMap.get("succed");
                Object message = resultMap.get("message");
                if (!succed) {
                    this.getView().showMessage(message.toString());
                    return;
                }
                if (message == null) break;
                SrmScoreUtil.writeToScore(taskIds, scoreIds, scoreMap);
                this.getView().showMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u5206\u63d0\u4ea4\u6210\u529f\uff0c%1", (String)"SrmScoreHelper_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmScoreHelper_2", (String)"scm-srm-formplugin", (Object[])new Object[]{message}));
                this.getPageCache().put("isTreeNodeClick", "0");
                this.clearData();
                this.initAllTreeNodes();
                if (null != this.getPageCache().get("detailIDValue")) {
                    this.deleteImportCacheData(scoreMap);
                    this.importThenAllotDynamicData("");
                    break;
                }
                this.allotDynamicData(null, false);
                break;
            }
            case "tblsave": {
                boolean isSuccess = this.saveScore();
                if (isSuccess) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SrmScoreHelper_5", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bc4\u5206\u8bb0\u5f55\u3002", (String)"SrmScoreHelper_6", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "tblsupeva": {
                long currUserId;
                int selectRow;
                EntryGrid entryentity = (EntryGrid)this.getControl("score_entry");
                int[] selectRows = entryentity.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5f85\u8bc4\u5206\u4efb\u52a1\u3002", (String)"SrmScoreHelper_9", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u5f85\u8bc4\u5206\u4efb\u52a1\u3002", (String)"SrmScoreHelper_10", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection score_entry = this.getModel().getEntryEntity("score_entry");
                DynamicObject rowData = (DynamicObject)score_entry.get(selectRow = selectRows[0]);
                String billno_a = rowData.getString("billno_a");
                boolean exists = QueryServiceHelper.exists((String)"srm_score", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno_a).and("entryentity.evascorer.id", "=", (Object)(currUserId = RequestContext.get().getCurrUserId()))});
                if (!exists) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
                    paramMap.put("taskno", billno_a);
                    paramMap.put("userid", currUserId);
                    String selectBaseDataFieldsForm = "srm_supoveralleva";
                    OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, paramMap, null);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u4f30\u4efb\u52a1\u5355\u53f7\u4e0b\u5df2\u63d0\u4ea4\u8fc7\u4f9b\u5e94\u5546\u6574\u4f53\u8bc4\u4ef7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SrmScoreHelper_11", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "bar_scoredquery": {
                long currUserId = RequestContext.get().getCurrUserId();
                ReportShowParameter reportShowParameter = new ReportShowParameter();
                reportShowParameter.setHasRight(true);
                reportShowParameter.setFormId("srm_scoredquery_report");
                reportShowParameter.setStatus(OperationStatus.ADDNEW);
                reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                reportShowParameter.setCustomParam("userid", (Object)currUserId);
                this.getView().showForm((FormShowParameter)reportShowParameter);
                break;
            }
            case "bar_abstain": {
                boolean success = true;
                DynamicObjectCollection rescoreScoreRows = this.getModel().getEntryEntity("score_entry");
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("score_entry");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SrmScoreHelper_13", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                HashSet<Long> socreIdSet = new HashSet<Long>(16);
                for (int selectRow : selectRows) {
                    DynamicObject scoreRow = (DynamicObject)rescoreScoreRows.get(selectRow);
                    socreIdSet.add(scoreRow.getLong("billid_a"));
                }
                Map<Long, Map<Long, Set<Long>>> indexInfo = this.getIndexInfo(socreIdSet);
                for (int selectRow : selectRows) {
                    DynamicObject scoreRow = (DynamicObject)rescoreScoreRows.get(selectRow);
                    boolean scorerscored_a = scoreRow.getBoolean("scorerscored_a");
                    boolean abstain_a = scoreRow.getBoolean("abstain_a");
                    if (scorerscored_a && !abstain_a) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u60a8\u5df2\u8bc4\u5206\uff0c\u65e0\u6cd5\u653e\u5f03\u8bc4\u5206\u3002", (String)"SrmScoreHelper_14", (String)"scm-srm-formplugin", (Object[])new Object[]{selectRow + 1}));
                        success = false;
                    }
                    if (abstain_a) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u60a8\u5df2\u653e\u5f03\u8bc4\u5206\u3002", (String)"SrmScoreHelper_15", (String)"scm-srm-formplugin", (Object[])new Object[]{selectRow + 1}));
                        success = false;
                    }
                    long scoreId = scoreRow.getLong("billid_a");
                    long indexId = scoreRow.getLong("index_a.id");
                    Map<Long, Set<Long>> indexMap = indexInfo.get(scoreId);
                    if (indexMap == null) continue;
                    Set<Long> scorerSet = indexMap.get(indexId);
                    if (scorerscored_a || abstain_a || scorerSet == null || scorerSet.size() > 1) continue;
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u60a8\u4f5c\u4e3a\u8bc4\u4f30\u6307\u6807\u7684\u552f\u4e00\u8bc4\u59d4\uff0c\u65e0\u6cd5\u653e\u5f03\u8bc4\u5206\u3002", (String)"SrmScoreHelper_16", (String)"scm-srm-formplugin", (Object[])new Object[]{selectRow + 1}));
                    success = false;
                }
                if (success) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Map all = this.getPageCache().getAll();
        if (operationResult != null && operationResult.isSuccess() && "abstain".equals(operateKey)) {
            DynamicObjectCollection rescoreScoreRows = this.getModel().getEntryEntity("score_entry");
            EntryGrid entryentity = (EntryGrid)this.getControl("score_entry");
            int[] selectRows = entryentity.getSelectRows();
            HashSet<Long> rescoreTaskIds = new HashSet<Long>(16);
            HashSet<Long> rescoreScoreIds = new HashSet<Long>(16);
            HashMap<String, Object> rescoreScoreMap = new HashMap<String, Object>(16);
            this.blanceScorerWeight(rescoreScoreRows, selectRows);
            this.otherScorerRescore(rescoreScoreRows, selectRows);
            this.buildScoreInfo(rescoreScoreRows, rescoreTaskIds, rescoreScoreIds, rescoreScoreMap, selectRows);
            SrmScoreUtil.writeToScore(rescoreTaskIds, rescoreScoreIds, rescoreScoreMap);
            this.clearData();
            this.initAllTreeNodes();
            if (null != all.get("detailIDValue")) {
                this.deleteImportCacheData(rescoreScoreMap);
                this.importThenAllotDynamicData("");
            } else {
                this.allotDynamicData(null, false);
            }
        }
    }

    private void otherScorerRescore(DynamicObjectCollection scoreRows, int[] selectRows) {
        HashSet<Long> scoreBillIdSet = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            DynamicObject row = (DynamicObject)scoreRows.get(selectRow);
            long scoreBillId = row.getLong("billid_a");
            scoreBillIdSet.add(scoreBillId);
        }
        Map srm_scores = BusinessDataServiceHelper.loadFromCache((Object[])scoreBillIdSet.toArray(new Object[scoreBillIdSet.size()]), (String)"srm_score");
        for (int selectRow : selectRows) {
            DynamicObject row = (DynamicObject)scoreRows.get(selectRow);
            long scoreBillId = row.getLong("billid_a");
            long curIndexId = row.getLong("index_a.id");
            DynamicObject srm_score = (DynamicObject)srm_scores.get(scoreBillId);
            DynamicObjectCollection entry = srm_score.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                long indexId = entryRow.getLong("index.id");
                if (curIndexId != indexId) continue;
                BigDecimal newIndexScore = new BigDecimal(0);
                DynamicObjectCollection subentry = entryRow.getDynamicObjectCollection("subentry");
                for (DynamicObject subentryRow : subentry) {
                    boolean scorerscored = subentryRow.getBoolean("scorerscored");
                    boolean abstain = subentryRow.getBoolean("abstain");
                    BigDecimal score = subentryRow.getBigDecimal("score");
                    BigDecimal scorerweight = subentryRow.getBigDecimal("scorerweight");
                    if (!scorerscored || abstain) continue;
                    BigDecimal newScore = score.multiply(scorerweight).divide(new BigDecimal(100), 2);
                    subentryRow.set("scorerscore", (Object)newScore);
                    newIndexScore = newIndexScore.add(newScore);
                }
                entryRow.set("sysscore", (Object)newIndexScore);
                entryRow.set("manscore", (Object)newIndexScore);
                entryRow.set("finalscore", (Object)newIndexScore.multiply(entryRow.getBigDecimal("indexweight")).divide(new BigDecimal(100), 2));
            }
        }
        SaveServiceHelper.save((DynamicObject[])srm_scores.values().toArray(new DynamicObject[srm_scores.size()]));
    }

    private void buildScoreInfo(DynamicObjectCollection scoreRows, Set<Long> taskIds, Set<Long> scoreIds, Map<String, Object> scoreMap, int[] selectRows) {
        for (int selectRow : selectRows) {
            DynamicObject row = (DynamicObject)scoreRows.get(selectRow);
            taskIds.add(row.getLong("taskbillid_a"));
            scoreIds.add(row.getLong("billid_a"));
            scoreMap.put(row.getString("detailid_a"), row);
        }
    }

    private void blanceScorerWeight(DynamicObjectCollection scoreRows, int[] selectRows) {
        HashSet<Long> scoreBillIdSet = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            DynamicObject row = (DynamicObject)scoreRows.get(selectRow);
            long scoreBillId = row.getLong("billid_a");
            scoreBillIdSet.add(scoreBillId);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Map srm_scores = BusinessDataServiceHelper.loadFromCache((Object[])scoreBillIdSet.toArray(new Object[scoreBillIdSet.size()]), (String)"srm_score");
        for (int selectRow : selectRows) {
            DynamicObject row = (DynamicObject)scoreRows.get(selectRow);
            BigDecimal denominator = new BigDecimal(100);
            BigDecimal curScorerWeight = new BigDecimal(0);
            long scoreBillId = row.getLong("billid_a");
            long curIndexId = row.getLong("index_a.id");
            DynamicObject srm_score = (DynamicObject)srm_scores.get(scoreBillId);
            DynamicObjectCollection entry = srm_score.getDynamicObjectCollection("entry");
            block2: for (DynamicObject entryRow : entry) {
                boolean abstain;
                BigDecimal scorerweight;
                long indexId = entryRow.getLong("index.id");
                if (curIndexId != indexId) continue;
                DynamicObjectCollection subentry = entryRow.getDynamicObjectCollection("subentry");
                for (DynamicObject subentryRow : subentry) {
                    long scorer = subentryRow.getLong("scorer.id");
                    if (currUserId != scorer) continue;
                    scorerweight = subentryRow.getBigDecimal("scorerweight");
                    curScorerWeight = BigDecimal.valueOf(scorerweight.doubleValue());
                    denominator = denominator.subtract(scorerweight);
                    subentryRow.set("abstain", (Object)"1");
                    subentryRow.set("scorerscored", (Object)"1");
                    subentryRow.set("scorerweight", (Object)new BigDecimal(0));
                }
                BigDecimal fullWeight = new BigDecimal(100);
                for (DynamicObject subentryRow : subentry) {
                    abstain = subentryRow.getBoolean("abstain");
                    if (abstain) continue;
                    scorerweight = subentryRow.getBigDecimal("scorerweight");
                    BigDecimal addWeight = curScorerWeight.multiply(scorerweight).divide(denominator, 2);
                    scorerweight = scorerweight.add(addWeight);
                    fullWeight = fullWeight.subtract(scorerweight);
                    subentryRow.set("scorerweight", (Object)scorerweight);
                }
                if (fullWeight.compareTo(new BigDecimal(0)) <= 0) continue;
                for (DynamicObject subentryRow : subentry) {
                    abstain = subentryRow.getBoolean("abstain");
                    if (abstain) continue;
                    scorerweight = subentryRow.getBigDecimal("scorerweight");
                    subentryRow.set("scorerweight", (Object)scorerweight.add(fullWeight));
                    continue block2;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])srm_scores.values().toArray(new DynamicObject[srm_scores.size()]));
    }

    private Map<Long, Map<Long, Set<Long>>> getIndexInfo(Set<Long> socreIdSet) {
        HashMap<Long, Map<Long, Set<Long>>> indexInfo = new HashMap<Long, Map<Long, Set<Long>>>(16);
        DynamicObjectCollection srm_scores = QueryServiceHelper.query((String)"srm_score", (String)"id,entry.index,entry.subentry.scorer,entry.subentry.abstain", (QFilter[])new QFilter[]{new QFilter("id", "in", socreIdSet)});
        for (DynamicObject srm_score : srm_scores) {
            HashSet<Long> scorerSet;
            long scoreId = srm_score.getLong("id");
            long indexId = srm_score.getLong("entry.index");
            long scorerId = srm_score.getLong("entry.subentry.scorer");
            boolean abstain = srm_score.getBoolean("entry.subentry.abstain");
            if (abstain) continue;
            HashMap<Long, HashSet<Long>> indexMap = (HashMap<Long, HashSet<Long>>)indexInfo.get(scoreId);
            if (indexMap == null) {
                indexMap = new HashMap<Long, HashSet<Long>>(16);
            }
            if ((scorerSet = (HashSet<Long>)indexMap.get(indexId)) == null) {
                scorerSet = new HashSet<Long>(16);
            }
            scorerSet.add(scorerId);
            indexMap.put(indexId, scorerSet);
            indexInfo.put(scoreId, indexMap);
        }
        return indexInfo;
    }

    public void deleteImportCacheData(Map<String, Object> scoreMap) {
        JSONObject detailIdValueJo = JSONObject.fromObject((Object)this.getPageCache().get("detailIDValue"));
        for (String key : scoreMap.keySet()) {
            detailIdValueJo.remove(key);
        }
        this.log.info("@@\u7f13\u5b58\u79fb\u9664\u9879\uff1a" + scoreMap.keySet());
        this.getPageCache().put("detailIDValue", detailIdValueJo.toString());
        this.log.info("\u66f4\u65b0\u540e\u5f15\u5165\u8bc4\u5206\u9879\u7f13\u5b58\uff1a" + detailIdValueJo);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tblquery": {
                this.getPageCache().put("isTreeNodeClick", "0");
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_scorequery", (ShowType)ShowType.NonModal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "srm_scorequery"));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "srm_scorequery": {
                this.scoreQuery(closedCallBackEvent);
                break;
            }
            case "accordance": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData == null) break;
                Map all = this.getView().getPageCache().getAll();
                String indexStr = (String)all.get("accordanceindex");
                int index = Integer.parseInt(indexStr);
                String score = (String)all.get(returnData.toString());
                String key = returnData.toString() + "name";
                String accordance = (String)all.get(key);
                this.getModel().setValue("value_a", (Object)score, index);
                this.getModel().setValue("accordance", (Object)accordance, index);
                break;
            }
        }
    }

    private void scoreQuery(ClosedCallBackEvent closedCallBackEvent) {
        IPageCache cache = this.getPageCache();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof Map) {
            this.getPageCache().remove("detailIDValue");
            for (Map.Entry entry : ((Map)returnData).entrySet()) {
                cache.remove((String)entry.getKey());
                cache.put((String)entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
            }
        } else {
            return;
        }
        this.allotDynamicData(null, true);
    }

    public void allotDynamicHeadData(DynamicObject dynamicObject) {
        Map dynMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
        Container container = (Container)this.getControl("head_entity");
        IDataModel model = this.getModel();
        List proHeadEntity = DynamicObjectUtil.getContainerProperties((Container)container);
        for (Map.Entry entry : dynMap.entrySet()) {
            String key = (String)entry.getKey() + "_h";
            Object value = entry.getValue();
            if (value == null || !proHeadEntity.contains(key)) continue;
            model.setValue(key, value);
        }
    }

    public void allotDynamicScoreData(ArrayList<DynamicObject> currDynamics) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        EntryGrid grid = (EntryGrid)this.getView().getControl("score_entry");
        model.deleteEntryData("score_entry");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        List proEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity("score_entry").getDynamicObjectType());
        int rowCount = 0;
        for (DynamicObject dynamicObject : currDynamics) {
            Map dynMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
            for (Map.Entry entry : dynMap.entrySet()) {
                BigDecimal va;
                String key = (String)entry.getKey() + "_a";
                Object value = entry.getValue();
                if (((String)entry.getKey()).equals("value") && Objects.nonNull(va = (BigDecimal)entry.getValue()) && va.compareTo(new BigDecimal(-1)) == 0) {
                    value = null;
                }
                if ("entry.subentry.scoreattachment_a".equals(key)) {
                    try {
                        DynamicObject detailRow = this.getScoreAtt(value);
                        if (detailRow != null) {
                            tableValueSetter.set("scoreattachment", (Object)detailRow.getDynamicObjectCollection("scoreattachment"), rowCount);
                        }
                    }
                    catch (NullPointerException e) {
                        this.log.error("getScoreAtt error!" + e.getMessage());
                    }
                }
                if ("accordance".equals(entry.getKey())) {
                    tableValueSetter.set((String)entry.getKey(), value, rowCount);
                }
                if (!proEntity.contains(key)) continue;
                tableValueSetter.set(key, value, rowCount);
            }
            ++rowCount;
        }
        grid.selectRows(0);
        model.batchCreateNewEntryRow("score_entry", tableValueSetter);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("score_entry");
        for (DynamicObject entryRow : entryEntity) {
            boolean scorerscored_a = entryRow.getBoolean("scorerscored_a");
            boolean scorersave_a = entryRow.getBoolean("scorersave_a");
            String property_a = entryRow.getString("index_a.property");
            if (!scorerscored_a && !scorersave_a) continue;
            String value_a = entryRow.getString("value_a");
            BigDecimal score = new BigDecimal(value_a);
            entryRow.set("valuetext_a", (Object)score.setScale(2, 1));
        }
        this.setScoreGridStyle();
    }

    private DynamicObject getScoreAtt(Object value) {
        String selectFields = "id,scorer,value,score,scorerveto,scorerweight,scorerscore,note,scorerscored,scoreattachment";
        return BusinessDataServiceHelper.loadSingle((String)"srm_score_detail", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("scoreattachment", "=", (Object)Long.parseLong(value.toString()))});
    }

    private void allotDynamicData(String supplier, boolean displayInfo) {
        Object[] qFilters = SrmScoreUtil.assembleQueryFilter((String)supplier, (IPageCache)this.getPageCache());
        this.log.info("@@\u8bc4\u5206\u52a9\u624b\u67e5\u8be2\u6761\u4ef6\uff1a" + Arrays.toString(qFilters));
        DynamicObjectCollection toBeScoreRows = this.queryScoreRows((QFilter[])qFilters);
        if (toBeScoreRows.size() == 0) {
            this.clearData();
            this.initAllTreeNodes();
            if (displayInfo) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u67e5\u8be2\u6761\u4ef6\u3002", (String)"SrmScoreHelper_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        this.allotDynamicData(supplier, toBeScoreRows);
    }

    public DynamicObjectCollection queryScoreRows(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"srm_score", (String)SrmScoreUtil.assembleScoreSelectFields().toString(), (QFilter[])qFilters, (String)"supplier,taskbillno,billno,entry.index.number,entry.subentry.id");
    }

    private void allotDynamicData(String supplier, DynamicObjectCollection toBeScoreRows) {
        Long detailid;
        String isNodeClick = this.getPageCache().get("isTreeNodeClick");
        ArrayList<List> supplierSet = new ArrayList<List>();
        String currSupplier = null;
        ArrayList<Object> firstIndexId = new ArrayList<Object>();
        String firstBillno = "";
        this.getModel().beginInit();
        if (toBeScoreRows != null && toBeScoreRows.size() > 0) {
            DynamicObject firstRow = (DynamicObject)toBeScoreRows.get(0);
            this.allotDynamicHeadData(firstRow);
            currSupplier = firstRow.getString("supplier");
            firstIndexId.add(firstRow.getLong("index"));
            firstBillno = firstRow.getString("billno");
            for (DynamicObject row : toBeScoreRows) {
                String supplierId = row.getString("supplier");
                String supplierName = row.getString("suppliername");
                ArrayList<String> supplierList = new ArrayList<String>(2);
                supplierList.add(supplierId);
                supplierList.add(supplierName);
                if (supplierId == null || supplierSet.contains(supplierList)) continue;
                supplierSet.add(supplierList);
            }
        }
        if (isNodeClick == null || isNodeClick.equals("0")) {
            this.allotDynamicTreeData(supplierSet);
        }
        ArrayList<DynamicObject> currObjectList = new ArrayList<DynamicObject>();
        HashSet<Long> indexSetIds = new HashSet<Long>();
        if (StringUtils.isBlank((CharSequence)supplier) && isNodeClick != null) {
            for (DynamicObject tempObj : toBeScoreRows) {
                detailid = tempObj.getLong("detailid");
                currObjectList.add(tempObj);
                indexSetIds.add(detailid);
            }
        } else if (currSupplier != null) {
            for (DynamicObject tempObj : toBeScoreRows) {
                detailid = tempObj.getLong("detailid");
                if (null != this.getPageCache().get("detailIDValue")) {
                    currObjectList.add(tempObj);
                    indexSetIds.add(detailid);
                    continue;
                }
                if (indexSetIds.contains(detailid)) continue;
                currObjectList.add(tempObj);
                indexSetIds.add(detailid);
            }
        }
        this.allotDynamicScoreData(currObjectList);
        this.allotDynamicReferData(firstIndexId);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void allotDynamicTreeData(ArrayList<List> supplierSet) {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        this.initAllTreeNodes();
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        for (List supplierList : supplierSet) {
            treeNodes.add(new TreeNode("0", (String)supplierList.get(0), (String)supplierList.get(1)));
        }
        treeView.addNodes(treeNodes);
        IPageCache cache = this.getPageCache();
        if (treeNodes.size() > 0 && null == this.getPageCache().get("detailIDValue")) {
            TreeNode treeNode = (TreeNode)treeNodes.get(0);
        } else {
            cache.remove("supplier");
        }
        treeView.expand("0");
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        super.propertyChanged(arg0);
        EntryGrid grid = (EntryGrid)this.getControl("score_entry");
        String propertyName = arg0.getProperty().getName();
        int currentRowIndex = arg0.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "value_a": 
            case "accordance": {
                if (this.isChanging) {
                    return;
                }
                grid.entryRowClick(Integer.valueOf(currentRowIndex));
                Object newValue = arg0.getChangeSet()[0].getNewValue();
                this.setIndexScore(propertyName, currentRowIndex, newValue);
                break;
            }
            case "valuetext_a": {
                Object newValue = arg0.getChangeSet()[0].getNewValue();
                if (StringUtils.isNotBlank((Object)newValue)) {
                    if (newValue != null && (!this.isNumeric(newValue.toString()) || this.isExceedingMaximumValue(newValue.toString()))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6570\u503c\u3002", (String)"SrmScoreHelper_12", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("valuetext_a", (Object)"", currentRowIndex);
                        this.getModel().setValue("value_a", (Object)0, currentRowIndex);
                        this.getModel().setValue("scorerscore_a", (Object)0, currentRowIndex);
                        this.getModel().setValue("score_a", (Object)0, currentRowIndex);
                        this.getModel().setValue("scorerveto_a", null, currentRowIndex);
                        return;
                    }
                    if (newValue == null) break;
                    BigDecimal score = new BigDecimal(newValue.toString());
                    if (score.compareTo(BigDecimal.ZERO) == 0) {
                        grid.entryRowClick(Integer.valueOf(currentRowIndex));
                        newValue = arg0.getChangeSet()[0].getNewValue();
                        this.setIndexScore(propertyName, currentRowIndex, newValue);
                    }
                    this.getModel().setValue("valuetext_a", (Object)score.setScale(2, 1), currentRowIndex);
                    this.getModel().setValue("value_a", (Object)score.setScale(2, 1), currentRowIndex);
                    break;
                }
                this.getModel().setValue("value_a", (Object)0, currentRowIndex);
                this.getModel().setValue("scorerscore_a", (Object)0, currentRowIndex);
                this.getModel().setValue("score_a", (Object)0, currentRowIndex);
                this.getModel().setValue("scorerveto_a", null, currentRowIndex);
                break;
            }
        }
    }

    private void setIndexScore(String propertyName, int currentRowIndex, Object newValue) {
        DynamicObject scoreRow = this.getModel().getEntryRowEntity("score_entry", currentRowIndex);
        ArrayList<Object> indexIds = new ArrayList<Object>(10);
        indexIds.add(scoreRow.getLong("index_a.id"));
        String billNo = scoreRow.getString("billno_a");
        this.allotDynamicRuleData(indexIds, billNo);
        DynamicObjectCollection ruleRows = this.getModel().getEntryEntity("rule_entry");
        Map resultMap = SrmScoreUtil.calculateScore((DynamicObject)scoreRow, (DynamicObjectCollection)ruleRows);
        if (((Boolean)resultMap.get("succed")).booleanValue()) {
            this.getModel().setValue("score_a", resultMap.get("score"), currentRowIndex);
            if (propertyName.equals("accordance") || propertyName.equals("value_a")) {
                this.getModel().beginInit();
                BigDecimal score = scoreRow.getBigDecimal("value_a");
                this.getModel().setValue("valuetext_a", (Object)score.setScale(2, 1), currentRowIndex);
                this.getModel().endInit();
                this.getView().updateView("score_entry");
            }
            this.getModel().setValue("scorerveto_a", resultMap.get("scorerveto"), currentRowIndex);
            this.getModel().setValue("scorerscore_a", resultMap.get("scorerscore"), currentRowIndex);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u503c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SrmScoreHelper_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            this.isChanging = true;
            this.getModel().setValue("value_a", null, currentRowIndex);
            this.isChanging = false;
            this.getModel().setValue("score_a", null, currentRowIndex);
            this.getModel().setValue("scorerveto_a", (Object)"9", currentRowIndex);
            this.getModel().setValue("scorerscore_a", null, currentRowIndex);
        }
        if ("accordance".equals(propertyName) && newValue != null && StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("value_a", null, currentRowIndex);
            this.getModel().setValue("valuetext_a", null, currentRowIndex);
            this.getModel().setValue("scorerveto_a", null, currentRowIndex);
        }
        this.initGridStyle();
        DynamicObjectCollection score_entry = this.getModel().getEntryEntity("score_entry");
        String property = ((DynamicObject)score_entry.get(currentRowIndex)).getString("index_a.property");
        if (!"2".equals(property) && newValue != null && StringUtils.isNotBlank((CharSequence)newValue.toString())) {
            int row = 0;
            DynamicObjectCollection rule_entry = this.getModel().getEntryEntity("rule_entry");
            for (DynamicObject ruleRow : rule_entry) {
                if ("accordance".equals(propertyName)) {
                    String accordance_b = ruleRow.getString("accordance_b");
                    if (newValue.toString().equals(accordance_b)) {
                        this.setGridStyle(row);
                        break;
                    }
                } else {
                    BigDecimal value = new BigDecimal(newValue.toString());
                    BigDecimal valuefrom_b = ruleRow.getBigDecimal("valuefrom_b");
                    BigDecimal valueto_b = ruleRow.getBigDecimal("valueto_b");
                    if (value.compareTo(valuefrom_b) >= 0 && value.compareTo(valueto_b) < 0) {
                        this.setGridStyle(row);
                        break;
                    }
                }
                ++row;
            }
        }
        this.setScoreGridStyle();
    }

    private void setScoreGridStyle() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("score_entry");
        ArrayList<CellStyle> initStyles = this.assmbleScoreEntryCellStyle("#fffacd", "##000000");
        grid.setCellStyle(initStyles);
    }

    private ArrayList<CellStyle> assmbleScoreEntryCellStyle(String backColor, String foreColor) {
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        DynamicObjectCollection score_entry = this.getModel().getEntryEntity("score_entry");
        int rowIndex = 0;
        for (DynamicObject entryRow : score_entry) {
            CellStyle cs = new CellStyle();
            cs.setBackColor(backColor);
            cs.setForeColor(foreColor);
            String property = entryRow.getString("index_a.property");
            if (StringUtils.isNotBlank((CharSequence)"property") && "3".equals(property)) {
                cs.setFieldKey("accordance");
                cs.setRow(rowIndex);
                csList.add(cs);
            } else if (StringUtils.isNotBlank((CharSequence)"property") && ("1".equals(property) || "2".equals(property))) {
                cs.setFieldKey("valuetext_a");
                cs.setRow(rowIndex);
                csList.add(cs);
            }
            ++rowIndex;
        }
        return csList;
    }

    private void setGridStyle(int row) {
        ArrayList<String> setColorPro = new ArrayList<String>(10);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("rule_entry");
        DynamicObjectCollection rule_entry = this.getModel().getEntryEntity("rule_entry");
        DataEntityPropertyCollection properties = rule_entry.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            setColorPro.add(name);
        }
        ArrayList<CellStyle> cellStyles = this.assmbleCellStyle(row, setColorPro, "#fffacd", "##000000");
        grid.setCellStyle(cellStyles);
    }

    private ArrayList<CellStyle> assmbleCellStyle(int row, List<String> setColorPro, String backColor, String foreColor) {
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        for (String pro : setColorPro) {
            CellStyle cs = new CellStyle();
            cs.setBackColor(backColor);
            cs.setForeColor(foreColor);
            cs.setFieldKey(pro);
            cs.setRow(row);
            csList.add(cs);
        }
        return csList;
    }

    private void initGridStyle() {
        ArrayList<String> setColorPro = new ArrayList<String>(10);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("rule_entry");
        DynamicObjectCollection rule_entry = this.getModel().getEntryEntity("rule_entry");
        DataEntityPropertyCollection properties = rule_entry.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            setColorPro.add(name);
        }
        ArrayList<CellStyle> initStyles = this.assmbleInitCellStyle(rule_entry.size(), setColorPro, "#fff", "##000000");
        grid.setCellStyle(initStyles);
    }

    private ArrayList<CellStyle> assmbleInitCellStyle(int size, List<String> setColorPro, String backColor, String foreColor) {
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        for (int row = 0; row < size; ++row) {
            for (String pro : setColorPro) {
                CellStyle cs = new CellStyle();
                cs.setBackColor(backColor);
                cs.setForeColor(foreColor);
                cs.setFieldKey(pro);
                cs.setRow(row);
                csList.add(cs);
            }
        }
        return csList;
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    private boolean isExceedingMaximumValue(String str) {
        return new BigDecimal(str).compareTo(new BigDecimal("999999999")) >= 0;
    }

    private void allotDynamicReferData(ArrayList<Object> indexIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Date date = TimeServiceHelper.now();
        String currSupplier = this.getPageCache().get("supplier");
        if (StringUtils.isEmpty((CharSequence)currSupplier) || !StringUtils.isNumeric((CharSequence)currSupplier)) {
            return;
        }
        Long supplierId = null;
        try {
            supplierId = Long.parseLong(currSupplier);
        }
        catch (NumberFormatException e) {
            this.log.error("SrmScoreHelper parseLong Excetion :", (Object)e.getMessage());
        }
        QFilter qFilter = new QFilter("entry.indexscored", "=", (Object)"1").and("supplier", "=", (Object)supplierId).and("entry.index", "in", indexIds).and("entry.subentry.scorer", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        StringBuilder selectFields = SrmScoreUtil.assembleScoreSelectFields();
        DynamicObjectCollection rows = ORMUtil.queryDynamicObjectCollection((String)"srm_score", (String)selectFields.toString(), (QFilter[])new QFilter[]{qFilter}, (String)"billdate");
        List proRecEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity("refer_entry").getDynamicObjectType());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData("refer_entry");
        int rowCount = 0;
        for (DynamicObject row : rows) {
            Map dynMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
            for (Map.Entry entry : dynMap.entrySet()) {
                String key = (String)entry.getKey() + "_c";
                Object value = entry.getValue();
                if (!proRecEntity.contains(key)) continue;
                vs.set(key, value, rowCount);
            }
            ++rowCount;
        }
        model.batchCreateNewEntryRow("refer_entry", vs);
    }

    private void allotDynamicRuleData(ArrayList<Object> indexIds, String billNo) {
        if (indexIds.size() != 1) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String selectFields = "number, name,isformula,property,entryentity1.subentryentity1.item1 item, entryentity1.subentryentity1.valuefrom1 valuefrom, entryentity1.subentryentity1.valueto1 valueto ,entryentity1.subentryentity1.itemscore1 itemscore,entryentity1.subentryentity1.formula1 formula,entryentity1.subentryentity1.accordance1 accordance,entryentity1.subentryentity1.veto1 veto,entryentity1.subentryentity1.note1 note";
        QFilter qf = new QFilter("id", "in", indexIds);
        DynamicObject srm_score = QueryServiceHelper.queryOne((String)"srm_score", (String)"id,category,material", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (srm_score == null) {
            return;
        }
        long category = srm_score.getLong("category");
        long material = srm_score.getLong("material");
        if (material != 0L) {
            qf.and("entryentity1.material", "=", (Object)material);
        } else if (category != 0L) {
            qf.and("entryentity1.category", "=", (Object)category);
        } else {
            qf.and("entryentity1.isgenericrule", "=", (Object)true);
        }
        DynamicObjectCollection rows = ORMUtil.queryDynamicObjectCollection((String)"srm_index", (String)selectFields, (QFilter[])new QFilter[]{qf}, (String)"entryentity1.seq");
        if (rows.isEmpty()) {
            qf = new QFilter("id", "in", indexIds);
            qf.and("entryentity1.isgenericrule", "=", (Object)true);
            rows = ORMUtil.queryDynamicObjectCollection((String)"srm_index", (String)selectFields, (QFilter[])new QFilter[]{qf}, (String)"entryentity1.seq");
        }
        if (rows != null && !rows.isEmpty()) {
            String property = ((DynamicObject)rows.get(0)).getString("property");
            if ("1".equals(property)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"item_b", "valuefrom_b", "valueto_b", "formula_b"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accordance_b"});
            } else if ("2".equals(property)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"item_b"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accordance_b", "valuefrom_b", "valueto_b", "formula_b"});
            } else if ("3".equals(property)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"accordance_b"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"item_b", "valuefrom_b", "valueto_b", "formula_b"});
            }
        }
        List proRuleEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity("rule_entry").getDynamicObjectType());
        model.deleteEntryData("rule_entry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        boolean isformula = false;
        if (rows != null && !rows.isEmpty()) {
            for (DynamicObject row : rows) {
                isformula = row.getBoolean("isformula");
                Map dynMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
                for (Map.Entry entry : dynMap.entrySet()) {
                    String key = (String)entry.getKey() + "_b";
                    Object value = entry.getValue();
                    if (!proRuleEntity.contains(key)) continue;
                    vs.set(key, value, rowCount);
                }
                ++rowCount;
            }
            this.getView().setVisible(Boolean.valueOf(!isformula), new String[]{"itemscore_b"});
            this.getView().setVisible(Boolean.valueOf(isformula), new String[]{"formula_b"});
            model.batchCreateNewEntryRow("rule_entry", vs);
        }
    }

    private void allotDynamicAttachmentData(Set<Long> planbillids) {
        AttachmentPanel attach = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        ArrayList attlist = new ArrayList(10);
        for (long planbillid : planbillids) {
            attlist.addAll(AttachmentServiceHelper.getAttachments((String)"srm_evaplan", (Object)planbillid, (String)"attachmentpanel"));
        }
        attach.bindData(attlist);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String fieldKey = ((TextEdit)evt.getSource()).getFieldKey();
        if (fieldKey.equals("accordance")) {
            String indexStr = this.getView().getPageCache().get("accordanceindex");
            int index = Integer.parseInt(indexStr);
            DynamicObjectCollection score_entry = this.getModel().getEntryEntity("score_entry");
            DynamicObject curIndex = ((DynamicObject)score_entry.get(index)).getDynamicObject("index_a");
            DynamicObject curCategory = ((DynamicObject)score_entry.get(index)).getDynamicObject("category_a");
            DynamicObject curMaterial = ((DynamicObject)score_entry.get(index)).getDynamicObject("material_a");
            Object pkValue = curIndex.getPkValue();
            Long categoryId = curCategory == null ? 0L : curCategory.getLong("id");
            Long materialId = curMaterial == null ? 0L : curMaterial.getLong("id");
            DynamicObjectCollection srm_index = QueryServiceHelper.query((String)"srm_index", (String)"id,entryentity1.subentryentity1.accordance1,entryentity1.subentryentity1.itemscore1", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue).and("entryentity1.category", "=", (Object)categoryId).and("entryentity1.material", "=", (Object)materialId)});
            this.accordanceList.clear();
            if (srm_index == null || srm_index.isEmpty()) {
                srm_index = QueryServiceHelper.query((String)"srm_index", (String)"id,entryentity1.subentryentity1.accordance1,entryentity1.subentryentity1.itemscore1", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue).and("entryentity1.isgenericrule", "=", (Object)true)});
            }
            int num = 0;
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (DynamicObject entryRow : srm_index) {
                String accordance = entryRow.getString("entryentity1.subentryentity1.accordance1");
                HashMap accordanceMap = new HashMap(1);
                BigDecimal bigDecimal = entryRow.getBigDecimal("entryentity1.subentryentity1.itemscore1");
                HashMap<String, BigDecimal> tmpMap = new HashMap<String, BigDecimal>(1);
                tmpMap.put("accordanceindex" + num, bigDecimal);
                accordanceMap.put(accordance, tmpMap);
                String scoreKey = "accordanceindex" + num;
                String accordanceKey = "accordanceindex" + num + "name";
                map.put(scoreKey, bigDecimal + "");
                map.put(accordanceKey, accordance);
                ++num;
                this.accordanceList.add(accordanceMap);
            }
            this.getView().getPageCache().put(map);
            String number = curIndex.getString("number");
            String name = curIndex.getString("name");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("number", number);
            paramMap.put("name", name);
            paramMap.put("accordanceList", this.accordanceList);
            String selectBaseDataFieldsForm = "srm_selectaccordance";
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, fieldKey));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String property;
        String billNo;
        long billid_a;
        DynamicObjectCollection dynamicObjects;
        super.entryRowClick(evt);
        int rowIndex = evt.getRow();
        this.getView().getPageCache().put("accordanceindex", rowIndex + "");
        HashSet<Long> planbillids = new HashSet<Long>(16);
        EntryGrid grid = (EntryGrid)evt.getSource();
        int[] selectedIndexs = grid.getEntryState().getSelectedRows();
        if (selectedIndexs != null && selectedIndexs.length != 1) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("rule_entry");
            return;
        }
        DynamicObjectCollection col = this.getModel().getEntryEntity("score_entry");
        if (col == null || col.size() == 0) {
            return;
        }
        if (selectedIndexs != null) {
            for (int i = 0; i < selectedIndexs.length; ++i) {
                int index = selectedIndexs[i];
                long id = ((DynamicObject)col.get(index)).getLong("taskbillid_a");
                planbillids.add(id);
            }
        }
        this.allotDynamicAttachmentData(planbillids);
        DynamicObject row = this.getModel().getEntryRowEntity("score_entry", rowIndex);
        if (Objects.nonNull(row) && !CollectionUtils.isEmpty((Collection)(dynamicObjects = this.queryScoreRows(new QFilter[]{new QFilter("id", "=", (Object)(billid_a = row.getLong("billid_a")))})))) {
            this.allotDynamicHeadData((DynamicObject)dynamicObjects.get(0));
        }
        DynamicObject indexId = row != null ? row.getDynamicObject("index_a") : null;
        String string = billNo = row != null ? row.getString("billno_a") : null;
        if (null != indexId) {
            ArrayList<Object> indexIds = new ArrayList<Object>(1);
            indexIds.add(indexId.getPkValue());
            this.allotDynamicRuleData(indexIds, billNo);
            this.allotDynamicReferData(indexIds);
        }
        DynamicObjectCollection score_entry = this.getModel().getEntryEntity("score_entry");
        if (rowIndex >= 0 && !"2".equals(property = ((DynamicObject)score_entry.get(rowIndex)).getString("index_a.property"))) {
            this.initGridStyle();
            DynamicObjectCollection rule_entry = this.getModel().getEntryEntity("rule_entry");
            String valuetext_a = ((DynamicObject)score_entry.get(rowIndex)).getString("valuetext_a");
            BigDecimal value = new BigDecimal(-1);
            if (StringUtils.isNotBlank((CharSequence)valuetext_a) && this.isNumeric(valuetext_a)) {
                value = new BigDecimal(valuetext_a);
            }
            String accordance = ((DynamicObject)score_entry.get(rowIndex)).getString("accordance");
            int ruleIndex = 0;
            for (DynamicObject ruleRow : rule_entry) {
                String accordance_b;
                if ("1".equals(property)) {
                    BigDecimal valuefrom_b = ruleRow.getBigDecimal("valuefrom_b");
                    BigDecimal valueto_b = ruleRow.getBigDecimal("valueto_b");
                    if (value.compareTo(valuefrom_b) >= 0 && value.compareTo(valueto_b) < 0) {
                        this.setGridStyle(ruleIndex);
                        break;
                    }
                } else if ("3".equals(property) && accordance.equals(accordance_b = ruleRow.getString("accordance_b"))) {
                    this.setGridStyle(ruleIndex);
                    break;
                }
                ++ruleIndex;
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowClick(evt);
    }

    public void afterUpload(UploadEvent evt) {
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u5165\u4e2d", (String)"SrmScoreHelper_8", (String)"scm-srm-formplugin", (Object[])new Object[0])));
            this.getPageCache().put("isTreeNodeClick", null);
            this.importThenAllotDynamicData("");
            this.saveScore();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.getView().hideLoading();
        }
    }

    public void importThenAllotDynamicData(String supplier) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        ArrayList<String> bizStatusList = new ArrayList<String>(3);
        bizStatusList.add(SrmScoreStatusEnum.TOBESCORE.getValue());
        bizStatusList.add(SrmScoreStatusEnum.PARTSCORED.getValue());
        filter.and("bizstatus", "in", bizStatusList);
        filter.and("entry.index.scoretype", "=", (Object)"1");
        filter.and("entry.subentry.scorer", "=", (Object)CommonUtil.parseLong((String)RequestContext.get().getUserId()));
        if (StringUtils.isNotBlank((CharSequence)supplier) && !"0".equals(supplier)) {
            filter.and("supplier", "=", (Object)CommonUtil.parseLong((String)supplier));
        } else {
            this.getPageCache().put("supplier", null);
            supplier = null;
        }
        String detailIDValueStr = this.getPageCache().get("detailIDValue");
        this.log.info("!!detailIDValueStr\uff1a" + detailIDValueStr);
        JSONObject detailIDValueJo = JSONObject.fromObject((Object)detailIDValueStr);
        QFilter detailIdFilter = new QFilter("entry.subentry.id", "in", (Object)detailIDValueJo.keySet().stream().mapToLong(info -> CommonUtil.parseLong((String)String.valueOf(info))).toArray());
        this.log.info("\u56fa\u5b9a\u8fc7\u6ee4\u6761\u4ef6filter\uff1a" + filter);
        this.log.info("detailIdFilter:" + detailIdFilter);
        DynamicObjectCollection scoreRows = this.queryScoreRows(new QFilter[]{filter, detailIdFilter});
        this.allotDynamicData(supplier, scoreRows);
        if (scoreRows.size() == 0) {
            if ("srm_scorehelper".equals(this.getModel().getDataEntityType())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bc4\u5206\u6570\u636e\u65e0\u6548", (String)"SrmScoreHelper_7", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageTypes.Business, new ConfirmCallBackListener("openQuery"));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bc4\u5206\u6570\u636e\u65e0\u6548", (String)"SrmScoreHelper_7", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageTypes.Business, null);
            }
            return;
        }
        this.getModel().beginInit();
        int rowCount = this.getModel().getEntryRowCount("score_entry");
        for (int currentRowIndex = 0; currentRowIndex < rowCount; ++currentRowIndex) {
            String detailId = String.valueOf(this.getModel().getValue("detailid_a", currentRowIndex));
            if (!detailIDValueJo.containsKey((Object)detailId)) continue;
            this.getModel().setValue("value_a", detailIDValueJo.get(detailId), currentRowIndex);
            DynamicObject scoreRow = this.getModel().getEntryRowEntity("score_entry", currentRowIndex);
            ArrayList<Object> indexIds = new ArrayList<Object>(10);
            indexIds.add(scoreRow.getLong("index_a.id"));
            String billNo = scoreRow.getString("billno_a");
            this.allotDynamicRuleData(indexIds, billNo);
            DynamicObjectCollection ruleRows = this.getModel().getEntryEntity("rule_entry");
            Map resultMap = SrmScoreUtil.calculateScore((DynamicObject)scoreRow, (DynamicObjectCollection)ruleRows);
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                this.getModel().setValue("score_a", resultMap.get("score"), currentRowIndex);
                BigDecimal score = scoreRow.getBigDecimal("value_a");
                this.getModel().setValue("valuetext_a", (Object)score.setScale(2, 1), currentRowIndex);
                this.getModel().setValue("scorerveto_a", resultMap.get("scorerveto"), currentRowIndex);
                this.getModel().setValue("scorerscore_a", resultMap.get("scorerscore"), currentRowIndex);
                continue;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u503c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SrmScoreHelper_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            this.isChanging = true;
            this.getModel().setValue("value_a", null, currentRowIndex);
            this.isChanging = false;
            this.getModel().setValue("score_a", null, currentRowIndex);
            this.getModel().setValue("scorerveto_a", (Object)"9", currentRowIndex);
            this.getModel().setValue("scorerscore_a", null, currentRowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("score_entry");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("openQuery".equals(callBackId)) {
            this.getPageCache().put("isTreeNodeClick", "0");
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_scorequery", (ShowType)ShowType.NonModal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "srm_scorequery"));
        }
    }

    public boolean saveScore() {
        DynamicObjectCollection scoreRows = this.getModel().getEntryEntity("score_entry");
        HashSet taskIds = new HashSet();
        HashSet scoreIds = new HashSet();
        HashMap scoreMap = new HashMap();
        SrmScoreUtil.verifyData((DynamicObjectCollection)scoreRows, taskIds, scoreIds, scoreMap, (String)VERIFYTYPE_SAVE);
        if (scoreMap.isEmpty()) {
            return false;
        }
        SrmScoreUtil.saveScoreDetail(scoreMap, (String)VERIFYTYPE_SAVE);
        return true;
    }
}

