/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrgUtil;

public class SrmScoreQuery
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        Date date = DateUtil.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)30);
        this.getModel().setValue("datefrom", (Object)DateUtil.addMonth((Date)date, (int)-3));
        this.getModel().setValue("dateto", (Object)date);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                boolean isSucced = true;
                StringBuilder sb = new StringBuilder();
                Date dateFrom = this.getModel().getDataEntity().getDate("datefrom");
                Date dateTo = this.getModel().getDataEntity().getDate("dateto");
                if (dateTo == null) {
                    isSucced = false;
                    sb = sb.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u65e5\u671f\u81f3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmScoreQuery_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                }
                if (dateFrom != null && dateFrom.after(dateTo)) {
                    isSucced = false;
                    sb = sb.append(ResManager.loadKDString((String)"\u201c\u8bc4\u4f30\u65e5\u671f\u4ece\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u8bc4\u4f30\u65e5\u671f\u81f3\u201d\u3002", (String)"SrmScoreQuery_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                }
                if (!isSucced) {
                    this.getView().showTipNotification(sb.toString());
                    args.setCancel(true);
                    return;
                }
                this.confirm();
            }
        }
    }

    private void confirm() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        DataEntityPropertyCollection propertiesentity = this.getModel().getDataEntity().getDataEntityType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : propertiesentity) {
            String nameKey = iDataEntityProperty.getName();
            Object object = this.getModel().getValue(nameKey);
            switch (nameKey) {
                case "datefrom": {
                    returnData.put(nameKey, object == null ? null : DateUtil.getFormatStartDate((Date)((Date)object)));
                    break;
                }
                case "dateto": {
                    returnData.put(nameKey, object == null ? null : DateUtil.getFormatEndDate((Date)((Date)object)));
                    break;
                }
                case "evatype": {
                    returnData.put(nameKey, object == null ? null : ((DynamicObject)object).getPkValue());
                    break;
                }
                case "org": {
                    returnData.put(nameKey, object == null ? null : ((DynamicObject)object).getPkValue());
                    break;
                }
                case "supplier": {
                    DynamicObjectCollection supplier = (DynamicObjectCollection)this.getModel().getValue("supplier");
                    returnData.put("supplier_id", CommonUtil.objs2str((Object[])DynamicObjectUtil.getMulBaseDataOfId((DynamicObjectCollection)supplier)));
                    break;
                }
                case "category": {
                    returnData.put(nameKey, object == null ? null : ((DynamicObject)object).getPkValue());
                    break;
                }
                case "scorestatus": {
                    returnData.put(nameKey, object == null ? null : object);
                    break;
                }
                case "name": {
                    returnData.put(nameKey, object == null ? null : object);
                    break;
                }
                case "material": {
                    MulBasedataDynamicObjectCollection materals = (MulBasedataDynamicObjectCollection)object;
                    List fbasedataids = materals.stream().map(x -> x.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
                    returnData.put(nameKey, object == null ? null : fbasedataids);
                }
            }
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit control = (BasedataEdit)this.getControl("material");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            List allPurPermssionOrgs = OrgUtil.getAllPermssionOrgs((String)"srm_scheme");
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allPurPermssionOrgs));
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"material")) {
            showParameter.setCustomParam("groupStandard", (Object)730148448254487552L);
        }
    }
}

