/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.util.AccessNodeUtil;

public class SrmBizTypeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow && ("save".equals(operateKey) || "submit".equals(operateKey))) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            AccessNodeUtil.sortAccessNode((DynamicObject)dynamicObject, (String)"entryentity", (boolean)true);
            this.getView().updateView();
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit supplier = (BasedataEdit)this.getControl("accessnode");
        supplier.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow) {
            BasedataEdit category = (BasedataEdit)this.getControl("accessnode");
            category.setMustInput(true);
            DynamicObject dyn = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynList = dyn.getDynamicObjectCollection("entryentity");
            Map existNumberMap = AccessNodeUtil.getExistNumberMap((DynamicObjectCollection)dynList);
            if (existNumberMap.isEmpty()) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                Map newNodeMap = AccessNodeUtil.getNodeNumberMap(null, (String)"1");
                int rowindex = 0;
                if (!dynList.isEmpty()) {
                    dynList.remove(0);
                }
                DynamicObject aptitudeexam = (DynamicObject)newNodeMap.remove("srm_aptitudeexam");
                DynamicObject supapprove = (DynamicObject)newNodeMap.remove("srm_supapprove");
                if (aptitudeexam != null) {
                    vs.set("accessnode", (Object)aptitudeexam.getLong("id"), rowindex);
                    ++rowindex;
                }
                if (!newNodeMap.isEmpty()) {
                    for (Map.Entry temp : newNodeMap.entrySet()) {
                        vs.set("accessnode", (Object)((DynamicObject)temp.getValue()).getLong("id"), rowindex);
                        ++rowindex;
                    }
                }
                if (supapprove != null) {
                    vs.set("accessnode", (Object)supapprove.getLong("id"), rowindex);
                    ++rowindex;
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.batchCreateNewEntryRow("entryentity", vs);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject billObj;
        DynamicObjectCollection dyns;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("accessnode".equals(fieldKey) && (dyns = (billObj = this.getModel().getDataEntity(true)).getDynamicObjectCollection("entryentity")) != null && !dyns.isEmpty()) {
            ArrayList<Long> numbers = new ArrayList<Long>(dyns.size());
            for (DynamicObject dyn : dyns) {
                DynamicObject temp = dyn.getDynamicObject("accessnode");
                if (temp == null) continue;
                numbers.add(temp.getLong("id"));
            }
            if (!numbers.isEmpty()) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("id", "not in", numbers);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }
}

