/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmEvaPlanStatusEnum;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.BaseDataViewDetailUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;

public class SrmEvaPlanEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private boolean isFirstChange = true;
    private boolean isChanging = false;
    private static final String EVAMETEOD = "evamethod";
    private static final String SUBENTRY = "subentryentity";
    private static final String BATCHFILLMATERIAL = "batchfillmaterial";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        String bizStatus = this.getModel().getDataEntity().getString("bizstatus");
        long billId = (Long)this.getModel().getDataEntity().getPkValue();
        switch (key) {
            case "bar_push": {
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
                if (Objects.isNull(dynamicObject)) {
                    return;
                }
                String bdbillstatus = dynamicObject.getString("billstatus");
                String bdbizstatus = dynamicObject.getString("bizstatus");
                if (BillStatusEnum.AUDIT.getVal().equals(bdbillstatus) && SrmEvaPlanStatusEnum.TOBEPUSH.getValue().equals(bdbizstatus)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u8ba1\u5212\u72b6\u6001\u4e3a\u5f85\u4e0b\u8fbe\u7684\u8ba1\u5212\u624d\u80fd\u4e0b\u8fbe\u3002", (String)"SrmEvaPlanEdit_10", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                evt.setCancel(true);
                return;
            }
            case "bar_terminate": {
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                if (!bizStatus.equals(SrmEvaPlanStatusEnum.APPROVED.getValue()) && !bizStatus.equals(SrmEvaPlanStatusEnum.ENDED.getValue())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6838\u51c6\u6216\u5df2\u7ec8\u6b62\u7684\u8bc4\u4f30\u8ba1\u5212\u4e0d\u5141\u8bb8\u7ec8\u6b62\u3002", (String)"SrmEvaPlanEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "queryresult": {
                IFormView view = this.getView();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("billid", this.getModel().getDataEntity().getPkValue());
                OpenFormUtil.openDynamicPage((IFormView)view, (String)"srm_evaresult", (ShowType)ShowType.MainNewTabPage, paramMap, null);
                break;
            }
            case "queryreport": {
                if (!SrmEvaPlanStatusEnum.APPROVED.getValue().equals(bizStatus)) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u6838\u51c6\u201d\u7684\u6570\u636e\u884c\u624d\u5141\u8bb8\u62a5\u8868\u67e5\u770b\u3002", (String)"SrmEvaPlanEdit_5", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    break;
                }
                ReportShowParameter reportShowParameter = new ReportShowParameter();
                reportShowParameter.setFormId("srm_evaplanreport");
                reportShowParameter.setStatus(OperationStatus.ADDNEW);
                reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                reportShowParameter.setCustomParam("evplan.id", (Object)billId);
                this.getView().showForm((FormShowParameter)reportShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "scorer": {
                if (returnData == null) break;
                ListSelectedRowCollection supplierRows = (ListSelectedRowCollection)returnData;
                this.setScorer(supplierRows.getPrimaryKeyValues());
                break;
            }
            case "callbackid": {
                this.getView().invokeOperation("refresh");
                BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                break;
            }
        }
    }

    protected void setScorer(Object[] scorerPks) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entry_scorer");
        DynamicObject indexClass = ((DynamicObject)this.getModel().getEntryEntity("entry_scorer").get(currentRowIndex)).getDynamicObject("indexclass");
        IDataEntityProperty dataEntityProperty = this.getModel().getProperty("entry_scorer");
        int rowIndex = currentRowIndex;
        for (Object scorer : scorerPks) {
            if (rowIndex > currentRowIndex) {
                int insertIndex = ((BillModel)this.getModel()).insertEntryRow(dataEntityProperty.getName(), rowIndex);
                this.getModel().setValue("indexclass", (Object)indexClass, insertIndex);
                this.getModel().setValue("scorer", scorer, insertIndex);
            } else {
                this.getModel().setValue("scorer", scorer, currentRowIndex);
            }
            ++rowIndex;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject scheme = dataEntity.getDynamicObject("scheme");
        String billstatus = dataEntity.getString("billstatus");
        String bizstatus = dataEntity.getString("bizstatus");
        if (Objects.nonNull(scheme) && StringUtils.isNotEmpty((CharSequence)billstatus) && StringUtils.isNotEmpty((CharSequence)bizstatus)) {
            DynamicObjectCollection entryentity = scheme.getDynamicObjectCollection("entryentity");
            Set indexIds = entryentity.stream().map(x -> x.getLong("index.id")).collect(Collectors.toSet());
            DynamicObjectCollection queryIndex = QueryServiceHelper.query((String)"srm_index", (String)"id,scoretype", (QFilter[])new QFilter[]{new QFilter("id", "in", indexIds)});
            Boolean isContainAutoIndex = false;
            for (DynamicObject dynamicObject : queryIndex) {
                String scoretype = dynamicObject.getString("scoretype");
                if (!"9".equals(scoretype)) continue;
                isContainAutoIndex = true;
                break;
            }
            if (isContainAutoIndex.booleanValue() && "C".equals(billstatus) && "C".equals(bizstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"reautoscore"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"reautoscore"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reautoscore"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "submit": 
            case "save": {
                this.removeDuplicateMaterial();
                this.getView().updateView(SUBENTRY);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        long billId = (Long)this.getModel().getDataEntity().getPkValue();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "audit": 
                case "unaudit": 
                case "push": {
                    this.getView().invokeOperation("refresh");
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                    break;
                }
                case "pushandsave": {
                    OperateOption option = OperateOption.create();
                    OperationServiceHelper.executeOperate((String)"sendmsg", (String)"srm_evaplan", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)option);
                    this.getView().invokeOperation("refresh");
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                    break;
                }
                case "terminate": {
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_evaplanend", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
                    this.getView().invokeOperation("refresh");
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                    break;
                }
                case "batchfillmaterial": {
                    this.batchfillMaterial();
                    break;
                }
            }
        } else {
            switch (operateKey) {
                case "pushandsave": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    private void removeDuplicateMaterial() {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject entryDy : entryentity) {
            DynamicObjectCollection subentryentity = entryDy.getDynamicObjectCollection(SUBENTRY);
            ArrayList<Long> exitMaterials = new ArrayList<Long>(12);
            Iterator iterator = subentryentity.iterator();
            while (iterator.hasNext()) {
                DynamicObject subentryDy = (DynamicObject)iterator.next();
                Long material = subentryDy.getLong("material.id");
                if (exitMaterials.contains(material)) {
                    iterator.remove();
                    continue;
                }
                exitMaterials.add(material);
            }
        }
    }

    private void batchfillMaterial() {
        EntryGrid subentryentityControl = (EntryGrid)this.getView().getControl(SUBENTRY);
        if (Objects.isNull(subentryentityControl)) {
            return;
        }
        DynamicObject[] subEntitys = subentryentityControl.getEntryData().getDataEntitys();
        int[] selectSubentryentityRows = subentryentityControl.getSelectRows();
        if (selectSubentryentityRows.length == 0) {
            this.getView().showMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u9700\u8981\u6279\u91cf\u586b\u5145\u7684\u8bc4\u4f30\u7269\u6599\u3002", (String)"SrmEvaPlanEdit_7", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmEvaPlanEdit_7", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> selectMaterial = new ArrayList<DynamicObject>(12);
        if (Objects.isNull(subEntitys) || subEntitys.length <= 0) {
            return;
        }
        for (int selectSubentryentityRow : selectSubentryentityRows) {
            if (subEntitys.length <= selectSubentryentityRow) continue;
            DynamicObject subselectData = subEntitys[selectSubentryentityRow];
            DynamicObject selectmMterial = subselectData.getDynamicObject("material");
            selectMaterial.add(selectmMterial);
        }
        DynamicObjectCollection entryentitys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentitys) {
            DynamicObjectCollection subentryentity = entryentity.getDynamicObjectCollection(SUBENTRY);
            DynamicObject supplier = entryentity.getDynamicObject("supplier");
            if (Objects.isNull(supplier)) continue;
            if (!CollectionUtils.isEmpty((Collection)subentryentity)) {
                List materials = subentryentity.stream().map(x -> x.getDynamicObject("material")).collect(Collectors.toList());
                Set filterSelectMaterial = selectMaterial.stream().filter(x -> !materials.contains(x)).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(filterSelectMaterial)) continue;
                for (DynamicObject addMaterial : filterSelectMaterial) {
                    DynamicObject addRow = subentryentity.addNew();
                    addRow.set("material", (Object)addMaterial);
                }
                continue;
            }
            for (DynamicObject addMaterial : selectMaterial) {
                DynamicObject addRow = subentryentity.addNew();
                addRow.set("material", (Object)addMaterial);
            }
        }
    }

    protected String getStatusTabValue() {
        DynamicObject obj = this.getModel().getDataEntity();
        String bizStatus = obj.getString("bizstatus");
        return bizStatus == null ? "" : bizStatus.toLowerCase();
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        super.propertyChanged(arg0);
        String propertyName = arg0.getProperty().getName();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "evatype": 
            case "org": 
            case "category": {
                this.getModel().setValue("scheme", null);
                this.getModel().setValue("grade", null);
                break;
            }
            case "scheme": {
                this.isChanging = true;
                this.setScorerEntryFromScheme();
                this.isChanging = false;
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.deleteEntryData("entry_index");
                break;
            }
            case "istypescorer": {
                if (this.isChanging) {
                    return;
                }
                this.getModel().deleteEntryData("entry_scorer");
                this.getModel().insertEntryRow("entry_scorer", 0);
                break;
            }
            case "supplier": {
                if (!this.isFirstChange) {
                    return;
                }
                DynamicObject newObject = (DynamicObject)arg0.getChangeSet()[0].getNewValue();
                if (newObject == null) {
                    return;
                }
                DynamicObjectCollection entryRows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                if (entryRows == null || entryRows.size() == 0) {
                    return;
                }
                int repeatCount = 0;
                int currentRow = arg0.getChangeSet()[0].getRowIndex();
                DynamicObject tempObject = null;
                for (DynamicObject obj : entryRows) {
                    tempObject = obj.getDynamicObject("supplier");
                    if (tempObject != null && tempObject.getPkValue().equals(newObject.getPkValue())) {
                        ++repeatCount;
                    }
                    if (repeatCount != 2) continue;
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f55\u5165\u76f8\u540c\u7684\u201c\u4f9b\u5e94\u5546\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SrmEvaPlanEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    this.isFirstChange = false;
                    this.getModel().setValue("supplier", null, currentRow);
                    this.isFirstChange = true;
                    return;
                }
                break;
            }
            case "evamethod": {
                String evamethod = this.getModel().getDataEntity().getString(EVAMETEOD);
                BasedataEdit control = (BasedataEdit)this.getControl("category");
                if ("B".equals(evamethod)) {
                    control.setMustInput(true);
                } else {
                    control.setMustInput(false);
                    DynamicObjectCollection supentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    for (DynamicObject sup : supentry) {
                        DynamicObjectCollection subentry = sup.getDynamicObjectCollection(SUBENTRY);
                        if (CollectionUtils.isEmpty((Collection)subentry)) continue;
                        subentry.clear();
                    }
                    this.getView().updateView(SUBENTRY);
                }
                DynamicObjectCollection supEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (DynamicObject entryRow : supEntry) {
                    entryRow.set("bizbilltype", null);
                    entryRow.set("bizbillno", null);
                }
                if ("C".equals(evamethod)) {
                    supEntry.clear();
                    this.getView().updateView("entryentity");
                }
            }
            case "bizbillno": {
                DynamicObject entryRow;
                if (rowIndex < 0) {
                    return;
                }
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                entryRow = (DynamicObject)entryentity.get(rowIndex);
                if (entryRow == null) break;
                String bizbilltypeId = entryRow.getString("bizbilltype.id");
                String bizbillno = entryRow.getString("bizbillno");
                if (StringUtils.isBlank((CharSequence)bizbilltypeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4e1a\u52a1\u5355\u636e\u201d\u3002", (String)"SrmEvaPlanEdit_8", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                } else if (StringUtils.isNotBlank((CharSequence)bizbillno)) {
                    DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((String)bizbilltypeId, (String)"id,supplier", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)bizbillno)});
                    if (bizBill != null) {
                        DynamicObject supplier = bizBill.getDynamicObject("supplier");
                        entryRow.set("supplier", (Object)supplier);
                    } else {
                        entryRow.set("supplier", null);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u53f7\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SrmEvaPlanEdit_9", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    entryRow.set("supplier", null);
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "bizbilltype": {
                DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity");
                DynamicObject entryRow1 = (DynamicObject)entryentity1.get(rowIndex);
                entryRow1.set("bizbillno", null);
                entryRow1.set("supplier", null);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scheme = (BasedataEdit)this.getView().getControl("scheme");
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizbilltype = (BasedataEdit)this.getView().getControl("bizbilltype");
        bizbilltype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit grade = (BasedataEdit)this.getView().getControl("grade");
        grade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit indexClass = (BasedataEdit)this.getView().getControl("indexclass");
        indexClass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scorer = (BasedataEdit)this.getView().getControl("scorer");
        scorer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit category = (BasedataEdit)this.getView().getControl("category");
        category.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit groupevaplanno = (BasedataEdit)this.getControl("groupevaplanno");
        groupevaplanno.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        groupevaplanno.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"srm_groupevaplan", (String)"srm_groupevaplan"));
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent f7SelectEvent) {
        String fieldKey = f7SelectEvent.getProperty().getName();
        int row = f7SelectEvent.getRow();
        ListShowParameter showParameter = (ListShowParameter)f7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"scheme")) {
            Map resultMap = SrmBillEditUtil.getSchemeFilter((IDataModel)this.getModel());
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                f7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"supplier")) {
            GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"grade")) {
            if (this.getModel().getDataEntity().getDynamicObject("scheme") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc4\u4f30\u65b9\u6848\uff0c\u518d\u9009\u62e9\u5206\u7ea7\u65b9\u6848\u3002", (String)"SrmEvaPlanEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                f7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"indexclass")) {
            Map resultMap = SrmBillEditUtil.getIndexClassFilterFromScheme((IDataModel)this.getModel());
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                f7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"scorer")) {
            DynamicObjectCollection entryScorer = this.getModel().getEntryEntity("entry_scorer");
            DynamicObject indexClass = ((DynamicObject)entryScorer.get(row)).getDynamicObject("indexclass");
            if (indexClass != null) {
                DynamicObject scorer = ((DynamicObject)entryScorer.get(row)).getDynamicObject("scorer");
                if (scorer != null) {
                    ((ListShowParameter)f7SelectEvent.getFormShowParameter()).setMultiSelect(false);
                }
                f7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scorer"));
            } else {
                f7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6307\u6807\u5206\u7c7b\u3002", (String)"SrmEvaPlanEdit_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"material")) {
            String evamethed = this.getModel().getDataEntity().getString(EVAMETEOD);
            DynamicObject category = this.getModel().getDataEntity().getDynamicObject("category");
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
            if ("B".equals(evamethed) && Objects.isNull(category)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8bc4\u4f30\u54c1\u7c7b\u3002", (String)"SrmEvaPlanEdit_11", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                f7SelectEvent.setCancel(true);
                return;
            }
            if (Objects.nonNull(category)) {
                QFilter filter = new QFilter("group.id", "=", category.getPkValue());
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"category")) {
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
        }
    }

    private void setScorerEntryFromScheme() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entry_scorer");
        long schemeId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("scheme"));
        if (schemeId == 0L) {
            this.getModel().setValue("grade", null);
            return;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
        if (schemeObj == null) {
            return;
        }
        this.getModel().setValue("istypescorer", (Object)schemeObj.getBoolean("istypescorer"));
        DynamicObject gradeDynamicObject = schemeObj.getDynamicObject("grade");
        if (Objects.nonNull(gradeDynamicObject)) {
            this.getModel().setValue("grade", (Object)gradeDynamicObject);
        } else {
            this.getModel().setValue("grade", null);
        }
        DynamicObjectCollection scorerEntries = schemeObj.getDynamicObjectCollection("entry_scorer");
        if (scorerEntries == null || scorerEntries.size() == 0) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < scorerEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)scorerEntries.get(i);
            long indexclass = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("indexclass"));
            long scorer = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("scorer"));
            BigDecimal scorerweight = entry.getBigDecimal("scorerweight");
            String note = entry.getString("scorernote");
            vs.set("seq", (Object)(i + 1), i);
            vs.set("indexclass", (Object)indexclass, i);
            vs.set("scorer", (Object)scorer, i);
            vs.set("scorerweight", (Object)scorerweight, i);
            vs.set("scorernote", (Object)note, i);
        }
        model.batchCreateNewEntryRow("entry_scorer", vs);
    }
}

