/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.RfiVisibleUtil;
import kd.scm.srm.common.SrmIssueRfiUtil;
import kd.scm.srm.common.SrmSendEmailUtil;

public class SrmIssueRfiEdit
extends AbstractBillPlugIn {
    private static final int maxSelectLength = 1;
    private static Log logger = LogFactory.getLog(SrmIssueRfiEdit.class);

    public void afterCreateNewData(EventObject e) {
        this.setRfiEntry();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("certifiapply".equals(name)) {
            long certifiapplyId = this.getModel().getDataEntity().getLong("certifiapply.id");
            if (certifiapplyId == 0L) {
                this.setRfiEntry();
                return;
            }
            DynamicObject srm_certificationapply = QueryServiceHelper.queryOne((String)"srm_certificationapply", (String)"biztype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)certifiapplyId)});
            long orgId = this.getModel().getDataEntity().getLong("org.id");
            long bizTypeId = srm_certificationapply.getLong("biztype");
            DynamicObjectCollection rfiConfigContents = RfiVisibleUtil.queryRfiContentByBiztype((Long)bizTypeId, (Long)orgId);
            this.getModel().setValue("biztype", (Object)bizTypeId);
            DynamicObjectCollection defaultRfiConfigContents = null;
            DynamicObjectCollection sortRfiConfigContents = new ArrayList();
            if (rfiConfigContents.isEmpty()) {
                defaultRfiConfigContents = QueryServiceHelper.query((String)"pbd_rficontent", (String)"id,name,seqnumber", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C"))}, (String)"seqnumber");
                try {
                    sortRfiConfigContents = defaultRfiConfigContents.stream().sorted((x, y) -> Integer.parseInt(x.getString("seqnumber")) - Integer.parseInt(y.getString("seqnumber"))).collect(Collectors.toList());
                }
                catch (Exception numberFormatException) {
                    logger.error("\u6392\u5e8f\u5931\u8d25\uff1a" + numberFormatException.getMessage());
                    sortRfiConfigContents = defaultRfiConfigContents;
                }
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int i = 0;
            if (!rfiConfigContents.isEmpty()) {
                for (DynamicObject data : rfiConfigContents) {
                    vs.set("rficontent_id", data.get("entryentity.rficontent"), i);
                    vs.set("required", (Object)data.getBoolean("entryentity.required"), i);
                    vs.set("rfidesc", (Object)data.getString("entryentity.rfidesc"), i);
                    ++i;
                }
            } else if (!sortRfiConfigContents.isEmpty()) {
                for (DynamicObject data : sortRfiConfigContents) {
                    vs.set("rficontent_id", (Object)data.getLong("id"), i);
                    vs.set("required", (Object)Boolean.FALSE, i);
                    ++i;
                }
            }
            model.batchCreateNewEntryRow("entryentity", vs);
            this.getView().updateView("biztype");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    private void setRfiEntry() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (entryentity != null && entryentity.isEmpty()) {
            DynamicObjectCollection defaultRfiConfigContents = null;
            DynamicObjectCollection sortRfiConfigContents = new ArrayList();
            defaultRfiConfigContents = QueryServiceHelper.query((String)"pbd_rficontent", (String)"id,name,seqnumber", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C"))}, (String)"seqnumber");
            try {
                sortRfiConfigContents = defaultRfiConfigContents.stream().sorted((x, y) -> Integer.parseInt(x.getString("seqnumber")) - Integer.parseInt(y.getString("seqnumber"))).collect(Collectors.toList());
            }
            catch (Exception numberFormatException) {
                logger.error("\u6392\u5e8f\u5931\u8d25\uff1a" + numberFormatException.getMessage());
                sortRfiConfigContents = defaultRfiConfigContents;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int i = 0;
            for (DynamicObject data : sortRfiConfigContents) {
                vs.set("rficontent_id", (Object)data.getLong("id"), i);
                vs.set("required", (Object)Boolean.FALSE, i);
                ++i;
            }
            model.batchCreateNewEntryRow("entryentity", vs);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            try {
                entryentity.sort((x, y) -> Integer.parseInt(x.getDynamicObject("rficontent").getString("seqnumber")) - Integer.parseInt(y.getDynamicObject("rficontent").getString("seqnumber")));
            }
            catch (Exception numberFormatException) {
                logger.error("\u6309seqnumber\u6392\u5e8f\u5931\u8d25\uff1a" + numberFormatException.getMessage());
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": 
            case "bar_submit": {
                Object suppliernameobj = this.getModel().getValue("suppliername");
                if (suppliernameobj == null || !StringUtils.isNotBlank((CharSequence)suppliernameobj.toString())) break;
                this.getModel().setValue("suppliername", (Object)suppliernameobj.toString().trim());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "resendemail": {
                    this.resendemail();
                }
            }
        }
    }

    private void resendemail() {
        IFormView view = this.getView();
        DynamicObject issuerfiBill = this.getModel().getDataEntity(true);
        if (issuerfiBill == null) {
            return;
        }
        Map checkMap = SrmIssueRfiUtil.verifyResendEmail((DynamicObject)issuerfiBill);
        if ("false".equals(checkMap.get("succed"))) {
            view.showTipNotification(checkMap.get("message").toString());
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            view.showConfirm(ResManager.loadKDString((String)"\u5c06\u91cd\u65b0\u53d1\u9001\u9080\u7ea6\u90ae\u4ef6\uff0c\u90ae\u4ef6\u6709\u6548\u671f\u4e3a7\u5929\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"SrmIssueRfiEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmResendEmail"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmResendEmail".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObject issuerfiBill = this.getModel().getDataEntity(true);
            if (issuerfiBill != null) {
                String email = issuerfiBill.getString("email");
                boolean hasSrmUser = QueryServiceHelper.exists((String)"srm_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)email)});
                boolean hasSrmSupplierReg = QueryServiceHelper.exists((String)"srm_supplierreg", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)email)});
                if (!hasSrmUser && !hasSrmSupplierReg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u548c\u6ce8\u518c\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u53d1\u90ae\u4ef6\uff0c\u8bf7\u91cd\u65b0\u5bf9\u4f9b\u5e94\u5546\u8fdb\u884c\u6ce8\u518c\u9080\u7ea6\u3002", (String)"SrmIssueRfiEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!hasSrmUser) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u53d1\u90ae\u4ef6\uff0c\u8bf7\u91cd\u65b0\u5bf9\u4f9b\u5e94\u5546\u8fdb\u884c\u6ce8\u518c\u9080\u7ea6\u3002", (String)"SrmIssueRfiEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!hasSrmSupplierReg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u53d1\u90ae\u4ef6\uff0c\u8bf7\u91cd\u65b0\u5bf9\u4f9b\u5e94\u5546\u8fdb\u884c\u6ce8\u518c\u9080\u7ea6\u3002", (String)"SrmIssueRfiEdit_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.confirmResendEmail();
            this.getView().updateView();
            IFormView Aview = this.getView().getParentView();
            Aview.invokeOperation("refresh");
            this.getView().sendFormAction(Aview);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u53d1\u6210\u529f\u3002", (String)"SrmIssueRfiEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }

    private void confirmResendEmail() {
        DynamicObject issuerfiBill = this.getModel().getDataEntity(true);
        issuerfiBill.set("mailvalidity", (Object)DateUtil.addDays((Date)DateUtil.formatEndDate((Date)TimeServiceHelper.now()), (int)7));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{issuerfiBill});
        String suppliername = issuerfiBill.getString("suppliername");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"adm_supplierreg", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)suppliername)});
        if (Objects.isNull(dynamicObject)) {
            logger.info("\u6839\u636e\u4f9b\u5e94\u5546\u540d\u79f0\u67e5\u8be2\u4f9b\u5e94\u5546id\u4e3a\u7a7a" + suppliername);
            return;
        }
        Long id = dynamicObject.getLong("id");
        SrmSendEmailUtil.sendEmail((DynamicObject[])new DynamicObject[]{issuerfiBill}, (Object)id);
    }
}

