/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SrmQuestionPkResultEdit
extends AbstractBillPlugIn {
    private static final String TAB_ENTRY_END = "_entry";
    private static final String HEADER_SRM = "srm_";

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        List items = tab.getItems();
        for (Control item : items) {
            String id = item.getKey();
            if (!id.endsWith(TAB_ENTRY_END)) {
                this.setHeadVisibleAndData(id);
                continue;
            }
            this.setEntryVisibleAndData(id);
        }
    }

    private void setEntryVisibleAndData(String tabId) {
        String id = tabId.replace(TAB_ENTRY_END, "");
        HashMap<String, List<String>> entryFields = this.getEntryFields(id);
        if (entryFields.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{tabId});
        } else {
            this.setEntryVisible(tabId, entryFields);
            this.setEntryData(tabId, entryFields);
        }
    }

    private void setEntryData(String tabId, HashMap<String, List<String>> entryFields) {
        DynamicObjectCollection questionDatas = this.queryQuestionData();
        if (CollectionUtils.isEmpty((Collection)questionDatas)) {
            return;
        }
        HashMap<String, String> idMapSupName = this.getIdMapSupName(questionDatas);
        ArrayList selectLists = new ArrayList(12);
        entryFields.forEach((k, y) -> {
            for (String s : y) {
                selectLists.add(k + "." + s);
            }
        });
        String selects = ((Object)selectLists).toString().replace("[", "").replace("]", "");
        String comEntity = tabId.replace(TAB_ENTRY_END, "");
        DynamicObject[] components = BusinessDataServiceHelper.load((String)comEntity, (String)(selects + ",parentid"), (QFilter[])new QFilter[]{new QFilter("parentid", "in", idMapSupName.keySet())});
        Set<Map.Entry<String, List<String>>> entries = entryFields.entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            String entryKey = entry.getKey();
            List<String> selectValue = entry.getValue();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            int i = 0;
            for (DynamicObject component : components) {
                String parentid = component.getString("parentid");
                String supName = "";
                if (!StringUtils.isEmpty((Object)parentid)) {
                    supName = idMapSupName.get(parentid);
                }
                DynamicObjectCollection dynamicObjectCollection = component.getDynamicObjectCollection(entryKey);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    for (String select : selectValue) {
                        Object o = dynamicObject.get(select);
                        if (o instanceof DynamicObject) {
                            DynamicObject oDy = (DynamicObject)o;
                            tableValueSetter.set(select, oDy.get("id"), i);
                            continue;
                        }
                        tableValueSetter.set(select, o, i);
                    }
                    if (!StringUtils.isEmpty((Object)supName)) {
                        tableValueSetter.set(entryKey + "_name", (Object)supName, i);
                    }
                    ++i;
                }
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.deleteEntryData(entryKey);
            model.batchCreateNewEntryRow(entryKey, tableValueSetter);
            model.endInit();
        }
    }

    private void setEntryVisible(String tabId, HashMap<String, List<String>> entryFields) {
        TabPage tab = (TabPage)this.getControl(tabId);
        List items = tab.getItems();
        Set<String> keySet = entryFields.keySet();
        for (Control item : items) {
            String key = item.getKey();
            if (!keySet.contains(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{key});
                continue;
            }
            if (!(item instanceof EntryGrid)) continue;
            List<String> list = entryFields.get(key);
            EntryGrid control1 = (EntryGrid)item;
            List items1 = control1.getItems();
            for (Control control : items1) {
                if (list.contains(control.getKey()) || control.getKey().contains("name")) continue;
                control1.setColumnProperty(control.getKey(), "visible", (Object)Boolean.FALSE);
            }
        }
    }

    private void setHeadVisibleAndData(String tabId) {
        ArrayList<String> headerFields = this.getHeaderFields(tabId);
        if (headerFields.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{tabId});
        } else {
            this.setHeadeVisible(headerFields, tabId);
            this.setHeadeEntryData(headerFields, tabId);
        }
    }

    private void setHeadeVisible(ArrayList<String> headerFields, String tabId) {
        String headeEntryIdByTabId = this.getHeadeEntryIdByTabId(tabId);
        if (StringUtils.isEmpty((Object)headeEntryIdByTabId)) {
            return;
        }
        Control control = this.getControl(headeEntryIdByTabId);
        if (Objects.nonNull(control) && control instanceof EntryGrid) {
            EntryGrid control1 = (EntryGrid)control;
            List items = control1.getItems();
            for (Control item : items) {
                String key = item.getKey();
                Boolean isshow = Boolean.FALSE;
                for (String headerField : headerFields) {
                    if (!key.contains(headerField) && !key.contains("name")) continue;
                    isshow = Boolean.TRUE;
                }
                if (isshow.booleanValue()) continue;
                control1.setColumnProperty(key, "visible", (Object)Boolean.FALSE);
            }
        }
    }

    private void setHeadeEntryData(ArrayList<String> headerFields, String entity) {
        DynamicObjectCollection questioncomp = this.queryQuestionData();
        if (CollectionUtils.isEmpty((Collection)questioncomp)) {
            return;
        }
        String headeEntryIdByTabId = this.getHeadeEntryIdByTabId(entity);
        if (StringUtils.isEmpty((Object)headeEntryIdByTabId)) {
            return;
        }
        HashMap<String, String> idMapSupName = this.getIdMapSupName(questioncomp);
        try {
            MainEntityType mainType;
            DynamicProperty property;
            DynamicObjectCollection compData = QueryServiceHelper.query((String)entity, (String)(this.listToSelectString(headerFields) + ",parentid"), (QFilter[])new QFilter[]{new QFilter("parentid", "in", idMapSupName.keySet())});
            if (!CollectionUtils.isEmpty((Collection)compData) && (property = (mainType = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId())).getProperty(headeEntryIdByTabId)) instanceof EntryProp) {
                DataEntityPropertyCollection properties = ((EntryProp)property)._collectionItemPropertyType.getProperties();
                List propertiesNames = properties.stream().map(x -> x.getName()).collect(Collectors.toList());
                TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
                int index = 0;
                for (DynamicObject compDatum : compData) {
                    Object parentid = compDatum.get("parentid");
                    if (Objects.nonNull(parentid)) {
                        String supName = idMapSupName.get(parentid.toString());
                        tableValueSetter.set(headeEntryIdByTabId + "_name", (Object)supName, index);
                    }
                    for (String headerField : headerFields) {
                        Object o = compDatum.get(headerField);
                        for (String propertiesName : propertiesNames) {
                            if (!propertiesName.contains(headerField)) continue;
                            tableValueSetter.set(propertiesName, o, index);
                        }
                    }
                    ++index;
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.deleteEntryData(headeEntryIdByTabId);
                model.batchCreateNewEntryRow(headeEntryIdByTabId, tableValueSetter);
                model.endInit();
            }
        }
        catch (Exception e) {
            BizLog.log((String)("SrmQuestionPkResultEdit_0\uff1a" + e.getMessage()));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6784\u5efa\u5bf9\u6bd4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SrmQuestionPkResultEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }

    private HashMap<String, String> getIdMapSupName(DynamicObjectCollection questioncomp) {
        HashMap<String, String> idMapSupName = new HashMap<String, String>(12);
        for (DynamicObject dynamicObject : questioncomp) {
            String id = dynamicObject.getString("id");
            String supName = dynamicObject.getString("supplier.name");
            idMapSupName.put(id, supName);
        }
        return idMapSupName;
    }

    private DynamicObjectCollection queryQuestionData() {
        Object supids = this.getCustomParmsByKey("supIds");
        Object quetionId = this.getCustomParmsByKey("quetionId");
        if (Objects.isNull(quetionId)) {
            return null;
        }
        QFilter qFilter = new QFilter("srcsupquestionid", "=", (Object)quetionId.toString());
        qFilter.and(new QFilter("supplier.id", "in", supids));
        DynamicObjectCollection questioncomp = QueryServiceHelper.query((String)"srm_questioncomp", (String)"id,supplier.name", (QFilter[])new QFilter[]{qFilter});
        return questioncomp;
    }

    private String getHeadeEntryIdByTabId(String tabId) {
        String[] split = tabId.split(HEADER_SRM);
        if (split.length == 2) {
            return split[1];
        }
        return null;
    }

    private String listToSelectString(ArrayList<String> headerFields) {
        String s = headerFields.toString();
        String replace = s.replace("[", "").replace("]", "");
        return replace;
    }

    private ArrayList<String> getHeaderFields(String key) {
        Object customParms = this.getCustomParmsByKey(key);
        ArrayList<String> headfields = new ArrayList<String>(12);
        if (Objects.nonNull(customParms) && customParms instanceof JSONArray) {
            JSONArray numbers = (JSONArray)customParms;
            for (Object number : numbers) {
                String s = number.toString();
                if (s.contains(".")) continue;
                headfields.add(s);
            }
        }
        return headfields;
    }

    private HashMap<String, List<String>> getEntryFields(String tabKey) {
        HashMap<String, List<String>> entryFields = new HashMap<String, List<String>>(12);
        Object customParms = this.getCustomParmsByKey(tabKey);
        if (Objects.nonNull(customParms) && customParms instanceof JSONArray) {
            JSONArray customArrays = (JSONArray)customParms;
            for (Object custom : customArrays) {
                String[] split;
                String s = custom.toString();
                if (!s.contains(".") || (split = s.split("\\.")).length != 2) continue;
                String entryName = split[0];
                String entryFieldName = split[1];
                if (!entryFields.containsKey(entryName)) {
                    ArrayList<String> entryField = new ArrayList<String>(12);
                    entryField.add(entryFieldName);
                    entryFields.put(entryName, entryField);
                    continue;
                }
                entryFields.get(entryName).add(entryFieldName);
            }
        }
        return entryFields;
    }

    private Object getCustomParmsByKey(String key) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (Objects.isNull(customParams)) {
            return null;
        }
        Object o = customParams.get(key);
        return o;
    }
}

