/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.SrmRecruitStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;

public class SrmRecruitEndPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (((AbstractOperate)args.getSource()).getOperateKey().equals("confirm")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8fdb\u884c\u62db\u52df\u7ed3\u675f\u5904\u7406\uff1f", (String)"SrmRecruitEndPlugin_0", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callbackid"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("callbackid".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirm();
        }
    }

    private void confirm() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject recruitBill = this.getSrmRecruitBillForSave();
        if (recruitBill == null) {
            return;
        }
        String bizStatus = recruitBill.getString("bizstatus");
        Object result = model.getValue("result");
        if (result != null && result.toString().equals(SrmRecruitStatusEnum.ENDED.getValue())) {
            if (bizStatus.equals(SrmRecruitStatusEnum.ENDED.getValue())) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\uff0c\u65e0\u9700\u7ec8\u6b62\u3002", (String)"SrmRecruitEndPlugin_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                return;
            }
            recruitBill.set("bizstatus", (Object)SrmRecruitStatusEnum.ENDED);
        } else if (result != null && result.toString().equals(SrmRecruitStatusEnum.COMPLETED.getValue())) {
            recruitBill.set("bizstatus", (Object)SrmRecruitStatusEnum.COMPLETED);
        }
        Date currDate = TimeServiceHelper.now();
        recruitBill.set("cfmopinion", model.getValue("suggestion"));
        recruitBill.set("cfm", (Object)RequestContext.get().getUserId());
        recruitBill.set("cfmdate", (Object)currDate);
        SaveServiceHelper.save((IDataEntityType)recruitBill.getDynamicObjectType(), (Object[])new Object[]{recruitBill});
        view.close();
    }

    private DynamicObject getSrmRecruitBillForSave() {
        Map<String, Map<String, Object>> params = this.getParams();
        String selectFields = DynamicObjectUtil.getSelectfields((String)"srm_recruit", (boolean)false);
        DynamicObject[] objs = ORMUtil.load((String)"srm_recruit", (String)selectFields, params);
        return objs.length == 0 ? null : objs[0];
    }

    private Map<String, Map<String, Object>> getParams() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("billid");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.parseLong(bidBillIdObj.toString()));
        params.put("id", idMap);
        return params;
    }
}

