/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;

public class SrmSchemeEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setGradeMust();
    }

    public void afterCreateNewData(EventObject e) {
        SrmCommonUtil.setOrgDefaultValue((IDataModel)this.getModel());
    }

    public void afterLoadData(EventObject e) {
        this.setScore();
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        switch (propertyName = arg0.getProperty().getName()) {
            case "isorg": {
                MulBasedataEdit orgscope = (MulBasedataEdit)this.getView().getControl("orgscope");
                if (this.getModel().getDataEntity().getBoolean("isorg")) {
                    orgscope.setMustInput(true);
                    break;
                }
                orgscope.setMustInput(false);
                this.getModel().setValue("orgscope", null);
                break;
            }
            case "iscategory": {
                MulBasedataEdit categoryscope = (MulBasedataEdit)this.getView().getControl("categoryscope");
                if (this.getModel().getDataEntity().getBoolean("iscategory")) {
                    categoryscope.setMustInput(true);
                    break;
                }
                categoryscope.setMustInput(false);
                this.getModel().setValue("categoryscope", null);
                break;
            }
            case "evatype": {
                this.getModel().setValue("grade", null);
                this.getModel().setValue("score", null);
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().deleteEntryData("entry_scorer");
                this.getModel().createNewEntryRow("entry_scorer");
                break;
            }
            case "isscorer": {
                if (!this.getModel().getDataEntity().getBoolean("isscorer")) {
                    this.getModel().deleteEntryData("entry_scorer");
                    break;
                }
                this.getModel().insertEntryRow("entry_scorer", 0);
                break;
            }
            case "istypescorer": {
                this.getModel().deleteEntryData("entry_scorer");
                this.getModel().insertEntryRow("entry_scorer", 0);
                break;
            }
            case "index": {
                DynamicObject newObject = (DynamicObject)arg0.getChangeSet()[0].getNewValue();
                if (newObject == null) {
                    return;
                }
                DynamicObjectCollection oldRows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                if (oldRows == null || oldRows.size() == 0) {
                    return;
                }
                int count = 0;
                int currentRow = arg0.getChangeSet()[0].getRowIndex();
                this.getModel().setValue("weight", null, currentRow);
                DynamicObject oldObject = null;
                for (DynamicObject obj : oldRows) {
                    oldObject = obj.getDynamicObject("index");
                    if (oldObject != null && oldObject.getPkValue().equals(newObject.getPkValue())) {
                        ++count;
                    }
                    if (count != 2) continue;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f55\u5165\u76f8\u540c\u7684 \u8bc4\u4f30\u6307\u6807\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SrmSchemeEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                    this.getModel().setValue("index", null, currentRow);
                    return;
                }
                this.setScore();
                break;
            }
            case "weight": {
                this.setScore();
                break;
            }
            case "synsupgrade": {
                this.setGradeMust();
                break;
            }
            case "groupscheme": {
                Object newValue = arg0.getChangeSet()[0].getNewValue();
                if (newValue == null || !"true".equals(newValue.toString())) break;
                this.getModel().setValue("isorg", (Object)false);
                this.getModel().setValue("orgscope", null);
                break;
            }
        }
    }

    private void setGradeMust() {
        BasedataEdit grade = (BasedataEdit)this.getControl("grade");
        if (this.getModel().getDataEntity().getBoolean("synsupgrade")) {
            grade.setMustInput(Boolean.TRUE.booleanValue());
        } else {
            grade.setMustInput(Boolean.FALSE.booleanValue());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            this.setScore();
            return;
        }
    }

    private void setScore() {
        DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            this.getModel().setValue("score", null);
            return;
        }
        BigDecimal sumScore = BigDecimal.ZERO;
        for (DynamicObject row : rows) {
            if (row.getDynamicObject("index") == null) continue;
            boolean isdeduct = row.getBoolean("index.isdeduct");
            BigDecimal score = row.getBigDecimal("index.score");
            BigDecimal weight = row.getBigDecimal("weight");
            if (weight.compareTo(BigDecimal.ZERO) > 0) {
                score = score.multiply(weight).divide(BigDecimal.TEN).divide(BigDecimal.TEN);
            }
            if (isdeduct) {
                score = score.negate();
            }
            sumScore = sumScore.add(score);
        }
        this.getModel().setValue("score", (Object)sumScore);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit index = (BasedataEdit)this.getView().getControl("index");
        index.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit indexClass = (BasedataEdit)this.getView().getControl("indexclass");
        indexClass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgscope = (BasedataEdit)this.getView().getControl("orgscope");
        orgscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scorer = (BasedataEdit)this.getView().getControl("scorer");
        scorer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter;
        Map resultMap;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        int row = beforeF7SelectEvent.getRow();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"index")) {
            resultMap = SrmBillEditUtil.getIndexFilter((IDataModel)this.getModel());
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                beforeF7SelectEvent.setCancel(true);
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"indexclass")) {
            resultMap = SrmBillEditUtil.getIndexClassFilter((IDataModel)this.getModel());
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                beforeF7SelectEvent.setCancel(true);
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"scorer")) {
            DynamicObjectCollection entryScorer = this.getModel().getEntryEntity("entry_scorer");
            DynamicObject indexClass = ((DynamicObject)entryScorer.get(row)).getDynamicObject("indexclass");
            if (indexClass != null) {
                DynamicObject scorer = ((DynamicObject)entryScorer.get(row)).getDynamicObject("scorer");
                if (scorer != null) {
                    ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setMultiSelect(false);
                }
                beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scorer"));
            } else {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6307\u6807\u5206\u7c7b\u3002", (String)"SrmSchemeEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"orgscope")) {
            List allPurPermssionOrgs = OrgUtil.getAllPermssionOrgs((String)"srm_scheme");
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allPurPermssionOrgs));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "scorer": {
                if (returnData == null) break;
                ListSelectedRowCollection supplierRows = (ListSelectedRowCollection)returnData;
                this.setScorer(supplierRows.getPrimaryKeyValues());
                break;
            }
        }
    }

    protected void setScorer(Object[] scorerPks) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entry_scorer");
        DynamicObject indexClass = ((DynamicObject)this.getModel().getEntryEntity("entry_scorer").get(currentRowIndex)).getDynamicObject("indexclass");
        IDataEntityProperty dataEntityProperty = this.getModel().getProperty("entry_scorer");
        int rowIndex = currentRowIndex;
        for (Object scorer : scorerPks) {
            if (rowIndex > currentRowIndex) {
                int insertIndex = ((BillModel)this.getModel()).insertEntryRow(dataEntityProperty.getName(), rowIndex);
                this.getModel().setValue("indexclass", (Object)indexClass, insertIndex);
                this.getModel().setValue("scorer", scorer, insertIndex);
            } else {
                this.getModel().setValue("scorer", scorer, currentRowIndex);
            }
            ++rowIndex;
        }
    }
}

