/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.OpenFormUtil;

public class SrmScoreEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        long billId = (Long)this.getModel().getDataEntity().getPkValue();
        String bizStatus = this.getModel().getDataEntity().getString("bizstatus");
        switch (key) {
            case "bar_terminate": {
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                if (!bizStatus.equals(SrmScoreStatusEnum.APPROVED.getValue()) && !bizStatus.equals(SrmScoreStatusEnum.UNAPPROVED.getValue()) && !bizStatus.equals(SrmScoreStatusEnum.ENDED.getValue())) break;
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6838\u51c6\u6216\u5df2\u7ec8\u6b62\u7684\u8bc4\u4f30\u4efb\u52a1\u4e0d\u5141\u8bb8\u7ec8\u6b62\u3002", (String)"SrmScoreEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entry");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        this.setSubEntryFieldsVisible();
    }

    private void setSubEntryFieldsVisible() {
        DynamicObjectCollection subentry = this.getModel().getEntryEntity("subentry");
        if (subentry == null) {
            return;
        }
        DynamicObject parent = (DynamicObject)subentry.getParent();
        String indexProperty = parent.getString("index.property");
        boolean allScored = true;
        for (DynamicObject subEntryRow : subentry) {
            Boolean scorerscored = subEntryRow.getBoolean("scorerscored");
            if (!Boolean.FALSE.equals(scorerscored)) continue;
            allScored = false;
            break;
        }
        if (indexProperty.equals("3")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"value"});
            this.getView().setVisible(Boolean.valueOf(allScored), new String[]{"accordance", "score", "scorerscore"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"accordance"});
            this.getView().setVisible(Boolean.valueOf(allScored), new String[]{"value", "score", "scorerscore"});
        }
        this.getView().updateView("subentry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        long billId = (Long)this.getModel().getDataEntity().getPkValue();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "terminate": {
                    MutexHelper.require((String)"srm_score", (Object)billId, (String)"terminate", (boolean)true, (StringBuilder)new StringBuilder(16));
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_scoreend", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        long billId = (Long)this.getModel().getDataEntity().getPkValue();
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            this.getView().invokeOperation("refresh");
            BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
            MutexHelper.release((String)"srm_score", (String)"terminate", (String)String.valueOf(billId));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
    }

    protected String getStatusTabValue() {
        DynamicObject obj = this.getModel().getDataEntity();
        String bizStatus = obj.getString("bizstatus");
        return bizStatus == null ? "" : bizStatus.toLowerCase();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entry");
        for (DynamicObject dynamicObject : entry) {
            DynamicObjectCollection subentrys = dynamicObject.getDynamicObjectCollection("subentry");
            for (DynamicObject subentry : subentrys) {
                BigDecimal value = subentry.getBigDecimal("value");
                if (!Objects.nonNull(value) || value.compareTo(new BigDecimal(-1)) != 0) continue;
                subentry.set("value", null);
            }
        }
        List autoIndex = entry.stream().filter(x -> "9".equals(x.getString("index.scoretype"))).collect(Collectors.toList());
        String bizstatus = this.getModel().getDataEntity().getString("bizstatus");
        if (!CollectionUtils.isEmpty(autoIndex) && ("B".equals(bizstatus) || "C".equals(bizstatus))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"reautoscore"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reautoscore"});
        }
        this.setSubEntryFieldsVisible();
    }
}

