/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.PurWorkFlowUtils;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.service.valid.SrmScoreRptListServiceValid;

public class SrmScorerptEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
TabSelectListener {
    private static final String INDEXCLASSENTRY = "indexclassentry";
    private static final String INDEXTYPEENTRY = "indextypeentry";
    private static final String INDEX_INDEXTYPE = "index.indextype";
    private static final String INDEX_INDEXCLASS = "index.indexclass";
    private static final String IDX_INDEXTYPE = "idxtype_detail";
    private static final String INDEXCLASS_SUMSCORE = "indexclass_sumscore";
    private static final String INDEXTYPE_SUMSCORE = "indextype_sumscore";
    private SrmScoreRptListServiceValid serviceValid;

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Object object = this.getModel().getDataEntity().getPkValue();
        if (object instanceof Long) {
            DynamicObject detailData = this.getData((Long)object);
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryCollection = detailData.getDynamicObjectCollection("entry");
            DynamicObjectCollection subCollection = null;
            DynamicObject rowDynamicObj = null;
            for (DynamicObject dynamicObject : entryCollection) {
                subCollection = dynamicObject.getDynamicObjectCollection("subentry");
                for (DynamicObject subEntry : subCollection) {
                    boolean abstain = subEntry.getBoolean("abstain");
                    if (abstain) continue;
                    rowDynamicObj = collection.addNew();
                    rowDynamicObj.set("index", dynamicObject.get("index"));
                    rowDynamicObj.set("sysscore", dynamicObject.get("sysscore"));
                    rowDynamicObj.set("weight", dynamicObject.get("indexweight"));
                    BigDecimal scorerScore = subEntry.getBigDecimal("score").multiply(dynamicObject.getBigDecimal("indexweight")).multiply(subEntry.getBigDecimal("scorerweight")).divide(BigDecimal.TEN.multiply(BigDecimal.TEN)).divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
                    DynamicObject index = dynamicObject.getDynamicObject("index");
                    Boolean isdeduct = index.getBoolean("isdeduct");
                    if (isdeduct.booleanValue()) {
                        scorerScore = scorerScore.negate();
                    }
                    rowDynamicObj.set("finalscore", (Object)scorerScore);
                    rowDynamicObj.set("veto", subEntry.get("scorerveto"));
                    rowDynamicObj.set("scorer", subEntry.get("scorer"));
                    rowDynamicObj.set("scorerweight", subEntry.get("scorerweight"));
                    rowDynamicObj.set("value", subEntry.get("value"));
                    BigDecimal scorerscore = subEntry.getBigDecimal("scorerscore");
                    if (isdeduct.booleanValue()) {
                        scorerscore = scorerscore.negate();
                    }
                    rowDynamicObj.set("scorerscore", (Object)scorerscore);
                    rowDynamicObj.set("note", subEntry.get("note"));
                    rowDynamicObj.set("scoreattachment", (Object)subEntry.getDynamicObjectCollection("scoreattachment"));
                }
            }
        }
        this.bulidIndexClassEntry("indexclass_detail", "indexclass_finalscore");
        this.bulidIndexTypeEntry();
        this.sortIndexClassEntry();
    }

    private void sortIndexClassEntry() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXCLASSENTRY);
        dynamicObjectCollection.sort((x, y) -> x.getString("idxtype_detail.number").compareTo(y.getString("idxtype_detail.number")));
    }

    private void bulidIndexClassEntry(String detailId, String finalscoreId) {
        DynamicObjectCollection indexCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indexClassCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXCLASSENTRY);
        Map<DynamicObject, List<DynamicObject>> groupByIndexClass = indexCollection.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject(INDEX_INDEXCLASS)));
        if (Objects.isNull(groupByIndexClass)) {
            return;
        }
        Set<DynamicObject> classDy = groupByIndexClass.keySet();
        Set clssIds = classDy.stream().map(x -> x.getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection classDb = QueryServiceHelper.query((String)"srm_indexclass", (String)"id,lowestscore", (QFilter[])new QFilter[]{new QFilter("id", "in", clssIds)});
        if (CollectionUtils.isEmpty((Collection)classDb)) {
            return;
        }
        Set<Map.Entry<DynamicObject, List<DynamicObject>>> entries = groupByIndexClass.entrySet();
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : entries) {
            DynamicObject dynamicObject = indexClassCollection.addNew();
            DynamicObject classDyKey = entry.getKey();
            dynamicObject.set(detailId, (Object)classDyKey);
            List<DynamicObject> entryentityValue = entry.getValue();
            BigDecimal sunValue = new BigDecimal(0);
            BigDecimal finalValue = new BigDecimal(0);
            Boolean isclassTypeVeto = false;
            for (DynamicObject value : entryentityValue) {
                BigDecimal finaScore = value.getBigDecimal("finalscore");
                String veto = value.getString("veto");
                sunValue = sunValue.add(finaScore);
                if (!"2".equals(veto)) continue;
                isclassTypeVeto = true;
            }
            Boolean isLowestscore = false;
            for (DynamicObject classDbType : classDb) {
                String lowestscore;
                if (!classDyKey.getPkValue().equals(classDbType.get("id")) || StringUtils.isEmpty((String)(lowestscore = classDbType.getString("lowestscore"))) || !"2".equals(lowestscore)) continue;
                isLowestscore = true;
            }
            finalValue = isclassTypeVeto != false ? new BigDecimal(0) : (sunValue.compareTo(new BigDecimal(0)) < 0 && isLowestscore != false ? new BigDecimal(0) : sunValue);
            dynamicObject.set(finalscoreId, (Object)sunValue);
            dynamicObject.set(INDEXCLASS_SUMSCORE, (Object)finalValue);
            dynamicObject.set(IDX_INDEXTYPE, (Object)entryentityValue.get(0).getDynamicObject(INDEX_INDEXTYPE));
        }
    }

    private void bulidIndexTypeEntry() {
        DynamicObjectCollection indexCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indexTypeCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXTYPEENTRY);
        DynamicObjectCollection indexClassCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXCLASSENTRY);
        Map<DynamicObject, List<DynamicObject>> indexClolleGroupByIndexType = indexCollection.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject(INDEX_INDEXTYPE)));
        if (Objects.isNull(indexClolleGroupByIndexType)) {
            return;
        }
        Set<DynamicObject> classDy = indexClolleGroupByIndexType.keySet();
        Set clssIds = classDy.stream().map(x -> x.getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection classDb = QueryServiceHelper.query((String)"srm_indexclass", (String)"id,lowestscore", (QFilter[])new QFilter[]{new QFilter("id", "in", clssIds)});
        if (CollectionUtils.isEmpty((Collection)classDb)) {
            return;
        }
        Map<Object, List<DynamicObject>> classTypeMap = classDb.stream().collect(Collectors.groupingBy(x -> x.get("id")));
        if (CollectionUtils.isEmpty((Collection)indexClassCollection) || CollectionUtils.isEmpty(classTypeMap)) {
            return;
        }
        Map<DynamicObject, List<DynamicObject>> indexClassMapType = indexClassCollection.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject(IDX_INDEXTYPE)));
        Set<Map.Entry<DynamicObject, List<DynamicObject>>> entries = indexClassMapType.entrySet();
        List vetos = indexCollection.stream().filter(x -> "4".equals(x.getString("veto"))).collect(Collectors.toList());
        Boolean isVeto = false;
        if (!CollectionUtils.isEmpty(vetos)) {
            isVeto = true;
        }
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : entries) {
            String lowestscore;
            DynamicObject dynamicObject = indexTypeCollection.addNew();
            DynamicObject indexType = entry.getKey();
            List<DynamicObject> indexClassList = entry.getValue();
            BigDecimal sunValue = new BigDecimal(0);
            BigDecimal sunClassValue = new BigDecimal(0);
            BigDecimal finalValue = new BigDecimal(0);
            Boolean isclassTypeVeto = false;
            Boolean isLowestscore = false;
            List<DynamicObject> indexCollectionsGroup = indexClolleGroupByIndexType.get(indexType);
            for (DynamicObject index : indexCollectionsGroup) {
                String veto = index.getString("veto");
                if (!"1".equals(veto)) continue;
                isclassTypeVeto = true;
            }
            for (DynamicObject indexClass : indexClassList) {
                sunValue = sunValue.add(indexClass.getBigDecimal("indexclass_finalscore"));
                sunClassValue = sunClassValue.add(indexClass.getBigDecimal(INDEXCLASS_SUMSCORE));
            }
            List<DynamicObject> classType = classTypeMap.get(indexType.getPkValue());
            if (!CollectionUtils.isEmpty(classType) && !StringUtils.isEmpty((String)(lowestscore = classType.get(0).getString("lowestscore"))) && "2".equals(lowestscore)) {
                isLowestscore = true;
            }
            finalValue = isclassTypeVeto != false || isVeto != false ? new BigDecimal(0) : (sunClassValue.compareTo(new BigDecimal(0)) < 0 && isLowestscore != false ? new BigDecimal(0) : sunClassValue);
            dynamicObject.set("indextype_finalscore", (Object)sunValue);
            dynamicObject.set("indextype_detail", (Object)indexType);
            dynamicObject.set(INDEXTYPE_SUMSCORE, (Object)finalValue);
        }
    }

    private DynamicObject getData(Long billPkId) {
        return BusinessDataServiceHelper.loadSingle((Object)billPkId, (String)"srm_score");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_review": {
                this.review(evt);
                break;
            }
            case "bar_approve": {
                this.approve(evt);
                break;
            }
            case "bardirectapprove": {
                this.directapprove(evt);
                break;
            }
        }
    }

    private void directapprove(BeforeItemClickEvent evt) {
        evt.setCancel(true);
        Object[] billIds = new Object[]{this.getModel().getDataEntity().getPkValue()};
        SrmScoreRptListServiceValid serviceValid = this.getServiceValid();
        StringBuilder message = serviceValid.valid(billIds, "directapprove");
        if (message.length() > 0) {
            this.getView().showMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5185\u5bb9\u4e0d\u7b26\u5408\u6838\u51c6\u8981\u6c42\uff0c\u8bf7\u91cd\u9009\u3002", (String)"SrmScorerptEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmScorerptList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
            return;
        }
        evt.setCancel(false);
    }

    protected SrmScoreRptListServiceValid getServiceValid() {
        if (Objects.isNull(this.serviceValid)) {
            this.serviceValid = new SrmScoreRptListServiceValid();
            return this.serviceValid;
        }
        return this.serviceValid;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("approve") || actionId.equals("review") || actionId.equals("directapprove")) {
            String billId = this.getModel().getDataEntity().getPkValue().toString();
            MutexHelper.release((String)"srm_scorerpt", (String)actionId, (String)billId);
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                OperateOption option;
                if ("review".equals(actionId)) {
                    option = OperateOption.create();
                    OperationServiceHelper.executeOperate((String)"sendmsg", (String)"srm_scorerpt", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)option);
                }
                if ("approve".equals(actionId)) {
                    option = OperateOption.create();
                    OperationServiceHelper.executeOperate((String)"sendapprovemsg", (String)"srm_scorerpt", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)option);
                }
                if ("directapprove".equals(actionId) && Objects.nonNull(returnData)) {
                    String result = ((HashMap)returnData).get("result").toString();
                    OperateOption option2 = OperateOption.create();
                    option2.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                    option2.setVariableValue("cfmOption", ((HashMap)returnData).get("cfmOption").toString());
                    if ("agree".equals(result)) {
                        OperationServiceHelper.executeOperate((String)"directapprove_exec", (String)"srm_scorerpt", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)option2.copy());
                    } else {
                        OperationServiceHelper.executeOperate((String)"directreject_exec", (String)"srm_scorerpt", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)option2.copy());
                    }
                }
            }
            this.getView().invokeOperation("refresh");
            SrmCommonUtil.setScoreRptTabStatus((IFormView)this.getView(), (IDataModel)this.getModel());
        }
    }

    private void review(BeforeItemClickEvent evt) {
        evt.setCancel(true);
        DynamicObject obj = this.getModel().getDataEntity();
        if (obj == null) {
            return;
        }
        long billId = (Long)obj.getPkValue();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (billId == 0L || Objects.isNull(dynamicObject)) {
            return;
        }
        if (WorkflowServiceHelper.inProcess((String)obj.getPkValue().toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\uff0c\u4e0d\u80fd\u521d\u5ba1\u3002", (String)"SrmScorerptEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            return;
        }
        String bizStatus = dynamicObject.getString("bizstatus");
        if (bizStatus == null) {
            return;
        }
        if (!bizStatus.equals(SrmScoreStatusEnum.SCORED.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u8bc4\u5206\u7684\u8bc4\u4f30\u62a5\u544a\u624d\u80fd\u8fdb\u884c\u521d\u5ba1\u3002", (String)"SrmScorerptEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        evt.setCancel(false);
    }

    private void approve(BeforeItemClickEvent evt) {
        evt.setCancel(true);
        DynamicObject obj = this.getModel().getDataEntity();
        if (obj == null) {
            return;
        }
        long billId = (Long)obj.getPkValue();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (billId == 0L || Objects.isNull(dynamicObject)) {
            return;
        }
        String bizStatus = dynamicObject.getString("bizstatus");
        if (bizStatus == null) {
            return;
        }
        if (!bizStatus.equals(SrmScoreStatusEnum.TRIALED.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u521d\u5ba1\u901a\u8fc7\u7684\u8bc4\u4f30\u62a5\u544a\u624d\u80fd\u8fdb\u884c\u6838\u51c6\u3002", (String)"SrmScorerptEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        evt.setCancel(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SrmCommonUtil.setScoreRptTabStatus((IFormView)this.getView(), (IDataModel)this.getModel());
        SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
        if (PurWorkFlowUtils.isNoApproval((IFormView)this.getView(), (IDataModel)this.getModel())) {
            splitContainer.hidePanel(SplitDirection.right, true);
        } else {
            splitContainer.hidePanel(SplitDirection.right, false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        long billId = (Long)this.getModel().getDataEntity().getPkValue();
        HashMap<String, String> mp = new HashMap<String, String>();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "review": {
                    DynamicObject evatype = this.getModel().getDataEntity().getDynamicObject("evatype");
                    if (evatype != null) {
                        mp.put("evatype", evatype.getString("id"));
                    }
                    MutexHelper.require((String)"srm_scorerpt", (Object)billId, (String)"review", (boolean)true, (StringBuilder)new StringBuilder(16));
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_review", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, mp, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "review"));
                    break;
                }
                case "approve": {
                    DynamicObject evatype = this.getModel().getDataEntity().getDynamicObject("evatype");
                    if (evatype != null) {
                        mp.put("evatype", evatype.getString("id"));
                    }
                    MutexHelper.require((String)"srm_scorerpt", (Object)billId, (String)"approve", (boolean)true, (StringBuilder)new StringBuilder(16));
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_approve", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, mp, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "approve"));
                    break;
                }
                case "directapprove": {
                    DynamicObject evatype = this.getModel().getDataEntity().getDynamicObject("evatype");
                    if (evatype != null) {
                        mp.put("evatype", evatype.getString("id"));
                    }
                    MutexHelper.require((String)"srm_scorerpt", (Object)billId, (String)"directapprove", (boolean)true, (StringBuilder)new StringBuilder(16));
                    this.openDynamicPage("srm_directapprove", "directapprove");
                    break;
                }
            }
        }
    }

    protected void openDynamicPage(String openPageName, String opId) {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        Object[] primaryKeyValues = new Object[]{this.getModel().getDataEntity().getPkValue()};
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"srm_scorerpt", (String)"evatype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()))});
        if (Objects.nonNull(dyo)) {
            mp.put("evatype", dyo.get("evatype"));
        }
        mp.put("score_Id", primaryKeyValues);
        for (Object primaryKeyValue : primaryKeyValues) {
            MutexHelper.require((String)"srm_scorerpt", (Object)primaryKeyValue, (String)opId, (boolean)true, (StringBuilder)new StringBuilder(16));
        }
        OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)openPageName, (ShowType)ShowType.NonModal, mp, (CloseCallBack)new CloseCallBack((IFormPlugin)this, opId));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("rescore".equals(operateKey) && !WorkflowServiceHelper.inProcess((String)this.getModel().getDataEntity(true).getPkValue().toString())) {
            if (!this.reScore()) {
                args.setCancel(true);
            } else {
                EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = grid.getSelectRows();
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                StringBuilder scorers = new StringBuilder();
                for (int rowIndex : selectRows) {
                    long scorerId = ((DynamicObject)entryentity.get(rowIndex)).getLong("scorer.id");
                    String scoretype = ((DynamicObject)entryentity.get(rowIndex)).getString("index.scoretype");
                    if ("9".equals(scoretype)) continue;
                    if (scorers.length() > 0) {
                        scorers.append(",");
                    }
                    scorers.append(scorerId);
                }
                if (scorers.length() > 0) {
                    HashMap<String, String> param = new HashMap<String, String>(16);
                    Object pkValue = this.getModel().getDataEntity().getPkValue();
                    param.put("businesskey", pkValue.toString());
                    param.put("rptbillid", pkValue.toString());
                    param.put("rptparam", scorers.toString());
                    param.put("taskbillno", this.getModel().getDataEntity().getString("billno"));
                    param.put("taskname", this.getModel().getDataEntity().getString("name"));
                    String json = JacksonJsonUtil.toJSON(param);
                    EventServiceHelper.triggerEventSubscribe((String)"srm_scorerpt_msg_rescore", (String)json);
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private boolean reScore() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            return false;
        }
        HashMap<Long, Set<Long>> scoreAndIndexMap = new HashMap<Long, Set<Long>>(16);
        StringBuilder failIndexStr = new StringBuilder();
        StringBuilder successIndexStr = new StringBuilder();
        for (int rowIndex : selectRows) {
            long indexId = ((DynamicObject)entryentity.get(rowIndex)).getLong("index.id");
            long scorerId = ((DynamicObject)entryentity.get(rowIndex)).getLong("scorer.id");
            String scoretype = ((DynamicObject)entryentity.get(rowIndex)).getString("index.scoretype");
            if ("9".equals(scoretype)) continue;
            boolean isRescore = this.isRescore(indexId, scorerId);
            if (!isRescore) {
                if (failIndexStr.length() > 0) {
                    failIndexStr.append("\u3001");
                }
                failIndexStr.append(rowIndex + 1);
                continue;
            }
            if (successIndexStr.length() > 0) {
                successIndexStr.append("\u3001");
            }
            successIndexStr.append(rowIndex + 1);
            Set scorerIdSet = (Set)scoreAndIndexMap.get(indexId);
            if (scorerIdSet == null) {
                HashSet<Long> idSet = new HashSet<Long>(8);
                idSet.add(scorerId);
                scoreAndIndexMap.put(indexId, idSet);
                continue;
            }
            scorerIdSet.add(scorerId);
            scoreAndIndexMap.put(indexId, scorerIdSet);
        }
        this.clearScore(scoreAndIndexMap);
        StringBuilder successMsg = new StringBuilder();
        if (successIndexStr.length() > 0) {
            successMsg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c%1\u884c\u6307\u6807\u9000\u56de\u91cd\u8bc4\u6210\u529f\u3002", (String)"SrmScorerptEdit_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmScorerptEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[]{successIndexStr}));
        }
        if (failIndexStr.length() > 0) {
            successMsg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c%1\u884c\u6307\u6807\u5df2\u9000\u56de\u7ed9\u5bf9\u5e94\u8bc4\u59d4\u91cd\u65b0\u8bc4\u5206\uff0c\u65e0\u9700\u9000\u56de\u91cd\u8bc4\u3002", (String)"SrmScorerptEdit_5", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmScorerptEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[]{failIndexStr}));
        }
        if (successMsg.length() > 0) {
            if (failIndexStr.length() == 0) {
                this.getView().showSuccessNotification(successMsg.toString(), Integer.valueOf(3000));
            } else {
                this.getView().showTipNotification(successMsg.toString(), Integer.valueOf(3000));
            }
        }
        return successIndexStr.length() > 0;
    }

    private boolean isRescore(long indexId, long scorerId) {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        return QueryServiceHelper.exists((String)"srm_score", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue).and("entry.index", "=", (Object)indexId).and("entry.subentry.scorer", "=", (Object)scorerId).and("entry.subentry.scorerscored", "=", (Object)true)});
    }

    private void clearScore(Map<Long, Set<Long>> scoreAndIndexMap) {
        if (scoreAndIndexMap.size() == 0) {
            return;
        }
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject srm_score = BusinessDataServiceHelper.loadSingle((String)"srm_score", (String)"id,billno,billstatus,lastupdateuser,lastupdatetime,scheme,bizbilltype,finishdate,bizstatus,taskbillid,entry.index,entry.veto,entry.manscore,entry.finalscore,entry.indexscored,subentry.scorer,subentry.value,subentry.score,subentry.scorerscore,subentry.scorerveto,subentry.scorerscored", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        DynamicObjectCollection entry = srm_score.getDynamicObjectCollection("entry");
        srm_score.set("finishdate", null);
        for (Object entryRow : entry) {
            long indexId = entryRow.getLong("index.id");
            if (!scoreAndIndexMap.containsKey(indexId)) continue;
            entryRow.set("manscore", (Object)new BigDecimal(0));
            entryRow.set("finalscore", (Object)new BigDecimal(0));
            entryRow.set("indexscored", (Object)false);
            entryRow.set("veto", (Object)"9");
            Set<Long> scorerIdSet = scoreAndIndexMap.get(indexId);
            DynamicObjectCollection subentry = entryRow.getDynamicObjectCollection("subentry");
            for (DynamicObject subEntryRow : subentry) {
                long scorerId = subEntryRow.getLong("scorer.id");
                if (scorerIdSet == null || !scorerIdSet.contains(scorerId)) continue;
                subEntryRow.set("scorerveto", null);
                subEntryRow.set("scorerscored", (Object)false);
            }
        }
        boolean bizstatusEqB = true;
        block2: for (DynamicObject entryRow : entry) {
            DynamicObjectCollection subentry = entryRow.getDynamicObjectCollection("subentry");
            for (DynamicObject subEntryRow : subentry) {
                boolean scorerscored = subEntryRow.getBoolean("scorerscored");
                if (!scorerscored) continue;
                bizstatusEqB = false;
                continue block2;
            }
        }
        if (bizstatusEqB) {
            srm_score.set("bizstatus", (Object)"B");
        } else {
            srm_score.set("bizstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srm_score});
        long taskbillid = srm_score.getLong("taskbillid");
        DynamicObject srm_evaplan = BusinessDataServiceHelper.loadSingle((String)"srm_evaplan", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        if (srm_evaplan == null) {
            srm_evaplan = BusinessDataServiceHelper.loadSingle((String)"srm_evaplan_batch", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        }
        if (srm_evaplan != null) {
            srm_evaplan.set("bizstatus", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srm_evaplan});
        }
    }

    public void beforeBindData(EventObject e) {
        this.getView().getPageId();
        super.beforeBindData(e);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entry) {
            BigDecimal value = dynamicObject.getBigDecimal("value");
            if (!Objects.nonNull(value) || value.compareTo(new BigDecimal(-1)) != 0) continue;
            dynamicObject.set("value", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addClickListener((ClickListener)this);
        grid.addItemClickListener((ItemClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"rescore"});
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("indextab".equals(tabKey)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_rescore"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_rescore"});
        }
        boolean a = true;
    }
}

