/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.BaseDataViewDetailUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;
import kd.scm.srm.common.SrmCommUtil;
import kd.scm.srm.common.constant.SrmConstant;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;
import kd.scm.srm.service.SrmMultiTimesSupApproveService;
import kd.sdk.scm.srm.extpoint.ISrmAccessNodeService;

public class SrmSupApproveEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && SrmCommonUtil.enableNewAccessFlow()) {
            this.setAccessNodeInfo();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sampleno", "testresult", "tryno", "tryresult", "sceneno"});
        } else {
            SrmBillEditUtil.setScenenoMustinput((IDataModel)this.getModel(), (IFormView)this.getView());
            this.getView().setVisible(Boolean.TRUE, new String[]{"sampleno", "testresult", "tryno", "tryresult"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"pl_nodeaccess"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit aptitudeno = (BasedataEdit)this.getControl("aptitudeno");
        aptitudeno.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"srm_aptitudeexam", (String)"srm_aptitudeexam"));
        });
        BasedataEdit sceneno = (BasedataEdit)this.getControl("sceneno");
        sceneno.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"srm_sceneexam", (String)"srm_sceneexam"));
        });
        sceneno.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit sampleno = (BasedataEdit)this.getControl("sampleno");
        sampleno.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"srm_sampleexam", (String)"srm_sampleexam"));
        });
        BasedataEdit tryno = (BasedataEdit)this.getControl("tryno");
        tryno.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"srm_materialexam", (String)"srm_materialexam"));
        });
        SrmCommUtil.addValidatePreValueBeforeF7Listener((AbstractFormPlugin)this, (String)"supplier", (String)"org");
        SrmCommUtil.addValidatePreValueBeforeF7Listener((AbstractFormPlugin)this, (String)"aptitudeno", (String)"supplier");
        SrmCommUtil.addValidatePreValueBeforeF7Listener((AbstractFormPlugin)this, (String)"sceneno", (String)"aptitudeno");
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        switch (propertyName = arg0.getProperty().getName()) {
            case "org": 
            case "supplier": {
                SrmBillEditUtil.setAptitudeNo((IDataModel)this.getModel(), (String)"isapprove", (String)"hasapprove");
                break;
            }
            case "aptitudeno": {
                AbstractFormDataModel currModel = (AbstractFormDataModel)this.getModel();
                DynamicObjectCollection entryentity = currModel.getDataEntity(true).getDynamicObjectCollection("entryentity");
                if (entryentity != null && !entryentity.isEmpty()) {
                    currModel.deleteEntryData("subentryentity");
                }
                SrmBillEditUtil.setCategory((AbstractFormDataModel)currModel);
                boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
                if (enableNewAccessFlow) {
                    this.setAccessNodeInfo();
                    break;
                }
                SrmBillEditUtil.setScenenoMustinput((IDataModel)this.getModel(), (IFormView)this.getView());
                this.getModel().setValue("sceneno", null);
                break;
            }
        }
    }

    private void setAccessNodeInfo() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        long aptitudeId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("aptitudeno"));
        if (aptitudeId == 0L) {
            return;
        }
        DynamicObject aptitudeObj = BusinessDataServiceHelper.loadSingle((Object)aptitudeId, (String)"srm_aptitudeexam");
        if (aptitudeObj == null) {
            return;
        }
        DynamicObjectCollection entryentity = billObj.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> nodeList = new ArrayList<DynamicObject>(5);
        Map<String, ISrmAccessNodeService> nodeServcieMap = this.getNodeServcieMap(aptitudeObj, nodeList);
        if (!nodeServcieMap.isEmpty()) {
            for (DynamicObject entry : entryentity) {
                DynamicObjectCollection rowentity = entry.getDynamicObjectCollection("subentryentity");
                rowentity.clear();
                for (DynamicObject node : nodeList) {
                    DynamicObject dynamicObject = rowentity.addNew();
                    String objectnumber = node.getString("bizobject_id");
                    dynamicObject.set("accessnode", (Object)node);
                    ISrmAccessNodeService nodeService = nodeServcieMap.get(objectnumber);
                    if (nodeService == null) continue;
                    nodeService.setNodeBillnoAndStatus(objectnumber, Long.valueOf(aptitudeId), dynamicObject, entry);
                }
            }
            this.getView().updateView();
        }
    }

    private Map<String, ISrmAccessNodeService> getNodeServcieMap(DynamicObject aptitudeObj, List<DynamicObject> nodeList) {
        DynamicObjectCollection entryentity = aptitudeObj.getDynamicObjectCollection(SrmConstant.ENTRY_NODE);
        HashMap<String, ISrmAccessNodeService> nodeServcieMap = new HashMap<String, ISrmAccessNodeService>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            DynamicObject accessnode = entry.getDynamicObject("accessnode");
            String objectnumber = accessnode.getString("bizobject_id");
            if ("srm_aptitudeexam".equals(objectnumber) || "srm_supapprove".equals(objectnumber)) continue;
            nodeList.add(accessnode);
            String serviceclass = accessnode.getString("serviceclass");
            ISrmAccessNodeService nodeService = null;
            if (StringUtils.isNotBlank((CharSequence)serviceclass)) {
                nodeService = (ISrmAccessNodeService)TypesContainer.createInstance((String)serviceclass);
            }
            nodeServcieMap.put(objectnumber, nodeService);
        }
        return nodeServcieMap;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"barsubmit", (CharSequence)key)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (SrmCategoryConfigUtil.isCategory((DynamicObject)org).booleanValue()) {
                DynamicObject billObj = this.getModel().getDataEntity(true);
                if (billObj.getDynamicObject("aptitudeno") != null) {
                    Long aptitudeNoId = billObj.getDynamicObject("aptitudeno").getLong("number");
                    Map resultMap = SrmBillVerifyUtil.verifySubmitedCategory((String)"6", (Long)aptitudeNoId, (DynamicObject)billObj);
                    if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                        this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6240\u6709\u5206\u5f55\u884c\u5df2\u5728\u5176\u4ed6\u4f9b\u5e94\u5546\u751f\u6548\u5355\u4e2d\u5b58\u5728\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002%1", (String)"SrmSupApproveEdit_8", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupApproveEdit_8", (String)"scm-srm-formplugin", (Object[])new Object[]{resultMap.get("message").toString()}), MessageBoxOptions.OK);
                        this.getView().updateView();
                        evt.setCancel(true);
                        return;
                    }
                    if (((Boolean)resultMap.get("hasMsg")).booleanValue()) {
                        DynamicObjectCollection entryentity = billObj.getDynamicObjectCollection("entryentity");
                        ArrayList indexList = (ArrayList)resultMap.get("indexList");
                        for (int j = indexList.size() - 1; j >= 0; --j) {
                            int index = (Integer)indexList.get(j);
                            entryentity.remove(index);
                        }
                        this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u90e8\u5206\u5206\u5f55\u884c\u5df2\u5728\u5176\u4ed6\u4f9b\u5e94\u5546\u751f\u6548\u5355\u4e2d\u5b58\u5728,\u82e5\u8981\u7ee7\u7eed\uff0c\u8bf7\u518d\u6b21\u70b9\u51fb\u63d0\u4ea4\u3002%1", (String)"SrmSupApproveEdit_12", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupApproveEdit_12", (String)"scm-srm-formplugin", (Object[])new Object[]{resultMap.get("message").toString()}), MessageBoxOptions.OK);
                        this.getView().updateView("entryentity");
                        evt.setCancel(true);
                        return;
                    }
                    long billId = Long.parseLong(this.getModel().getDataEntity().getPkValue().toString());
                    SrmMultiTimesSupApproveService iSrmMultiTimesSupApproveService = new SrmMultiTimesSupApproveService();
                    if (billId == 0L) {
                        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"srm_supapprove", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
                        if (operationResult.isSuccess()) {
                            billId = Long.parseLong(operationResult.getSuccessPkIds().get(0).toString());
                            resultMap = iSrmMultiTimesSupApproveService.isValidApproveRowData(Long.valueOf(billId));
                        }
                    } else {
                        resultMap = iSrmMultiTimesSupApproveService.isValidApproveRowData(Long.valueOf(billId));
                    }
                    boolean less = (Boolean)resultMap.get("less");
                    boolean all = (Boolean)resultMap.get("all");
                    StringBuilder msgContent = new StringBuilder(resultMap.get("msgContent").toString());
                    if (!less) {
                        evt.setCancel(true);
                        msgContent.insert(0, ResManager.loadKDString((String)"\u6240\u6709\u5206\u5f55\u884c\u6821\u9a8c\u5931\u8d25\u3002\r\n", (String)"SrmSupApproveEdit_15", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        this.getView().showConfirm(msgContent.toString(), MessageBoxOptions.OK);
                        return;
                    }
                    if (less && !all) {
                        msgContent.insert(0, ResManager.loadKDString((String)"\u90e8\u5206\u5206\u5f55\u884c\u53ef\u4ee5\u751f\u6548\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\u751f\u6548\uff1f\r\n", (String)"SrmSupApproveEdit_16", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        this.getView().showConfirm(msgContent.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm"));
                    } else if (all) {
                        this.getView().invokeOperation("submit");
                    }
                }
            } else {
                if (!SrmCommonUtil.enableNewAccessFlow()) {
                    Boolean issample = this.getModel().getDataEntity(true).getDynamicObject("aptitudeno").getBoolean("issample");
                    Boolean ismaterial = this.getModel().getDataEntity(true).getDynamicObject("aptitudeno").getBoolean("ismaterial");
                    Boolean complentedissample = this.getModel().getDataEntity(true).getDynamicObject("aptitudeno").getBoolean("hassample");
                    Boolean complentedmaterial = this.getModel().getDataEntity(true).getDynamicObject("aptitudeno").getBoolean("hasmaterial");
                    boolean ok = true;
                    StringBuilder msg = new StringBuilder();
                    if (issample.booleanValue() && !complentedissample.booleanValue()) {
                        ok = false;
                        msg.append(ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u9700\u8981\u6837\u54c1\u786e\u8ba4\uff0c\u4f46\u672a\u5b8c\u6210\u3002", (String)"SrmSupApproveEdit_10", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    }
                    if (ismaterial.booleanValue() && !complentedmaterial.booleanValue()) {
                        ok = false;
                        msg.append(ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u9700\u8981\u7269\u6599\u8bd5\u7528\uff0c\u4f46\u672a\u5b8c\u6210\u3002", (String)"SrmSupApproveEdit_11", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    }
                    if (!ok) {
                        evt.setCancel(true);
                        this.getView().showTipNotification(msg.toString());
                        return;
                    }
                }
                this.getView().invokeOperation("submit");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("bar_unsubmit")) {
            // empty if block
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResultValue().equals("Yes")) {
            super.confirmCallBack(event);
            long billId = Long.parseLong(this.getModel().getDataEntity().getPkValue().toString());
            SrmMultiTimesSupApproveService iSrmMultiTimesSupApproveService = new SrmMultiTimesSupApproveService();
            iSrmMultiTimesSupApproveService.deleteNotApproveRowEntryData(Long.valueOf(billId));
            this.getView().invokeOperation("submit");
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("sceneno".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            long aptitudenoId = this.getModel().getDataEntity().getLong("aptitudeno.number");
            QFilter filter = new QFilter("aptitudeno.number", "=", (Object)aptitudenoId);
            filter.and(new QFilter("sceneresult", "=", (Object)"1").or("sceneresult", "=", (Object)"3"));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }
}

