/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmSupplierGroup;
import kd.scm.pds.common.util.AttachBatchDownloadUtils;
import kd.scm.srm.common.util.SrmAttachUtil;

public class SrmSupplierQuestionEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String STATUS_ENTRY_LOCK = "B";
    private static final String STATUS_UNENTRY_LOCK = "A";
    private static final String STATUS_UNLOCK = "A";
    private static final String STATUS_PARTAL_LOCK = "B";
    private static final String STATUS_ALL_LOCK = "C";
    private static final String ENTRY_STATUS_SUBMIT = "B";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        control.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit tplconfig = (BasedataEdit)this.getControl("tplconfig");
        tplconfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit suppliergroup = (BasedataEdit)this.getControl("suppliergroup");
        suppliergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "bardown": {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                List supdealstatus = dynamicObjectCollection.stream().filter(x -> "B".equals(x.getString("supdealstatus"))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(supdealstatus)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u7ed3\u679c\u9644\u4ef6\uff0c\u8bf7\u786e\u8ba4\u4f9b\u5e94\u5546\u662f\u5426\u5df2\u4e0a\u4f20\u9644\u4ef6\u5e76\u63d0\u4ea4\u95ee\u5377\u3002", (String)"SrmSupplierQuestionEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (key) {
                case "bar_resultcompare": {
                    this.dealCompareResult();
                    break;
                }
                case "selectlock": {
                    this.dealEntryLockStatus("B");
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "selectunlock": {
                    this.dealEntryLockStatus("A");
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "bardown": {
                    this.downAttachment();
                    break;
                }
                case "unaudit": {
                    this.getModel().setValue("lockstatus", (Object)"A");
                    DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        dynamicObject.set("entrylock", (Object)"A");
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("suppliergroup".equals(name)) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                return;
            }
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            MulBasedataDynamicObjectCollection newValue = (MulBasedataDynamicObjectCollection)changeData.getNewValue();
            ArrayList<Long> supGroups = new ArrayList<Long>(12);
            for (DynamicObject dynamicObject : newValue) {
                Long fbasedataid = dynamicObject.getLong("fbasedataid_id");
                supGroups.add(fbasedataid);
            }
            if (supGroups.size() > 0) {
                Iterator iterator = dynamicObjectCollection.iterator();
                while (iterator.hasNext()) {
                    DynamicObject group;
                    DynamicObject dynamicObject;
                    dynamicObject = (DynamicObject)iterator.next();
                    DynamicObject supplier = dynamicObject.getDynamicObject("supplier");
                    if (!Objects.nonNull(supplier) || Objects.isNull(group = supplier.getDynamicObject("group")) || supGroups.contains(group.getLong("id"))) continue;
                    iterator.remove();
                }
            } else {
                dynamicObjectCollection.clear();
            }
            this.getView().updateView("entryentity");
        }
        if ("tplconfig".equals(name)) {
            this.getModel().setValue("suppliergroup", null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        DynamicObject tplconfig = this.getModel().getDataEntity().getDynamicObject("tplconfig");
        if (Objects.isNull(tplconfig)) {
            return;
        }
        if ("select_sup".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection && !CollectionUtils.isEmpty((Collection)(selectedRows = (ListSelectedRowCollection)returnData))) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            if (primaryKeyValues.length == 0) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("supIds", primaryKeyValues);
            paramMap.put("tplconfig", tplconfig.getPkValue());
            paramMap.put("quetionId", this.getModel().getDataEntity().getPkValue());
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_questionseting", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "select_seting"));
        }
        if ("select_seting".equals(actionId) && Objects.nonNull(returnData = closedCallBackEvent.getReturnData())) {
            HashMap paramMap = (HashMap)returnData;
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_questionpkresult", (ShowType)ShowType.MainNewTabPage, (Map)paramMap, null);
        }
    }

    private void dealEntryLockStatus(String lockStatus) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.getView().getEntityId(), (String)"lockstatus,entryentity,entryentity.entrylock,entryentity.supplier", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getDataEntity().getPkValue())});
        ArrayList<Long> lockSupIds = new ArrayList<Long>(12);
        if (Objects.nonNull(dynamicObject)) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (selectRows.length == 0) {
                for (DynamicObject entryDy : entryentity) {
                    entryDy.set("entrylock", (Object)lockStatus);
                    lockSupIds.add(entryDy.getLong("supplier.id"));
                }
            } else {
                for (int selectRow : selectRows) {
                    DynamicObject entry = (DynamicObject)entryentity.get(selectRow);
                    entry.set("entrylock", (Object)lockStatus);
                    lockSupIds.add(entry.getLong("supplier.id"));
                }
            }
            this.deallockstatus(dynamicObject);
            this.updateQuestioncompLockStatus(lockSupIds, lockStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void updateQuestioncompLockStatus(List<Long> lockSupIds, String lockStatus) {
        QFilter qFilter = new QFilter("srcsupquestionid", "=", (Object)this.getModel().getDataEntity().getPkValue().toString());
        qFilter.and(new QFilter("supplier", "in", lockSupIds));
        DynamicObject[] srm_questioncomp = BusinessDataServiceHelper.load((String)"srm_questioncomp", (String)"id,lockstatus,supplier", (QFilter[])new QFilter[]{qFilter});
        if (srm_questioncomp.length != 0) {
            for (DynamicObject dynamicObject : srm_questioncomp) {
                dynamicObject.set("lockstatus", (Object)lockStatus);
            }
            SaveServiceHelper.update((DynamicObject[])srm_questioncomp);
        }
    }

    private void deallockstatus(DynamicObject dynamicObject) {
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        List entrylock = entryentity.stream().filter(x -> "B".equals(x.getString("entrylock"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entrylock)) {
            dynamicObject.set("lockstatus", (Object)"A");
        } else if (entryentity.size() == entrylock.size()) {
            dynamicObject.set("lockstatus", (Object)STATUS_ALL_LOCK);
        } else {
            dynamicObject.set("lockstatus", (Object)"B");
        }
    }

    private void dealCompareResult() {
        DynamicObjectCollection entryentity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List suIds = entryentity.stream().map(x -> {
            if (Objects.nonNull(x.getDynamicObject("supplier")) && "B".equals(x.getString("supdealstatus"))) {
                return x.getDynamicObject("supplier").getPkValue();
            }
            return 0;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(suIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u95ee\u5377\u6ca1\u6709\u53ef\u5bf9\u6bd4\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SrmSupplierQuestionEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"srm_supplier", (boolean)true, (int)0, (boolean)true);
        QFilter qFilter = new QFilter("id", "in", suIds);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(qFilter);
        lsp.setListFilterParameter(filterParameter);
        lsp.setCloseCallBack(new CloseCallBack(this.getPluginName(), "select_sup"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void downAttachment() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryentity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<BatchDownloadRequest.Dir> dirs = new ArrayList<BatchDownloadRequest.Dir>();
        for (int i = 0; i < entryentity.size(); ++i) {
            if (Objects.nonNull(selectRows) && selectRows.length > 0 && !CollectionUtils.arrayToList((Object)selectRows).contains(i)) continue;
            DynamicObjectCollection supattachment = ((DynamicObject)entryentity.get(i)).getDynamicObjectCollection("supattachment");
            DynamicObject supplier = ((DynamicObject)entryentity.get(i)).getDynamicObject("supplier");
            if (!Objects.nonNull(supplier) || CollectionUtils.isEmpty((Collection)supattachment)) continue;
            BatchDownloadRequest.Dir buildAttachDir = SrmAttachUtil.buildAttachDir((DynamicObjectCollection)supattachment, (String)supplier.getString("name"));
            dirs.add(buildAttachDir);
        }
        if (dirs.size() > 0) {
            String name = this.getModel().getDataEntity().getString("name");
            String url = AttachBatchDownloadUtils.buildDownloadTempUrl((String)(name + ".zip"), dirs, (int)7000);
            this.getView().download(url);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u7ed3\u679c\u9644\u4ef6\uff0c\u8bf7\u786e\u8ba4\u4f9b\u5e94\u5546\u662f\u5426\u5df2\u4e0a\u4f20\u9644\u4ef6\u5e76\u63d0\u4ea4\u95ee\u5377\u3002", (String)"SrmSupplierQuestionEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("supdealstatus".equals(fieldName)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            DynamicObject dynamicObject = (DynamicObject)entry.get(rowIndex);
            DynamicObject supplier = dynamicObject.getDynamicObject("supplier");
            String supdealstatus = dynamicObject.getString("supdealstatus");
            if (!"B".equals(supdealstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u672a\u63d0\u4ea4\uff0c\u4e0d\u80fd\u67e5\u770b\u4f9b\u5e94\u5546\u586b\u5199\u95ee\u5377\u5185\u5bb9\u3002", (String)"SrmSupplierQuestionEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (Objects.nonNull(supplier)) {
                QFilter qFilter = new QFilter("srcsupquestionid", "=", (Object)this.getModel().getDataEntity().getPkValue().toString());
                qFilter.and(new QFilter("supplier", "=", supplier.getPkValue()));
                DynamicObject srm_questioncomp = QueryServiceHelper.queryOne((String)"srm_questioncomp", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (Objects.nonNull(srm_questioncomp)) {
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_questioncomp", (Object)srm_questioncomp.getLong("id"), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.NewWindow, null, null);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (Objects.isNull(org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u53d1\u5e03\u7ec4\u7ec7\u3002", (String)"SrmSupplierQuestionEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject[] srm_questionrange = BusinessDataServiceHelper.load((String)"srm_questionrange", (String)"id,entryentity.questiontpl,entryentity.suppliergroup", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()).and(new QFilter("enable", "=", (Object)"1"))});
        switch (name) {
            case "tplconfig": {
                this.setTplconfigF7Filter(beforeF7SelectEvent, srm_questionrange);
                break;
            }
            case "suppliergroup": {
                this.setSupGroupF7Filter(beforeF7SelectEvent, srm_questionrange);
                break;
            }
            case "supplier": {
                this.setSupplierF7Filter(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void setSupplierF7Filter(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection suppliergroup = this.getModel().getDataEntity().getDynamicObjectCollection("suppliergroup");
        QFilter qFilter = new QFilter("auditstatus", "not in", (Object)new String[]{"D"});
        if (!CollectionUtils.isEmpty((Collection)suppliergroup)) {
            List suGrouIds = suppliergroup.stream().map(x -> x.get("fbasedataid_id")).collect(Collectors.toList());
            QFilter groupqFilter = new QFilter("group", "in", suGrouIds);
            qFilter.and(groupqFilter);
        }
        beforeF7SelectEvent.addCustomQFilter(qFilter);
    }

    private void setTplconfigF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject[] srm_questionrange) {
        ArrayList<Object> questiontpls = new ArrayList<Object>(12);
        if (srm_questionrange.length > 0) {
            for (DynamicObject dynamicObject : srm_questionrange) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : entryentity) {
                    DynamicObject questiontpl = object.getDynamicObject("questiontpl");
                    if (!Objects.nonNull(questiontpl)) continue;
                    questiontpls.add(questiontpl.getPkValue());
                }
            }
        }
        if (questiontpls.size() > 0) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", questiontpls));
        }
    }

    private void setSupGroupF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject[] srm_questionrange) {
        DynamicObject tplconfig = this.getModel().getDataEntity().getDynamicObject("tplconfig");
        if (Objects.isNull(tplconfig)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u8c03\u67e5\u95ee\u5377\u6a21\u677f\u201d\u3002", (String)"SrmSupplierQuestionEdit_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        SrmSupplierGroup.beforeF7Select((BeforeF7SelectEvent)beforeF7SelectEvent, org == null ? null : Long.valueOf(org.getLong("id")));
        if (srm_questionrange.length > 0) {
            ArrayList supGroups = new ArrayList(12);
            for (DynamicObject dynamicObject : srm_questionrange) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : entryentity) {
                    DynamicObjectCollection suppliergroup;
                    DynamicObject questiontpl = object.getDynamicObject("questiontpl");
                    if (!Objects.nonNull(questiontpl) || !questiontpl.getPkValue().equals(tplconfig.getPkValue()) || CollectionUtils.isEmpty((Collection)(suppliergroup = object.getDynamicObjectCollection("suppliergroup")))) continue;
                    List suGrouIds = suppliergroup.stream().map(x -> x.get("fbasedataid_id")).collect(Collectors.toList());
                    supGroups.addAll(suGrouIds);
                }
            }
            if (supGroups.size() > 0) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", supGroups));
            }
        }
    }
}

