/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Vector;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.cloudkingdee.CloudDataUtils;
import kd.scm.common.cloudkingdee.CompanyInfo;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.srm.common.BusinessRulesServiceUtils;

public class SrmSupplierRegEdit
extends AbstractBillPlugIn {
    private static Log log = LogFactory.getLog(SrmSupplierRegEdit.class);

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        ChangeData[] changeSet = arg0.getChangeSet();
        IDataEntityProperty property = arg0.getProperty();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propertyName = property.getName()) {
            case "name": {
                Object oldNameValue = changeSet[0].getOldValue();
                try {
                    BusinessRulesServiceUtils.input((IFormView)view, (IDataModel)model, (String)propertyName, (Object)oldNameValue);
                }
                catch (Exception e1) {
                    log.error("\u52a0\u8f7d\u4f9b\u5e94\u5546\u6570\u636e\u5f02\u5e38", (Throwable)e1);
                    view.showTipNotification(ExceptionUtil.wrapExceptionErrorInfo((Throwable)e1));
                }
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity;
        CompanyInfo companyInfo;
        super.afterBindData(e);
        this.resetStatus();
        this.setStatusVisible(true);
        if (SrmSupplierStatusEnum.SUCCESS.getValue().equals(this.getModel().getValue("auditstatus"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_backreject"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_unsubmit"});
        }
        if ((companyInfo = BusinessRulesServiceUtils.loadBusinessInfos((DynamicObject)(dataEntity = this.getModel().getDataEntity()))) == null) {
            companyInfo = this.getCompanyInfo();
        }
        if (companyInfo == null) {
            return;
        }
        this.checkData(companyInfo);
    }

    private void checkData(CompanyInfo companyInfo) {
        IDataModel model = this.getModel();
        String societycreditcode = (String)model.getValue("societycreditcode");
        String artificialperson = null;
        OrmLocaleValue artificialpersonlocal = (OrmLocaleValue)model.getValue("artificialperson");
        if (artificialpersonlocal != null) {
            artificialperson = artificialpersonlocal.getLocaleValue_zh_CN();
        }
        String regaddress = null;
        OrmLocaleValue regaddresslocal = (OrmLocaleValue)model.getValue("regaddress");
        if (regaddresslocal != null) {
            regaddress = regaddresslocal.getLocaleValue_zh_CN();
        }
        Date regdate = (Date)model.getValue("regdate");
        if (companyInfo.getAddress() != null && !companyInfo.getAddress().equals(regaddress)) {
            this.setTipes("fail_regaddress", companyInfo.getAddress());
        }
        if (companyInfo.getSocialCreditCode() != null && !companyInfo.getSocialCreditCode().equals(societycreditcode)) {
            this.setTipes("fail_societycreditcode", companyInfo.getSocialCreditCode());
        }
        if (companyInfo.getEstablisDate() != null && !companyInfo.getEstablisDate().equals(regdate)) {
            this.setTipes("fail_regdate", DateUtil.date2str((Date)companyInfo.getEstablisDate(), (String)"yyyy-MM-dd"));
        }
        if (companyInfo.getLegalPerson() != null && !companyInfo.getLegalPerson().equals(artificialperson)) {
            this.setTipes("fail_artificialperson", companyInfo.getLegalPerson());
        }
    }

    private CompanyInfo getCompanyInfo() {
        OrmLocaleValue companynamelocal = (OrmLocaleValue)this.getModel().getValue("name");
        if (companynamelocal == null) {
            return null;
        }
        String companyname = companynamelocal.getLocaleValue();
        CompanyInfo companyInfo = CloudDataUtils.getCompanyInfo((String)companyname);
        return companyInfo;
    }

    private void setTipes(String name, String tip) {
        this.getView().setVisible(Boolean.TRUE, new String[]{name});
        Vector cector = (Vector)this.getView().getControl(name);
        Tips tips = new Tips();
        LocaleString local = new LocaleString();
        local.setLocaleValue(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6240\u586b\u4fe1\u606f\u4e0e\u5927\u6570\u636e\u9a8c\u8bc1\u4e0d\u76f8\u7b26\uff0c\u5927\u6570\u636e\u4fe1\u606f\u4e3a\uff1a%1", (String)"SrmSupplierRegEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierRegEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[]{tip}));
        tips.setContent(local);
        tips.setType("text");
        tips.setShowIcon(false);
        tips.setTriggerType("hover");
        cector.addTips(tips);
    }

    private void setStatusVisible(boolean isInit) {
        if (isInit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fail_societycreditcode"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fail_artificialperson"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fail_regdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fail_regaddress"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "reject": 
            case "rejection": {
                this.resetStatus();
                break;
            }
        }
        if ("savedata".equals(operateKey) || "submit".equals(operateKey)) {
            String linkman = this.getModel().getDataEntity().getString("linkman");
            String phone = this.getModel().getDataEntity().getString("phone");
            if (StringUtils.isNotBlank((CharSequence)linkman)) {
                this.getModel().setValue("linkman", (Object)linkman.trim());
            }
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                this.getModel().setValue("phone", (Object)phone.replace(" ", ""));
            }
        }
    }

    public void resetStatus() {
        this.getModel().setDataChanged(false);
        DynamicObject obj = this.getModel().getDataEntity();
        String bizStatus = obj.getString("auditstatus");
        if (bizStatus == null) {
            return;
        }
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(bizStatus.toLowerCase() + "tab"));
    }
}

