/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.portrait;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.StepsOption;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.smc.user.utils.DateUtil;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.srm.formplugin.edit.portrait.IEntryGridControl;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;
import kd.sdk.scm.srm.extpoint.portait.ISrmPortraitStatistic;

public final class SrmPortraitAccessEdit
extends AbstractBillPlugIn
implements IEntryGridControl {
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
    }

    public void afterCreateNewData(EventObject e) {
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getView().getParentView().getPageCache());
        if (context == null) {
            return;
        }
        this.createStepsInfos(context);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int pageRow = grid.getPageRow();
        int startRowIndex = 0;
        this.onFetchPageData(startRowIndex, pageRow, true);
        this.createSceneInfo(context);
    }

    private void createSceneInfo(SrmPortraitContext context) {
        QFilter qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter(null, (String)"org", (String)"billdate", (SrmPortraitContext)context);
        if (context.getSupplierIds() != null && context.getSupplierIds().size() > 0) {
            qFilter.and("supplier", "in", (Object)context.getSupplierIds());
        }
        qFilter.and("auditstatus", "=", (Object)"C");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"srm_sceneexam", (String)"billdate,scenescore,sceneresult,org", (QFilter[])new QFilter[]{qFilter}, (String)"billdate desc", (int)2);
        for (int i = 0; i < query.size(); ++i) {
            this.getView().getModel().setValue("date" + (i + 1), ((DynamicObject)query.get(i)).get("billdate"));
            this.getView().getModel().setValue("score" + (i + 1), ((DynamicObject)query.get(i)).get("scenescore"));
            this.getView().getModel().setValue("sceneresult" + (i + 1), ((DynamicObject)query.get(i)).get("sceneresult"));
            this.getView().getModel().setValue("org" + (i + 1), ((DynamicObject)query.get(i)).get("org"));
        }
    }

    private void createStepsInfos(SrmPortraitContext context) {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        List stepsOptions = wizard.getStepsOptions();
        stepsOptions.clear();
        IFormView parentView = this.getView().getParentView();
        String auditDes = " ";
        String approveDes = " ";
        String accessStatus = String.valueOf(context.getCustomParam().get("accessStatus"));
        String enableDes = String.valueOf(context.getCustomParam().get("accessEnable"));
        auditDes = this.formatDateInfo(context.getCustomParam().get("accessAuditDate"), auditDes);
        String regisDes = this.formatDateInfo(context.getCustomParam().get("accessCreateTime"), " ");
        Long billid = (Long)parentView.getFormShowParameter().getCustomParam("billid");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"srm_supapprove", (String)"id,auditdate", (QFilter[])new QFilter[]{new QFilter("supplier", "=", (Object)billid)}, (String)"auditdate", (int)1);
        if (rows.size() > 0 && ((DynamicObject)rows.get(0)).getDate("auditdate") != null) {
            approveDes = DateUtil.formatDate((Date)((DynamicObject)rows.get(0)).getDate("auditdate"));
        }
        stepsOptions.add(this.createStepsOptions(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u6ce8\u518c", (String)"SrmPortraitAccessEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmPortraitAccessEdit_0", (String)"scm-srm-formplugin"), regisDes));
        if (StringUtils.equals((CharSequence)accessStatus, (CharSequence)SrmSupplierStatusEnum.UNAUDIT.getValue())) {
            stepsOptions.add(this.createStepsOptions(new LocaleString(SrmSupplierStatusEnum.UNAUDIT.getName()), " "));
        } else {
            stepsOptions.add(this.createStepsOptions(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u8d44\u6599\u5ba1\u6838\u901a\u8fc7", (String)"SrmPortraitAccessEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmPortraitAccessEdit_1", (String)"scm-srm-formplugin"), auditDes));
        }
        stepsOptions.add(this.createStepsOptions(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u6b63\u5f0f\u4f9b\u5e94\u5546", (String)"SrmPortraitAccessEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmPortraitAccessEdit_2", (String)"scm-srm-formplugin"), approveDes));
        if (StringUtils.equals((CharSequence)enableDes, (CharSequence)"0")) {
            stepsOptions.add(this.createStepsOptions(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u9000\u51fa", (String)"SrmPortraitAccessEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmPortraitAccessEdit_3", (String)"scm-srm-formplugin"), " "));
        }
        wizard.setWizardStepsOptions(stepsOptions);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        currentStepMap.put("currentStep", stepsOptions.size() - 1);
        currentStepMap.put("currentStatus", "");
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private String formatDateInfo(Object dateStr, String defaultValue) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isNotBlank((Object)dateStr) && !"null".equals(dateStr)) {
            Date date = (Date)SerializationUtils.fromJsonString((String)String.valueOf(dateStr), Date.class);
            return simpleDateFormat.format(date);
        }
        return defaultValue;
    }

    private StepsOption createStepsOptions(LocaleString name, String des) {
        StepsOption option = new StepsOption();
        option.setTitle(name);
        option.setDescription(new LocaleString(des));
        return option;
    }

    @Override
    public void createEntryEntity(int startRowIndex, int pageRows, boolean isFirstPage) {
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getView().getParentView().getPageCache());
        if (context == null) {
            return;
        }
        QFilter qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter(null, (String)"org", (String)"modifytime", (SrmPortraitContext)context);
        if (context.getSupplierIds() != null && context.getSupplierIds().size() > 0) {
            qFilter.and("supplier", "in", (Object)context.getSupplierIds());
        }
        qFilter.and("auditstatus", "=", (Object)"1");
        try (DataSet dataSet = ORM.create().queryDataSet(this.getClass().getName(), "srm_supcategory", "org,category,supplier,categorytype,material,auditstatus,modifytime", new QFilter[]{qFilter}, "modifytime desc", startRowIndex, pageRows);){
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
            this.getView().getModel().beginInit();
            entryEntities.clear();
            TableValueSetter ts = new TableValueSetter(new String[0]);
            int i = 0;
            for (Row row : dataSet) {
                ts.set("org", (Object)row.getLong("org"), i);
                ts.set("supplier", (Object)row.getLong("supplier"), i);
                ts.set("categorytype", (Object)row.getString("categorytype"), i);
                ts.set("material", (Object)row.getLong("material"), i);
                ts.set("category", (Object)row.getLong("category"), i);
                ts.set("auditstatus", (Object)row.getString("auditstatus"), i);
                ts.set("modifytime", (Object)row.getDate("modifytime"), i);
                ++i;
            }
            this.getView().getModel().deleteEntryData("entryentity");
            this.getView().getModel().beginInit();
            ((AbstractFormDataModel)this.getView().getModel()).batchCreateNewEntryRow("entryentity", ts);
            this.getView().getModel().endInit();
            if (isFirstPage) {
                DynamicObjectCollection queryAll = QueryServiceHelper.query((String)"srm_supcategory", (String)"id", (QFilter[])new QFilter[]{qFilter});
                int rowCount = queryAll.size();
                dataEntity.getDataEntityState().setEntryRowCount("entryentity", rowCount);
            }
            dataEntity.getDataEntityState().setEntryPageSize("entryentity", pageRows);
            dataEntity.getDataEntityState().setEntryStartRowIndex("entryentity", startRowIndex);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        this.onCustomGetControl(e, "entryentity", this.getView());
    }
}

