/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.portrait;

import java.util.EventObject;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.srm.formplugin.edit.portrait.IEntryGridControl;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;
import kd.sdk.scm.srm.extpoint.portait.ISrmPortraitStatistic;

public class SrmPortraitSourceEdit
extends AbstractBillPlugIn
implements IEntryGridControl {
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getView().getParentView().getPageCache());
        if (context == null) {
            return;
        }
        QFilter qFilter = this.createBidAndWinIndicator(context);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int pageRow = grid.getPageRow();
        int startRowIndex = 0;
        this.onFetchPageData(startRowIndex, pageRow, true);
        Object winNum = context.getCustomParam().get("winnum");
        Label winvalue = (Label)this.getView().getControl("winvalue");
        winvalue.setText(String.valueOf(winNum));
    }

    private QFilter createBidAndWinIndicator(SrmPortraitContext context) {
        QFilter qFilter = this.getQfilter(context);
        try (AlgoContext algoContext = Algo.newContext();){
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"src_contractentry", (String)"project.org org,currency,loctaxamount,supplier,(case when (loctaxprice - maxtaxprice) > 0 and maxtaxprice > 0 then (loctaxprice - maxtaxprice) * cfmqty else 0 end) overamount", (QFilter[])new QFilter[]{qFilter}, null);
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"supplier"});
            groupbyDataSet.sum("loctaxamount", "loctaxamount");
            groupbyDataSet.sum("overamount", "overamount");
            DataSet data = groupbyDataSet.finish();
            for (Row datum : data) {
                this.getModel().setValue("winamount", (Object)datum.getBigDecimal("loctaxamount"));
                this.getModel().setValue("overamount", (Object)datum.getBigDecimal("overamount"));
            }
        }
        this.getModel().setValue("curr", (Object)context.getCurrId());
        return qFilter;
    }

    private QFilter getQfilter(SrmPortraitContext context) {
        QFilter qFilter = QFilter.join((String)"project", (String)"src_projectf7.id");
        QFilter qFilter1 = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter((String)"supplier", (String)"project.org", (String)"project.createtime", (SrmPortraitContext)context);
        qFilter.and(qFilter1);
        qFilter.and("loccurr", "=", (Object)context.getCurrId());
        return qFilter;
    }

    @Override
    public void createEntryEntity(int startRowIndex, int pageRows, boolean isFirstPage) {
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getView().getParentView().getPageCache());
        if (context == null) {
            return;
        }
        QFilter qfilter = this.getQfilter(context);
        try (DataSet dataSet = ORM.create().queryDataSet(this.getClass().getName(), "src_contractentry", "project,project.org org,project.createtime createtime,project.billno billno,supplier,loctaxamount,loccurr,currency,locamount", new QFilter[]{qfilter}, "src_projectf7.createtime desc", startRowIndex, pageRows, null);){
            TableValueSetter setter = new TableValueSetter(new String[0]);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"org", "supplier", "billno", "loccurr", "createtime", "project"});
            GroupbyDataSet sum = groupbyDataSet.sum("loctaxamount").sum("locamount");
            DataSet distinct = sum.finish();
            int i = 0;
            for (Row row : distinct) {
                setter.set("org", (Object)row.getLong("org"), i);
                setter.set("supplier", (Object)row.getLong("supplier"), i);
                setter.set("billno", (Object)row.getString("billno"), i);
                setter.set("amount", (Object)row.getBigDecimal("locamount"), i);
                setter.set("taxamount", (Object)row.getBigDecimal("loctaxamount"), i);
                setter.set("loccurr", (Object)row.getLong("loccurr"), i);
                setter.set("biddate", (Object)row.getDate("createtime"), i);
                ++i;
            }
            this.getView().getModel().beginInit();
            ((AbstractFormDataModel)this.getView().getModel()).batchCreateNewEntryRow("entryentity", setter);
            this.getView().getModel().endInit();
            if (isFirstPage) {
                int rowCount = ORM.create().count(this.getClass().getName(), "src_contractentry", "project", new QFilter[]{qfilter}, (Distinctable)WithDistinctable.get());
                dataEntity.getDataEntityState().setEntryRowCount("entryentity", rowCount);
            }
            dataEntity.getDataEntityState().setEntryPageSize("entryentity", pageRows);
            dataEntity.getDataEntityState().setEntryStartRowIndex("entryentity", startRowIndex);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        this.onCustomGetControl(e, "entryentity", this.getView());
    }
}

