/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.portrait.statistic;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticContainer;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticInfo;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;

public final class SrmPortraitOrderStatistic
extends AbstractSrmPortraitDataSetStatistic {
    private SrmPortraitContext context = null;

    public final void startStatistic(SrmPortraitContext context, SrmPortraitStatisticContainer container) {
        QFilter qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter((String)"supplier", (String)"org", (String)"billdate", (SrmPortraitContext)context);
        qFilter.and("billstatus", "=", (Object)"C");
        this.context = context;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order", (String)"id,sumtaxamount,curr,curr.name currname,billdate,supplier,org,(case when billstatus = 'C' AND cfmstatus = 'A' then 1 else 0 end) as unconfim,(case when billstatus = 'C' then 1 else 0 end) as total", (QFilter[])new QFilter[]{qFilter}, (String)"billdate asc");){
            GroupbyDataSet groupbyDataSet = this.groupBy(dataSet);
            GroupbyDataSet sum = groupbyDataSet.sum("total").sum("unconfim").sum("sumtaxamount");
            this.reduceStatistic(sum.finish(), container);
        }
    }

    private void setFirstCoTime(SrmPortraitContext context, Map<String, Map<String, Object>> realTimeStatisticInfoMap) {
        QFilter qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter((String)"supplier", (String)"org", null, (SrmPortraitContext)context);
        qFilter.and("billstatus", "=", (Object)"C");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order", (String)"id,supplier,billdate", (QFilter[])new QFilter[]{qFilter}, (String)"billdate asc");){
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"supplier"});
            GroupbyDataSet billdate = groupbyDataSet.min("billdate");
            DataSet finish = billdate.finish();
            this.wrapStatisticMapWidthSet(finish, realTimeStatisticInfoMap, "copTime", "billdate");
        }
    }

    protected final void reduceStatistic(DataSet dataSource, SrmPortraitStatisticContainer container) {
        if (dataSource != null && container != null) {
            Map statisticInfoMap = container.getStatisticInfoMap();
            Map realTimeStatisticInfoMap = container.getRealTimeStatisticInfoMap();
            if (realTimeStatisticInfoMap == null) {
                return;
            }
            this.setFirstCoTime(this.context, realTimeStatisticInfoMap);
            if (statisticInfoMap != null) {
                for (Row row : dataSource) {
                    SrmPortraitStatisticInfo info = (SrmPortraitStatisticInfo)statisticInfoMap.get(this.makeRowKey(row));
                    if (info == null) {
                        info = this.createStatisticInfo(row, statisticInfoMap);
                        this.wrapStatisticMap(realTimeStatisticInfoMap, row.getString("supplier"), "defCurr", row.getLong("curr"));
                    }
                    info.setOrderNum(row.getInteger("total").intValue());
                    BigDecimal sumtaxamount = row.getBigDecimal("sumtaxamount");
                    info.setAmount(sumtaxamount);
                    info.setUnConFirmOrderNum(row.getInteger("unconfim").intValue());
                }
            }
        }
    }
}

