/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.srm.common.SrmIssueRfiUtil;
import kd.scm.srm.common.SrmSendEmailUtil;

public class SrmIssueRfiList
extends AbstractListPlugin {
    private static final String NEED_CLEAR_FILTER_STR = "needClearFilter";
    private static final int maxSelectLength = 1;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (!this.isFromAdmitancePanel().booleanValue()) {
            return;
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if ("org.name".equals(fieldName) || "org.number".equals(fieldName) || "org.id".equals(fieldName) || "createtime".equals(fieldName)) {
                commonFilterColumn.setDefaultValue("");
            }
            if ("billstatus".equals(fieldName)) {
                commonFilterColumn.setDefaultValue("C");
            }
            if (!"haveconfirm".equals(fieldName)) continue;
            commonFilterColumn.setDefaultValues(new Object[]{"N"});
        }
        List fastFilterColumns = args.getFastFilterColumns();
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        String searchStr = "";
        if (null != customParamsMap) {
            Object searchTextObj = customParamsMap.get("searchText");
            String string = searchStr = null == searchTextObj ? searchStr : searchTextObj.toString();
        }
        if (StringUtils.isBlank((CharSequence)searchStr)) {
            return;
        }
        for (FilterColumn fastFilterColumn : fastFilterColumns) {
            String fieldNameStr = fastFilterColumn.getFieldName();
            if (!"suppliername".equals(fieldNameStr)) continue;
            fastFilterColumn.setDefaultValue(searchStr);
        }
        this.getView().getPageCache().put(NEED_CLEAR_FILTER_STR, "1");
    }

    private Boolean isFromAdmitancePanel() {
        Boolean result = Boolean.FALSE;
        String needClearFilterFlag = this.getPageCache().get(NEED_CLEAR_FILTER_STR);
        if (StringUtils.isNotBlank((CharSequence)needClearFilterFlag)) {
            return result;
        }
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParamsMap) {
            Object flagObj = customParamsMap.get("fromAdmitancePanelFlag");
            result = null == flagObj ? Boolean.FALSE : (Boolean)flagObj;
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "resendemail": {
                    this.resendemail();
                }
            }
        }
    }

    private void resendemail() {
        IFormView view = this.getView();
        DynamicObject issuerfiBill = BillFormUtil.getSelectData((IFormView)view, (String)"srm_issuerfi");
        if (issuerfiBill == null) {
            return;
        }
        Map checkMap = SrmIssueRfiUtil.verifyResendEmail((DynamicObject)issuerfiBill);
        if ("false".equals(checkMap.get("succed"))) {
            view.showTipNotification(checkMap.get("message").toString());
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            view.showConfirm(ResManager.loadKDString((String)"\u5c06\u91cd\u65b0\u53d1\u9001\u9080\u7ea6\u90ae\u4ef6\uff0c\u90ae\u4ef6\u6709\u6548\u671f\u4e3a7\u5929\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"SrmIssueRfiList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmResendEmail"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmResendEmail".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObject issuerfiBill = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"srm_issuerfi");
            if (issuerfiBill != null) {
                String email = issuerfiBill.getString("email");
                boolean hasSrmUser = QueryServiceHelper.exists((String)"srm_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)email)});
                boolean hasSrmSupplierReg = QueryServiceHelper.exists((String)"srm_supplierreg", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)email)});
                if (!hasSrmUser && !hasSrmSupplierReg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u548c\u6ce8\u518c\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u53d1\u90ae\u4ef6\uff0c\u8bf7\u91cd\u65b0\u5bf9\u4f9b\u5e94\u5546\u8fdb\u884c\u6ce8\u518c\u9080\u7ea6\u3002", (String)"SrmIssueRfiList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!hasSrmUser) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u53d1\u90ae\u4ef6\uff0c\u8bf7\u91cd\u65b0\u5bf9\u4f9b\u5e94\u5546\u8fdb\u884c\u6ce8\u518c\u9080\u7ea6\u3002", (String)"SrmIssueRfiList_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!hasSrmSupplierReg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u53d1\u90ae\u4ef6\uff0c\u8bf7\u91cd\u65b0\u5bf9\u4f9b\u5e94\u5546\u8fdb\u884c\u6ce8\u518c\u9080\u7ea6\u3002", (String)"SrmIssueRfiList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.confirmResendEmail();
            this.getView().updateView();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u53d1\u6210\u529f\u3002", (String)"SrmIssueRfiList_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }

    private void confirmResendEmail() {
        IFormView view = this.getView();
        DynamicObject issuerfiBill = BillFormUtil.getSelectData((IFormView)view, (String)"srm_issuerfi");
        issuerfiBill.set("mailvalidity", (Object)DateUtil.addDays((Date)DateUtil.formatEndDate((Date)TimeServiceHelper.now()), (int)7));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{issuerfiBill});
        String suppliername = issuerfiBill.getString("suppliername");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"adm_supplierreg", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)suppliername)});
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        Long id = dynamicObject.getLong("id");
        SrmSendEmailUtil.sendEmail((DynamicObject[])new DynamicObject[]{issuerfiBill}, (Object)id);
    }
}

