/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;

public class SrmScoreList
extends AbstractListPlugin {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        DynamicObject obj = null;
        long billId = 0L;
        switch (key) {
            case "tblterminate": {
                billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                QFilter qFilter = new QFilter("id", "=", (Object)billId).and("bizstatus", "<", (Object)SrmScoreStatusEnum.APPROVED.getValue());
                obj = QueryServiceHelper.queryOne((String)"srm_score", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (obj != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6838\u51c6\u6216\u5df2\u7ec8\u6b62\u7684\u8bc4\u4f30\u4efb\u52a1\u4e0d\u5141\u8bb8\u7ec8\u6b62\u3002", (String)"SrmScoreList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "reautoscore": {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
                if (Objects.isNull(primaryKeyValues) || primaryKeyValues.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"SrmScoreList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection scores = QueryServiceHelper.query((String)"srm_score", (String)"id,taskbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                Map<Long, List<DynamicObject>> taskbillidMap = scores.stream().collect(Collectors.groupingBy(x -> x.getLong("taskbillid")));
                if (!CollectionUtils.isEmpty(taskbillidMap.keySet()) && taskbillidMap.size() <= 1) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6765\u6e90\u4e8e\u540c\u4e00\u8bc4\u4f30\u8ba1\u5212\u7684\u4efb\u52a1\u91cd\u65b0\u8bc4\u5206\u3002", (String)"SrmScoreList_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "tbldelete": {
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            MutexHelper.release((String)"srm_score", (String)"terminate", (String)String.valueOf(billId));
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "terminate": {
                    long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                    MutexHelper.require((String)"srm_score", (Object)billId, (String)"terminate", (boolean)true, (StringBuilder)new StringBuilder(16));
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_scoreend", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
                    break;
                }
            }
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String listFieldKey = args.getListFieldKey();
        if ("bizstatus".equals(listFieldKey)) {
            List comboItems = args.getComboItems();
            Iterator iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                ValueMapItem next = (ValueMapItem)iterator.next();
                String value = next.getValue();
                if (!this.getHideAuditstatusValue().contains(value)) continue;
                iterator.remove();
            }
        }
    }

    protected List<String> getHideAuditstatusValue() {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add("A");
        return values;
    }
}

