/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;
import kd.scm.srm.service.SrmMultiTimesSupApproveService;

public class SrmSupApproveList
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow) {
            List<String> deleteColumns = this.getColumnList();
            List columns = args.getListColumns();
            ArrayList<IListColumn> listColumns = new ArrayList<IListColumn>(columns.size());
            for (IListColumn column : columns) {
                String fieldKey = column.getListFieldKey();
                if (deleteColumns.contains(fieldKey)) continue;
                listColumns.add(column);
            }
            columns.clear();
            columns.addAll(listColumns);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        long billId = 0L;
        if (key.equals("tblcheck")) {
            billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            if (billId == 0L) {
                evt.setCancel(true);
                return;
            }
        } else if (key.equals("barsubmit")) {
            billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            if (billId == 0L) {
                evt.setCancel(true);
                return;
            }
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((String)"srm_supapprove", (String)"org,billstatus,billno,aptitudeno,entryentity.categorytype,entryentity.category,entryentity.category.id,entryentity.material,entryentity.material.id,entryentity.testresult", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
            DynamicObject org = billObj.getDynamicObject("org");
            if (SrmCategoryConfigUtil.isCategory((DynamicObject)org).booleanValue()) {
                Map resultMap;
                String billstatus = billObj.getString("billstatus");
                if ("A".equals(billstatus)) {
                    String billno = billObj.getString("billno");
                    if (billObj.getDynamicObject("aptitudeno") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u8d28\u5ba1\u67e5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"SrmSupApproveList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    Long aptitudeNoId = billObj.getDynamicObject("aptitudeno").getLong("number");
                    resultMap = SrmBillVerifyUtil.verifySubmitedCategory((String)"6", (Long)aptitudeNoId, (DynamicObject)billObj);
                    if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                        this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1:\u6240\u6709\u5206\u5f55\u884c\u5df2\u5728\u5176\u4ed6\u4f9b\u5e94\u5546\u751f\u6548\u5355\u4e2d\u5b58\u5728\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c%2\u3002", (String)"SrmSupApproveList_1", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupApproveListPlugin_1", (String)"scm-srm-formplugin", (Object[])new Object[]{billno, resultMap.get("message").toString()}), MessageBoxOptions.OK);
                        evt.setCancel(true);
                        return;
                    }
                    if (((Boolean)resultMap.get("hasMsg")).booleanValue()) {
                        DynamicObjectCollection entryentity = billObj.getDynamicObjectCollection("entryentity");
                        ArrayList indexList = (ArrayList)resultMap.get("indexList");
                        for (int j = indexList.size() - 1; j >= 0; --j) {
                            int index = (Integer)indexList.get(j);
                            entryentity.remove(index);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
                        this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1:\u90e8\u5206\u5206\u5f55\u884c\u5df2\u5728\u5176\u4ed6\u4f9b\u5e94\u5546\u751f\u6548\u5355\u4e2d\u5b58\u5728\uff0c\u82e5\u8981\u7ee7\u7eed\uff0c\u8bf7\u518d\u6b21\u70b9\u51fb\u63d0\u4ea4\uff0c%2\u3002", (String)"SrmSupApproveList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupApproveListPlugin_2", (String)"scm-srm-formplugin", (Object[])new Object[]{billno, resultMap.get("message").toString()}), MessageBoxOptions.OK);
                        evt.setCancel(true);
                        return;
                    }
                }
                SrmMultiTimesSupApproveService iSrmMultiTimesSupApproveService = new SrmMultiTimesSupApproveService();
                resultMap = iSrmMultiTimesSupApproveService.isValidApproveRowData(Long.valueOf(billId));
                boolean less = (Boolean)resultMap.get("less");
                boolean all = (Boolean)resultMap.get("all");
                StringBuilder msgContent = new StringBuilder(resultMap.get("msgContent").toString());
                if (!less) {
                    evt.setCancel(true);
                    msgContent.insert(0, ResManager.loadKDString((String)"\u6240\u6709\u5206\u5f55\u884c\u6821\u9a8c\u5931\u8d25\u3002\r\n", (String)"SrmSupApproveList_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    this.getView().showConfirm(msgContent.toString(), MessageBoxOptions.OK);
                    return;
                }
                if (less && !all) {
                    msgContent.insert(0, ResManager.loadKDString((String)"\u90e8\u5206\u5206\u5f55\u884c\u53ef\u4ee5\u751f\u6548\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\u751f\u6548?\r\n", (String)"SrmSupApproveList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    this.getView().showConfirm(msgContent.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm"));
                } else if (all) {
                    this.getView().invokeOperation("submit");
                }
            } else {
                String selectFileds = "biztype,entryentity,entryentity.note,entryentity.seq,aptitudeno,entryentity.category,entryentity.categorystatus,entryentity.sampleno,entryentity.testresult,entryentity.tryno,entryentity.tryresult";
                DynamicObjectCollection selectedBillDyo = QueryServiceHelper.query((String)"srm_supapprove", (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
                Boolean issample = ((DynamicObject)selectedBillDyo.get(0)).getBoolean("aptitudeno.issample");
                Boolean ismaterial = ((DynamicObject)selectedBillDyo.get(0)).getBoolean("aptitudeno.ismaterial");
                Boolean complentedissample = ((DynamicObject)selectedBillDyo.get(0)).getBoolean("aptitudeno.hassample");
                Boolean complentedmaterial = ((DynamicObject)selectedBillDyo.get(0)).getBoolean("aptitudeno.hasmaterial");
                boolean ok = true;
                StringBuilder msg = new StringBuilder();
                if (issample.booleanValue() && !complentedissample.booleanValue()) {
                    ok = false;
                    msg.append(ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u9700\u8981\u6837\u54c1\u786e\u8ba4\uff0c\u4f46\u672a\u5b8c\u6210\u3002", (String)"SrmSupApproveList_5", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                }
                if (ismaterial.booleanValue() && !complentedmaterial.booleanValue()) {
                    ok = false;
                    msg.append(ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u9700\u8981\u7269\u6599\u8bd5\u7528\uff0c\u4f46\u672a\u5b8c\u6210\u3002", (String)"SrmSupApproveList_6", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                }
                if (!ok) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(msg.toString());
                    return;
                }
                this.getView().invokeOperation("submit");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResultValue().equals("Yes")) {
            super.confirmCallBack(event);
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            SrmMultiTimesSupApproveService iSrmMultiTimesSupApproveService = new SrmMultiTimesSupApproveService();
            iSrmMultiTimesSupApproveService.deleteNotApproveRowEntryData(Long.valueOf(billId));
            this.getView().invokeOperation("submit");
        }
    }

    private List<String> getColumnList() {
        ArrayList<String> columnList = new ArrayList<String>(4);
        columnList.add("aptitudeno.hasscene");
        columnList.add("aptitudeno.hassample");
        columnList.add("aptitudeno.hasmaterial");
        columnList.add("aptitudeno.hasapprove");
        return columnList;
    }
}

