/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierChangeValidator;

public class SrmSupChangeList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        ArrayList<String> billStatusList = new ArrayList<String>();
        billStatusList.add(BillStatusEnum.AUDIT.getVal());
        billStatusList.add(BillStatusEnum.CLOSED.getVal());
        billStatusList.add(BillStatusEnum.CANCELED.getVal());
        qFilterList.add(new QFilter("origin", "=", (Object)"2").or(new QFilter("origin", "=", (Object)"1").and(new QFilter("billstatus", "in", billStatusList))));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        long billId;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("chgeffect".equals(opKey)) {
            billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            if (billId == 0L) {
                return;
            }
            DynamicObject obj = QueryRecordUtil.queryRecordSet((String)"srm_supchange", (String)"billstatus,cfmStatus", (String)"id", (Object)billId, null, null, null, null, null, null, null, (String)"queryOne", null);
            if (obj == null) {
                return;
            }
            if (!obj.getString("billstatus").equals(BillStatusEnum.AUDIT.getVal()) || !obj.getString("cfmstatus").equals(ConfirmStatusEnum.UNCONFIRM.getVal())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838, \u751f\u6548\u72b6\u6001\u4e3a\u5f85\u5904\u7406\u7684\u53d8\u66f4\u5355\u624d\u80fd\u8fdb\u884c\u751f\u6548\u5904\u7406\u3002", (String)"SrmSupChangeList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("billid", String.valueOf(billId));
            this.confirm();
        }
        if ("quickchange".equals(opKey)) {
            billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            if (billId == 0L) {
                return;
            }
            SupplierChangeValidator.Message message = SupplierChangeValidator.validQuickChange((IFormView)this.getView(), (Object)billId, (String)"srm_supchange");
            if (!message.getResult().booleanValue()) {
                return;
            }
            long supplierId = message.getSupplierId();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("supchange_id", billId);
            DynamicObject query = QueryServiceHelper.queryOne((String)"srm_supchange", (String)"billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
            String billstatus = query.getString("billstatus");
            if ("A".equals(billstatus)) {
                paramMap.put("supchange_billno", query.get("billno"));
            }
            OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"srm_supplierchg", (Object)supplierId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paramMap, null);
        }
    }

    public void confirm() {
        OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_supchgcfm", (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            Map paramMap = (Map)closedCallBackEvent.getReturnData();
            if (paramMap != null && "confirm".equals(paramMap.get("opKey"))) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("opinion", (String)paramMap.get("opinion"));
                if ("B".equals(paramMap.get("result"))) {
                    this.getView().invokeOperation("cfgcfmagree", operateOption);
                } else {
                    this.getView().invokeOperation("cfgcfmunagree", operateOption);
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

