/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.FeatureCheckUtil;

public class SrmSupplierRegList
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = FeatureCheckUtil.checkSRMFeatureByVersion((String)"XV1IC150UR4", (String)"srm_supplierreg", (Long)RequestContext.get().getCurrUserId(), (String)"7.0");
        if (checkResult != null && !checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String listFieldKey = args.getListFieldKey();
        if ("auditstatus".equals(listFieldKey)) {
            List comboItems = args.getComboItems();
            Iterator iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                ValueMapItem next = (ValueMapItem)iterator.next();
                String value = next.getValue();
                if (!this.getHideAuditstatusValue().contains(value)) continue;
                iterator.remove();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals("tblaudit") || key.equals("tblunsubmit") || key.equals("tblreject")) {
            StringBuilder msg;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            ArrayList<Long> billIdList = new ArrayList<Long>(16);
            for (int i = 0; i < primaryKeyValues.length; ++i) {
                billIdList.add(Long.parseLong(primaryKeyValues[i].toString()));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"srm_supplierreg", (String)"executeresult", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdList)});
            boolean flag = false;
            for (DynamicObject dyo : query) {
                String executeresult = dyo.getString("executeresult");
                if (!StringUtils.isBlank((CharSequence)executeresult) && (executeresult.equals("2") || executeresult.equals("3"))) continue;
                flag = true;
                break;
            }
            if (query.isEmpty()) {
                evt.setCancel(true);
                msg = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SrmSupplierRegList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(msg.toString());
                return;
            }
            if (!flag) {
                evt.setCancel(true);
                msg = new StringBuilder(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u65e0\u6cd5\u6267\u884c\u3002", (String)"SrmSupplierRegList_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                if (key.equals("tblaudit")) {
                    msg.append(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"SrmSupplierRegList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                } else if (key.equals("tblunsubmit")) {
                    msg.append(ResManager.loadKDString((String)"\u9000\u56de\u4fee\u6539", (String)"SrmSupplierRegList_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                } else if (key.equals("tblreject")) {
                    msg.append(ResManager.loadKDString((String)"\u9a73\u56de\u7ec8\u6b62", (String)"SrmSupplierRegList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                }
                msg.append(ResManager.loadKDString((String)"\u64cd\u4f5c\uff0c\u8bf7\u70b9\u51fb\u5217\u8868\u6267\u884c\u7ed3\u679c\u67e5\u770b\u6267\u884c\u8be6\u60c5\uff0c\u89e3\u51b3\u5f02\u5e38\u540e\u91cd\u8bd5\u3002", (String)"SrmSupplierRegList_6", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(msg.toString());
                return;
            }
        }
    }

    protected List<String> getHideAuditstatusValue() {
        ArrayList<String> values = new ArrayList<String>(16);
        values.add("G");
        values.add("H");
        values.add("I");
        values.add("J");
        values.add("K");
        values.add("L");
        return values;
    }
}

