/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.CommonUtil;

public class SrmEvaPlanBatchEndOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("cfmopinion");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"confirm")) {
            DynamicObject[] objs = e.getDataEntities();
            HashMap<String, String> taskMap = new HashMap<String, String>((int)((double)objs.length / 0.75));
            for (DynamicObject obj : objs) {
                String taskbillId = obj.getString("id");
                String termanition = obj.getString("cfmopinion");
                taskMap.put(taskbillId, termanition);
            }
            this.endAllScoreStatus(taskMap);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            SaveServiceHelper.saveOperate((String)"srm_evaplanbatch_end", (DynamicObject[])objs, (OperateOption)option);
        }
    }

    private void endAllScoreStatus(Map<String, String> taskMap) {
        QFilter qFilter = new QFilter("taskbillid", "in", (Object)taskMap.keySet().stream().mapToLong(info -> CommonUtil.parseLong((String)String.valueOf(info))).toArray());
        QFilter scoreObjs = BusinessDataServiceHelper.load((String)"srm_score", (String)"taskbillid,bizstatus,cfmstatus,terminater,terminatedate,termination", (QFilter[])new QFilter[]{qFilter});
        if (scoreObjs == null || ((DynamicObject[])scoreObjs).length == 0) {
            QFilter filter = new QFilter("id", "in", (Object)taskMap.keySet().stream().mapToLong(info -> CommonUtil.parseLong((String)String.valueOf(info))).toArray());
            DynamicObject srm_evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan_batch", (String)"id,groupevaplanno", (QFilter[])new QFilter[]{filter});
            Long groupevaplanno = srm_evaplan.getLong("groupevaplanno");
            if (groupevaplanno != null && groupevaplanno != 0L) {
                this.writeBackGroupEvaPlanCalStatus(groupevaplanno);
            }
            return;
        }
        for (DynamicObject scoreObj : scoreObjs) {
            String taskbillId = scoreObj.getString("taskbillid");
            scoreObj.set("bizstatus", (Object)SrmScoreStatusEnum.ENDED);
            scoreObj.set("cfmstatus", (Object)SrmScoreStatusEnum.ENDED.getValue());
            scoreObj.set("terminater", (Object)RequestContext.get().getUserId());
            scoreObj.set("terminatedate", (Object)TimeServiceHelper.now());
            scoreObj.set("termination", (Object)taskMap.get(taskbillId));
        }
        SaveServiceHelper.save((DynamicObject[])scoreObjs);
        QFilter filter = new QFilter("id", "in", (Object)taskMap.keySet().stream().mapToLong(info -> CommonUtil.parseLong((String)String.valueOf(info))).toArray());
        DynamicObject srm_evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan_batch", (String)"id,groupevaplanno", (QFilter[])new QFilter[]{filter});
        Long groupevaplanno = srm_evaplan.getLong("groupevaplanno");
        if (groupevaplanno != null && groupevaplanno != 0L) {
            this.writeBackGroupEvaPlanCalStatus(groupevaplanno);
        }
    }

    private void writeBackGroupEvaPlanCalStatus(long groupevaplanno) {
        DynamicObjectCollection srm_evaplan = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"id,bizstatus,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("groupevaplanno", "=", (Object)groupevaplanno)});
        HashSet<Long> evaplanIds = new HashSet<Long>(16);
        boolean wb = true;
        for (DynamicObject evaplan : srm_evaplan) {
            String bizstatus = evaplan.getString("bizstatus");
            if ("A".equals(bizstatus) || "B".equals(bizstatus)) {
                wb = false;
            }
            long evaplanId = evaplan.getLong("id");
            evaplanIds.add(evaplanId);
        }
        DynamicObjectCollection srm_scorerpt = QueryServiceHelper.query((String)"srm_scorerpt", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("taskbillid", "in", evaplanIds)});
        boolean bizstatusEqualsG = false;
        for (DynamicObject scorerpt : srm_scorerpt) {
            String bizstatus = scorerpt.getString("bizstatus");
            if (!"G".equals(bizstatus) && !"Z".equals(bizstatus)) {
                wb = false;
                break;
            }
            if (!"G".equals(bizstatus)) continue;
            bizstatusEqualsG = true;
        }
        if (wb && bizstatusEqualsG) {
            DynamicObject groupevaplan = BusinessDataServiceHelper.loadSingle((String)"srm_groupevaplan", (String)"id,billno,billstatus,cansumcalculate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupevaplanno)});
            groupevaplan.set("cansumcalculate", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{groupevaplan});
        }
    }
}

