/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.srm.common.formula.SrmAutoFormulaResp;
import kd.scm.srm.opplugin.validator.SrmEvaplanPushValidtor;
import kd.scm.srm.service.SrmAutoScoreService;

public class SrmEvaplanAutomaticOp
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    SrmAutoScoreService srmAutoScoreService = new SrmAutoScoreService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("scheme");
        fieldKeys.add("scheme.entryentity");
        fieldKeys.add("org");
        fieldKeys.add("entryentity.supplier");
        fieldKeys.add("evamethod");
        fieldKeys.add("datetimeto");
        fieldKeys.add("datetimefrom");
        fieldKeys.add("datefrom");
        fieldKeys.add("dateto");
        fieldKeys.add("billstatus");
        fieldKeys.add("bizstatus");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        final DynamicObject[] dataEntities = e.getDataEntities();
        final ArrayList<Long> ids = new ArrayList<Long>(1);
        for (DynamicObject dataEntity : dataEntities) {
            ids.add(dataEntity.getLong("id"));
        }
        if (ids.size() == 0) {
            return;
        }
        if (ids.size() != 1) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bc4\u4f30\u8ba1\u5212\u3002", (String)"SrmEvaplanAutomaticOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaplanAutomaticOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        }
        List<Object> autoIndex = new ArrayList(10);
        String billName = dataEntities[0].getDynamicObjectType().getName();
        if ("srm_evaplan".equals(billName)) {
            DynamicObjectCollection indexDetails = QueryServiceHelper.query((String)"srm_evaplan_detail", (String)"billid,index,index.scoretype", (QFilter[])new QFilter[]{new QFilter("billid", "=", ids.get(0))});
            autoIndex = indexDetails.stream().filter(x -> "9".equals(x.getString("index.scoretype"))).map(x -> x.getLong("index")).collect(Collectors.toList());
        } else if ("srm_evaplan_batch".equals(billName)) {
            DynamicObjectCollection srm_evaplan_batch = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"id,entryentity.scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", ids.get(0))});
            HashSet<Long> schemeIdSet = new HashSet<Long>(16);
            for (DynamicObject evaplanBatchRow : srm_evaplan_batch) {
                long schemeId = evaplanBatchRow.getLong("entryentity.scheme");
                schemeIdSet.add(schemeId);
            }
            DynamicObjectCollection srm_scheme = QueryServiceHelper.query((String)"srm_scheme", (String)"entryentity.index,entryentity.index.scoretype", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIdSet)});
            for (DynamicObject schemeRow : srm_scheme) {
                long indexId = schemeRow.getLong("entryentity.index");
                String indexScoretype = schemeRow.getString("entryentity.index.scoretype");
                if (!"9".equals(indexScoretype)) continue;
                autoIndex.add(indexId);
            }
        }
        if (CollectionUtils.isEmpty(autoIndex)) {
            this.log.info("SrmEvaplanAutomaticOp autoIndex is null");
            return;
        }
        final DynamicObjectCollection scores = this.srmAutoScoreService.queryScoreByAutoIndex((Long)ids.get(0), autoIndex);
        ThreadPools.executeOnce((String)"SrmScoreRptRemarkOp_AutoScore", (Runnable)new Runnable(){

            @Override
            public void run() {
                SrmAutoFormulaResp srmAutoFormulaResp = SrmEvaplanAutomaticOp.this.srmAutoScoreService.pushAutoscoreTask(dataEntities[0], (List)scores);
                if (Objects.nonNull(srmAutoFormulaResp) && !srmAutoFormulaResp.getSuccess().booleanValue()) {
                    DynamicObjectCollection socres = QueryServiceHelper.query((String)"srm_score", (String)"id", (QFilter[])new QFilter[]{new QFilter("taskbillid", "=", ids.get(0))});
                    if (!CollectionUtils.isEmpty((Collection)scores)) {
                        OperateOption operateOption = OperateOption.create();
                        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
                        operateOption.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
                        Object[] scoreIds = socres.stream().map(x -> x.getLong("id")).toArray();
                        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"srm_score", (Object[])scoreIds, (OperateOption)operateOption);
                        if (unaudit.isSuccess()) {
                            OperationResult delete = OperationServiceHelper.executeOperate((String)"delete", (String)"srm_score", (Object[])scoreIds, (OperateOption)operateOption);
                            if (!delete.isSuccess()) {
                                SrmEvaplanAutomaticOp.this.log.info("SrmEvaplanAutomaticOp delete score is fail :" + delete.getAllErrorOrValidateInfo());
                            }
                        } else {
                            SrmEvaplanAutomaticOp.this.log.info("SrmEvaplanAutomaticOp unaudit score is fail :" + unaudit.getAllErrorOrValidateInfo());
                        }
                    }
                    throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u81ea\u52a8\u8bc4\u4f30\u6307\u6807\u4e0b\u53d1\u5931\u8d25\uff1a%1", (String)"SrmEvaplanAutomaticOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaplanAutomaticOp_1", (String)"scm-srm-opplugin", (Object[])new Object[]{srmAutoFormulaResp.getMessage()}));
                }
            }
        });
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmEvaplanPushValidtor());
    }
}

