/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;

public final class SrmGroupEvaPlanEndOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("cfmopinion");
        fieldKeys.add("terminater");
        fieldKeys.add("terminatedate");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"reject")) {
            DynamicObject[] objs;
            for (DynamicObject obj : objs = e.getDataEntities()) {
                long groupPlanId = obj.getLong("id");
                String termination = obj.getString("cfmopinion");
                this.endAllScoreStatus(groupPlanId, termination);
                obj.set("terminater", (Object)RequestContext.get().getCurrUserId());
                obj.set("terminatedate", (Object)TimeServiceHelper.now());
                obj.set("cfmopinion", (Object)termination);
            }
            SaveServiceHelper.save((DynamicObject[])objs);
        }
    }

    private void endAllScoreStatus(Long groupEvaId, String termination) {
        QFilter qFilter = new QFilter("groupevaplanno.id", "=", (Object)groupEvaId);
        DynamicObject[] evaPlans = BusinessDataServiceHelper.load((String)"srm_evaplan", (String)"id,billno,billstatus,bizstatus,cfmstatus,terminater,terminatedate,termination", (QFilter[])new QFilter[]{qFilter});
        if (evaPlans == null || evaPlans.length == 0) {
            evaPlans = BusinessDataServiceHelper.load((String)"srm_evaplan_batch", (String)"id,billno,billstatus,bizstatus,cfmstatus,terminater,terminatedate,termination", (QFilter[])new QFilter[]{qFilter});
        }
        if (evaPlans == null || evaPlans.length == 0) {
            return;
        }
        HashSet<Long> evaPlanIdSet = new HashSet<Long>(16);
        for (DynamicObject evaPlan : evaPlans) {
            evaPlan.set("bizstatus", (Object)"Z");
            evaPlan.set("terminater", (Object)RequestContext.get().getCurrUserId());
            evaPlan.set("terminatedate", (Object)TimeServiceHelper.now());
            evaPlan.set("termination", (Object)termination);
            long id = evaPlan.getLong("id");
            evaPlanIdSet.add(id);
        }
        DynamicObject[] evaTask = BusinessDataServiceHelper.load((String)"srm_score", (String)"id,billno,billstatus,bizstatus,cfmstatus,terminater,terminatedate,termination", (QFilter[])new QFilter[]{new QFilter("taskbillid", "in", evaPlanIdSet)});
        this.endAllScoreStatus(evaTask, termination);
        SaveServiceHelper.save((DynamicObject[])evaPlans);
    }

    private void endAllScoreStatus(DynamicObject[] scoreObjs, String termination) {
        for (DynamicObject scoreObj : scoreObjs) {
            scoreObj.set("bizstatus", (Object)SrmScoreStatusEnum.ENDED);
            scoreObj.set("cfmstatus", (Object)SrmScoreStatusEnum.ENDED.getValue());
            scoreObj.set("terminater", (Object)RequestContext.get().getCurrUserId());
            scoreObj.set("terminatedate", (Object)TimeServiceHelper.now());
            scoreObj.set("termination", (Object)termination);
        }
        SaveServiceHelper.save((DynamicObject[])scoreObjs);
    }
}

