/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.srm.opplugin.validator.SrmScoreAutomaticValidator;
import kd.scm.srm.service.SrmAutoScoreService;

public class SrmScoreAutomaticOp
extends AbstractOperationServicePlugIn {
    SrmAutoScoreService srmAutoScoreService = new SrmAutoScoreService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("scheme");
        fieldKeys.add("scheme.entryentity");
        fieldKeys.add("org");
        fieldKeys.add("datetimeto");
        fieldKeys.add("datetimefrom");
        fieldKeys.add("entry");
        fieldKeys.add("entry.index");
        fieldKeys.add("entry.index.scoretype");
        fieldKeys.add("taskbillid");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<Long, List<DynamicObject>> taskbillidMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(x -> x.getLong("taskbillid")));
        if (Objects.isNull(taskbillidMap)) {
            return;
        }
        if (taskbillidMap.size() > 1) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u8bc4\u4f30\u8ba1\u5212\u7684\u4efb\u52a1\u91cd\u65b0\u81ea\u52a8\u8bc4\u5206\u3002", (String)"SrmScoreAutomaticOp_4", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmScoreAutomaticOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        }
        long taskbillid = dataEntities[0].getLong("taskbillid");
        DynamicObjectCollection indexs = dataEntities[0].getDynamicObjectCollection("entry");
        List autoIndexs = indexs.stream().filter(x -> "9".equals(x.getString("index.scoretype"))).map(x -> x.getLong("index.id")).collect(Collectors.toList());
        List taskIds = Arrays.stream(dataEntities).map(x -> x.getLong("id")).collect(Collectors.toList());
        DynamicObject evaplanDy = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)"id,datefrom,dateto,evamethod,datetimeto,datetimefrom,org.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        if (Objects.isNull(evaplanDy)) {
            evaplanDy = QueryServiceHelper.queryOne((String)"srm_evaplan_batch", (String)"id,datefrom,dateto,evamethod,org.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        }
        if (Objects.isNull(evaplanDy)) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u4efb\u52a1\u5173\u8054\u8bc4\u4f30\u8ba1\u5212\u4e3a\u7a7a", (String)"SrmScoreAutomaticOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmScoreAutomaticOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        }
        QFilter indexFilter = new QFilter("entry.index", "in", autoIndexs);
        DynamicObjectCollection scores = QueryServiceHelper.query((String)"srm_score", (String)"id,entry.index.id entryid,entry.subentry.id detailid,entry.index.formulaid formulaid,material,supplier,category", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds), indexFilter});
        if (CollectionUtils.isEmpty((Collection)scores)) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u4efb\u52a1\u4e2d\u81ea\u52a8\u8bc4\u4f30\u6307\u6807\u4e3a\u7a7a\u3002", (String)"SrmScoreAutomaticOp_5", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmScoreAutomaticOp_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        }
        this.srmAutoScoreService.pushAutoTask(evaplanDy, (List)scores);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmScoreAutomaticValidator());
    }
}

