/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.BizLog;
import kd.bos.servicehelper.DispatchServiceHelper;

public class SrmScorerptSynSupGradeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("datetimefrom");
        e.getFieldKeys().add("datetimeto");
        e.getFieldKeys().add("auditgrade");
        e.getFieldKeys().add("category");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("scheme");
        e.getFieldKeys().add("id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList supplierGradeModels = new ArrayList();
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject scheme = dataEntity.getDynamicObject("scheme");
            if (Objects.isNull(scheme) || !scheme.getBoolean("synsupgrade")) continue;
            HashMap<String, Object> supplierGradeModel = new HashMap<String, Object>(12);
            ids.add(dataEntity.getLong("id"));
            long category = dataEntity.getLong("category.id");
            long supplier = dataEntity.getLong("supplier.id");
            long org = dataEntity.getLong("org.id");
            long calgrade = dataEntity.getLong("auditgrade.id");
            Date datetimefrom = dataEntity.getDate("datetimefrom");
            Date datetimeto = dataEntity.getDate("datetimeto");
            String billno = dataEntity.getString("billno");
            supplierGradeModel.put("sourcetype", "B");
            supplierGradeModel.put("source", billno);
            supplierGradeModel.put("category_id", category);
            supplierGradeModel.put("bdsupplier_id", supplier);
            supplierGradeModel.put("createorg_id", org);
            supplierGradeModel.put("useorg_id", org);
            supplierGradeModel.put("evagrade_id", calgrade);
            supplierGradeModel.put("datetimefrom", datetimefrom);
            supplierGradeModel.put("datetimeto", datetimeto);
            supplierGradeModels.add(supplierGradeModel);
        }
        if (supplierGradeModels.size() > 0) {
            if (ECServiceSwitch.isOpened()) {
                CommonParam commonParam = new CommonParam();
                commonParam.put((Object)"businesskeys", ids);
                ECServiceHelper.execute((String)"srm_supgrade_syn", (String)" bd_suppliergrade_syn", (String)"scm", (String)"srm", (String)"SupplierGradeService", (Param)commonParam);
            } else {
                HashMap result = (HashMap)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"PbdSupplierGradeService", (String)"synchroSupplierGrade", (Object[])new Object[]{supplierGradeModels});
                if (!((Boolean)result.get("success")).booleanValue() && Objects.nonNull(result.get("message"))) {
                    BizLog.log((String)("SrmScorerptSynSupGradeOp" + result.get("message").toString()));
                }
            }
        } else {
            BizLog.log((String)"SrmScorerptSynSupGradeOp  supplierGradeModels is null");
        }
    }
}

