/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmCategoryEnum;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.BOTPUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;

public class SrmSupcategoryImport
implements IImportPlugin {
    private static Log log = LogFactory.getLog(SrmSupcategoryImport.class);

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        Map<Object, Object> resultMap = new HashMap();
        String supplierName = null;
        String orgName = null;
        String categoryNumber = null;
        String materielNumber = null;
        String categorytype = null;
        boolean issourcelist = false;
        long supplierId = 0L;
        long bizpartnerId = 0L;
        long groupId = 0L;
        long orgId = 0L;
        long categoryId = 0L;
        long materielId = 0L;
        Object effectdate = data.get("effectdate");
        Object expirydate = data.get("expirydate");
        supplierName = SrmCommonUtil.getImportDataValue(data, (String)"supplier", (String)"name");
        orgName = SrmCommonUtil.getImportDataValue(data, (String)"org", (String)"name");
        categoryNumber = SrmCommonUtil.getImportDataValue(data, (String)"category", (String)"number");
        Boolean checkCategorytype = this.checkCategorytype(data, importlogs, categoryNumber, materielNumber = SrmCommonUtil.getImportDataValue(data, (String)"material", (String)"number"));
        if (!checkCategorytype.booleanValue()) {
            return false;
        }
        Boolean issourcelistFlag = this.checkIssourcelist(data, importlogs);
        if (!issourcelistFlag.booleanValue()) {
            return false;
        }
        categorytype = (String)data.get("categorytype");
        issourcelist = (Boolean)data.get("issourcelist");
        DynamicObject formalSupObj = QueryRecordUtil.queryRecordSet((String)"bd_supplier", (String)"id,group,bizpartner", (String)"name", (Object)supplierName, null, null, null, null, null, null, null, (String)"loadOne", null);
        resultMap = this.checkSupplier(supplierName, formalSupObj, importlogs);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            return false;
        }
        if (Objects.nonNull(formalSupObj)) {
            groupId = SrmCommonUtil.getPkValue((DynamicObject)formalSupObj.getDynamicObject("group"));
            bizpartnerId = SrmCommonUtil.getPkValue((DynamicObject)formalSupObj.getDynamicObject("bizpartner"));
        }
        if (!((Boolean)(resultMap = this.checkRegSupplier(supplierName, formalSupObj, importlogs)).get("succed")).booleanValue()) {
            return false;
        }
        supplierId = (Long)resultMap.get("supplier");
        resultMap = this.checkOrg(orgName, importlogs);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            return false;
        }
        orgId = (Long)resultMap.get("org");
        if ("B".equals(categorytype)) {
            resultMap = this.checkCategory(categoryNumber, importlogs, orgId);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                return false;
            }
            categoryId = (Long)resultMap.get("category");
        }
        if ("A".equals(categorytype)) {
            resultMap = this.checkMaterial(materielNumber, importlogs);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                return false;
            }
            materielId = (Long)resultMap.get("material_id");
            categoryId = (Long)resultMap.get("category");
            categoryNumber = (String)resultMap.get("category_number");
        }
        QFilter filter = new QFilter("supplier", "=", (Object)supplierId).and("org", "=", (Object)orgId).and("category", "=", (Object)categoryId).and("material", "=", (Object)materielId).and("auditstatus", "=", (Object)"1");
        DynamicObjectCollection supCategoryLib = QueryServiceHelper.query((String)"srm_supcategory", (String)"id,effectdate,expirydate,auditstatus", (QFilter[])new QFilter[]{filter});
        if (!this.checkDate(effectdate, expirydate, importlogs, supCategoryLib, categorytype).booleanValue()) {
            return false;
        }
        data.put("supplier_id", supplierId);
        data.put("group_id", groupId);
        data.put("bizpartner_id", bizpartnerId);
        data.put("org_id", orgId);
        data.put("category_id", categoryId);
        data.put("auditstatus", SrmCategoryEnum.VALID.getVal());
        data.put("modifier_id", RequestContext.get().getUserId());
        data.put("modifytime", TimeServiceHelper.now());
        data.put("createorg_id", orgId);
        data.put("origin", "2");
        if ("A".equals(categorytype)) {
            data.put("material_id", materielId);
            data.put("category", null);
        } else {
            data.put("material", null);
        }
        data.put("categorytype", categorytype);
        data.put("issourcelist", issourcelist);
        return true;
    }

    private Map<String, Object> checkSupplier(String supplierName, DynamicObject formalSupObj, List<ImportLogger.ImportLog> importlogs) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (formalSupObj == null) {
            resultMap.put("succed", Boolean.FALSE);
            importlogs.add(new ImportLogger.ImportLog(supplierName, ResManager.loadKDString((String)"\u5728\u6b63\u5f0f\u4f9b\u5e94\u5546\u6863\u6848\u4e2d\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5f15\u5165\u3002", (String)"SrmSupcategoryImport_1", (String)"scm-srm-opplugin", (Object[])new Object[0])));
        } else {
            resultMap.put("succed", Boolean.TRUE);
        }
        return resultMap;
    }

    private Map<String, Object> checkRegSupplier(String supplierName, DynamicObject formalSupObj, List<ImportLogger.ImportLog> importlogs) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject tempObj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"id", (String)"name", (Object)supplierName, null, null, null, null, null, null, null, (String)"queryOne", null);
        if (tempObj != null) {
            resultMap.put("succed", Boolean.TRUE);
            resultMap.put("supplier", tempObj.getLong("id"));
            return resultMap;
        }
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        defaultValue.put("enable", "1");
        defaultValue.put("status", BillStatusEnum.AUDIT.getVal());
        defaultValue.put("auditstatus", SrmSupplierStatusEnum.SUCCESS.getValue());
        defaultValue.put("auditor", RequestContext.get().getUserId());
        defaultValue.put("auditdate", TimeServiceHelper.now());
        resultMap = BOTPUtil.pushBill((String)"bd_supplier", (String)"srm_supplier", (DynamicObject)formalSupObj, defaultValue);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            resultMap.put("succed", Boolean.FALSE);
            importlogs.add(new ImportLogger.ImportLog(supplierName, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u521b\u5efa\u6ce8\u518c\u4f9b\u5e94\u5546\u5931\u8d25\uff0c\u4e0d\u80fd\u5f15\u5165\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1 \n", (String)"SrmSupcategoryImport_2", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmSupcategoryImport_2", (String)"scm-srm-opplugin", (Object[])new Object[]{resultMap.get("message")})));
        } else {
            resultMap.put("succed", Boolean.TRUE);
            resultMap.put("supplier", resultMap.get("billid"));
        }
        return resultMap;
    }

    private Map<String, Object> checkOrg(String orgName, List<ImportLogger.ImportLog> importlogs) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (!((Boolean)paraMap.get("ispurorg")).booleanValue()) {
            resultMap.put("succed", Boolean.TRUE);
            resultMap.put("org", 0L);
            return resultMap;
        }
        DynamicObject tempObj = QueryRecordUtil.queryRecordSet((String)"bos_org", (String)"id,name", (String)"name", (Object)orgName, null, null, null, null, null, null, null, (String)"queryOne", null);
        if (tempObj == null) {
            resultMap.put("succed", Boolean.FALSE);
            importlogs.add(new ImportLogger.ImportLog(orgName, ResManager.loadKDString((String)"\u5728\u4e1a\u52a1\u5355\u5143\u4e2d\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5f15\u5165\u3002", (String)"SrmSupcategoryImport_3", (String)"scm-srm-opplugin", (Object[])new Object[0])));
        } else {
            List orgsList = OrgUtil.getAllPurViewPermissionOrgs((String)"srm_supcategory");
            if (!orgsList.contains(tempObj.getLong("id"))) {
                resultMap.put("succed", Boolean.FALSE);
                importlogs.add(new ImportLogger.ImportLog(orgName, ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u6743\u9650\uff0c\u4e0d\u80fd\u5f15\u5165\u3002", (String)"SrmSupcategoryImport_5", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            } else if (1 != PermissionServiceHelper.checkPermission((Long)Long.valueOf(RequestContext.get().getUserId()), (Long)tempObj.getLong("id"), (String)"XV1IC150UR4", (String)"srm_supcategory", (String)"03LYLVS5Y7JT")) {
                resultMap.put("succed", Boolean.FALSE);
                importlogs.add(new ImportLogger.ImportLog(orgName, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u672a\u5206\u914d\u8be5\u7ec4\u7ec7\u7684\u5f15\u5165\u6743\u9650\u3002", (String)"SrmSupcategoryImport_6", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            } else {
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("org", tempObj.getLong("id"));
            }
        }
        return resultMap;
    }

    private Map<String, Object> checkCategory(String categoryNumber, List<ImportLogger.ImportLog> importlogs, long orgId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (!((Boolean)paraMap.get("iscategory")).booleanValue()) {
            resultMap.put("succed", Boolean.TRUE);
            resultMap.put("category", 0L);
            return resultMap;
        }
        DynamicObject tempObj = QueryRecordUtil.queryRecordSet((String)"bd_materialgroup", (String)"id,createorg", (String)"number", (Object)categoryNumber, (String)"standard.number", (Object)"JBFLBZ", null, null, null, null, null, (String)"queryOne", null);
        if (tempObj == null) {
            resultMap.put("succed", Boolean.FALSE);
            importlogs.add(new ImportLogger.ImportLog(categoryNumber, ResManager.loadKDString((String)"\u5728\u57fa\u672c\u5206\u7c7b\u6807\u51c6\u4e0b\u7269\u6599\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5f15\u5165\u3002", (String)"SrmSupcategoryImport_22", (String)"scm-srm-opplugin", (Object[])new Object[0])));
        } else {
            long createorg = tempObj.getLong("createorg");
            if (createorg == orgId) {
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("category", tempObj.getLong("id"));
            } else {
                boolean isParentOrg = OrgUnitServiceHelper.isParentOrg((String)"15", (long)createorg, (long)orgId);
                if (!isParentOrg) {
                    resultMap.put("succed", Boolean.FALSE);
                    importlogs.add(new ImportLogger.ImportLog(categoryNumber, ResManager.loadKDString((String)"\u5f15\u5165\u7ec4\u7ec7\u4e0d\u662f\u54c1\u7c7b\u521b\u5efa\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5f15\u5165\u3002", (String)"SrmSupcategoryImport_11", (String)"scm-srm-opplugin", (Object[])new Object[0])));
                } else {
                    resultMap.put("succed", Boolean.TRUE);
                    resultMap.put("category", tempObj.getLong("id"));
                }
            }
        }
        return resultMap;
    }

    private Map<String, Object> checkMaterial(String materialNumber, List<ImportLogger.ImportLog> importlogs) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (!((Boolean)paraMap.get("iscategory")).booleanValue()) {
            resultMap.put("succed", Boolean.TRUE);
            resultMap.put("category", 0L);
            resultMap.put("material_id", 0L);
            return resultMap;
        }
        DynamicObject tempObj = QueryRecordUtil.queryRecordSet((String)"bd_material", (String)"id", (String)"number", (Object)materialNumber, null, null, null, null, null, null, null, (String)"queryOne", null);
        if (tempObj == null) {
            resultMap.put("succed", Boolean.FALSE);
            importlogs.add(new ImportLogger.ImportLog(materialNumber, ResManager.loadKDString((String)"\u5728\u7269\u6599\u4e2d\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5f15\u5165\u3002", (String)"SrmSupcategoryImport_9", (String)"scm-srm-opplugin", (Object[])new Object[0])));
        } else {
            DynamicObject materialgroupdetail = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"id,group.id,group.number", (QFilter[])new QFilter[]{new QFilter("material.id", "=", (Object)tempObj.getLong("id")).and(new QFilter("standard.number", "=", (Object)"JBFLBZ"))});
            if (Objects.nonNull(materialgroupdetail)) {
                long groupId = materialgroupdetail.getLong("group.id");
                String groupNumber = materialgroupdetail.getString("group.number");
                resultMap.put("category", groupId);
                resultMap.put("category_number", groupNumber);
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("material_id", tempObj.getLong("id"));
            } else {
                resultMap.put("succed", Boolean.FALSE);
                importlogs.add(new ImportLogger.ImportLog(materialNumber, ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u5728\u57fa\u672c\u5206\u7c7b\u6807\u51c6\u4e0b\uff0c\u4e0d\u80fd\u5f15\u5165\u3002", (String)"SrmSupcategoryImport_10", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            }
        }
        return resultMap;
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"supplier.group,supplier.bizpartner,org,group,modifier,createorg,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        if (null != dyos && dyos.length > 0) {
            for (DynamicObject dyo : dyos) {
                DynamicObject bizpartner;
                DynamicObject org = dyo.getDynamicObject("org");
                if (null != org) {
                    dyo.set("createorg_id", org.getPkValue());
                }
                dyo.set("modifier_id", (Object)RequestContext.get().getUserId());
                DynamicObject group = dyo.getDynamicObject("supplier.group");
                if (null != group) {
                    dyo.set("group_id", group.getPkValue());
                }
                if (null == (bizpartner = dyo.getDynamicObject("supplier.bizpartner"))) continue;
                dyo.set("bizpartner_id", bizpartner.getPkValue());
            }
            SaveServiceHelper.save((DynamicObject[])dyos);
        }
    }

    private Boolean checkCategorytype(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs, String categoryNumber, String materielNumber) {
        Object categorytype = data.get("categorytype");
        if (Objects.isNull(categorytype) || !"A".equals(categorytype) && !"B".equals(categorytype)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6216\u4e0d\u4e3a\"\u7269\u6599\"\u3001\"\u54c1\u7c7b\"\u3002", (String)"SrmSupcategoryImport_7", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return false;
        }
        if ("A".equals(categorytype) && Objects.isNull(materielNumber)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7c7b\u578b\u4e3a\u201c\u7269\u6599\u201d\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmSupcategoryImport_8", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return false;
        }
        if ("B".equals(categorytype) && Objects.isNull(categoryNumber)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7c7b\u578b\u4e3a\u201c\u54c1\u7c7b\u201d\uff0c\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmSupcategoryImport_12", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private Boolean checkIssourcelist(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        if (Objects.isNull(data.get("issourcelist"))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u66f4\u65b0\u8d27\u6e90\u6e05\u5355\u4e3a\u7a7a\u3002", (String)"SrmSupcategoryImport_13", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return false;
        }
        Object issourcelist = data.get("issourcelist");
        if (!(issourcelist instanceof Boolean)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u66f4\u65b0\u8d27\u6e90\u6e05\u5355\u975e\u6cd5\u3002", (String)"SrmSupcategoryImport_15", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private Boolean checkDate(Object effectDate, Object expirydate, List<ImportLogger.ImportLog> importlogs, DynamicObjectCollection supCategoryLib, String categorytype) {
        Boolean result = Boolean.TRUE;
        if (Objects.isNull(effectDate) && Objects.isNull(expirydate)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u751f/\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e5\u671f\u683c\u5f0f\uff1aYYYY-MM-DD\u3002", (String)"SrmSupcategoryImport_14", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return Boolean.FALSE;
        }
        if (Objects.isNull(effectDate)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u751f/\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e5\u671f\u683c\u5f0f\uff1aYYYY-MM-DD\u3002", (String)"SrmSupcategoryImport_14", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return Boolean.FALSE;
        }
        if (Objects.isNull(expirydate)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u751f/\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e5\u671f\u683c\u5f0f\uff1aYYYY-MM-DD\u3002", (String)"SrmSupcategoryImport_14", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return Boolean.FALSE;
        }
        Date effect = null;
        Date expiry = null;
        try {
            effect = DateUtil.string2date((String)effectDate.toString(), (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            log.error("\u751f\u6548\u65e5\u671f\u683c\u5f0f\u5f02\u5e38" + e.getMessage());
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff0c\u65e5\u671f\u683c\u5f0f\u5982\u4e0b\uff1aYYYY-MM-DD\u3002", (String)"SrmSupcategoryImport_16", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            result = Boolean.FALSE;
        }
        try {
            expiry = DateUtil.string2date((String)expirydate.toString(), (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            log.error("\u5931\u6548\u65e5\u671f\u683c\u5f0f\u5f02\u5e38" + e.getMessage());
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff0c\u65e5\u671f\u683c\u5f0f\uff1aYYYY-MM-DD\u3002", (String)"SrmSupcategoryImport_17", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            result = Boolean.FALSE;
        }
        if (!result.booleanValue()) {
            return result;
        }
        if (Objects.isNull(effect)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff0c\u65e5\u671f\u683c\u5f0f\u5982\u4e0b\uff1aYYYY-MM-DD\u3002", (String)"SrmSupcategoryImport_16", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return Boolean.FALSE;
        }
        if (Objects.isNull(expiry)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff0c\u65e5\u671f\u683c\u5f0f\uff1aYYYY-MM-DD\u3002", (String)"SrmSupcategoryImport_17", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return Boolean.FALSE;
        }
        if (effect.compareTo(expiry) >= 0) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"SrmSupcategoryImport_18", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            return Boolean.FALSE;
        }
        for (DynamicObject dynamicObject : supCategoryLib) {
            Date cateExpirydate = dynamicObject.getDate("expirydate");
            Date cateEffectdate = dynamicObject.getDate("effectdate");
            if (Objects.isNull(cateExpirydate) || Objects.isNull(cateEffectdate)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u54c1\u7c7b\u5e93\u4e2d\u5b58\u5728\u4f9b\u5e94\u5546\u540c\u54c1\u7c7b\u540c\u7269\u6599\uff0c\u6709\u6548\u671f\u4e3a\u7a7a\u3002", (String)"SrmSupcategoryImport_19", (String)"scm-srm-opplugin", (Object[])new Object[0])));
                return Boolean.FALSE;
            }
            if (effect.after(cateExpirydate) || expiry.before(cateEffectdate)) continue;
            if ("A".equals(categorytype)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4e0e\u4f9b\u5e94\u5546\u54c1\u7c7b\u5e93\u7684\u4fe1\u606f\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u6216\u8005\u7269\u6599\u7f16\u7801\u3002", (String)"SrmSupcategoryImport_21", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            } else {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4e0e\u4f9b\u5e94\u5546\u54c1\u7c7b\u5e93\u7684\u4fe1\u606f\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u6216\u8005\u54c1\u7c7b\u7f16\u7801\u3002", (String)"SrmSupcategoryImport_20", (String)"scm-srm-opplugin", (Object[])new Object[0])));
            }
            return Boolean.FALSE;
        }
        return result;
    }
}

