/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmAptitudeOpTemplate;
import kd.scm.srm.opplugin.util.FlowNodeServiceUtil;
import kd.scm.srm.service.SrmAptitudeAuditBotpUtil;

public class SrmAptitudeExamAuditOp
extends AbstractOperationServicePlugIn
implements SrmAptitudeOpTemplate {
    private static Log log = LogFactory.getLog(SrmAptitudeExamAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("biztype")) {
            e.getFieldKeys().add("biztype");
        }
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("auditopinion")) {
            e.getFieldKeys().add("auditopinion");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        if (!fieldKeys.contains("group")) {
            e.getFieldKeys().add("group");
        }
        e.getFieldKeys().add("isscene");
        e.getFieldKeys().add("issample");
        e.getFieldKeys().add("ismaterial");
        e.getFieldKeys().add("isapprove");
        e.getFieldKeys().add("examresult");
        e.getFieldKeys().add("isautopush");
        fieldKeys.add("entry_node");
        fieldKeys.add("nodestatus");
        fieldKeys.add("nodebilldate");
        fieldKeys.add("nodebilldate");
        fieldKeys.add("accessnode");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(1024);
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            resultMap.put("succed", Boolean.TRUE);
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT);
            } else {
                e.setCancelMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6838\u5904\u7406\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1", (String)"SrmAptitudeExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmAptitudeExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[]{resultMap.get("message")}));
                e.cancel = true;
            }
            resultMap.clear();
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
            DynamicObject[] Objs = e.getDataEntities();
            HashSet<Long> billIdList = new HashSet<Long>(Objs.length);
            HashSet<Long> dynList = new HashSet<Long>(Objs.length);
            for (DynamicObject obj : Objs) {
                SrmCommonUtil.recordAuditInfo((DynamicObject)obj);
                Object primaryKeyValues = obj.getPkValue();
                if (enableNewAccessFlow) {
                    String examresult = obj.getString("examresult");
                    boolean isautopush = obj.getBoolean("isautopush");
                    if (!"0".equals(examresult)) continue;
                    Long id = (Long)primaryKeyValues;
                    if (isautopush) {
                        billIdList.add(id);
                        continue;
                    }
                    dynList.add(id);
                    continue;
                }
                SrmAptitudeAuditBotpUtil srmAptitudeAuditBotpUtil = new SrmAptitudeAuditBotpUtil();
                srmAptitudeAuditBotpUtil.aptitudePushBill(new Object[]{primaryKeyValues});
            }
            if (!billIdList.isEmpty()) {
                FlowNodeServiceUtil.pushBill(billIdList);
            }
            if (!dynList.isEmpty()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                option.setVariableValue("ishasright", String.valueOf(true));
                OperationServiceHelper.executeOperate((String)"pushbill", (String)"srm_aptitudeexam", (Object[])dynList.toArray(), (OperateOption)option);
            }
        }
    }
}

