/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmCategoryLibUtil;

public class SrmCategoryChgAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("initiator");
        fieldKeys.add("entryentity.material");
        fieldKeys.add("entryentity.categorytype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
            long billId = SrmCommonUtil.getPkValue((DynamicObject)obj);
            if (billId != 0L && supplierId != 0L) continue;
            e.setCancelMessage(ResManager.loadKDString((String)"\u5ba1\u6279\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636eID\u548c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmCategoryChgAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            e.cancel = true;
            return;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            long billId = SrmCommonUtil.getPkValue((DynamicObject)dataEntity);
            Map resultMap = SrmCategoryLibUtil.addToCategoryLib((String)"srm_categorychg", (long)billId);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25,\u9519\u8bef\u539f\u56e0\uff1a%1", (String)"SrmCategoryChgAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmCategoryChgAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[]{resultMap.get("message")}));
            }
            dataEntity.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObject dynamicObject = null;
                HashMap<String, ExtendedDataEntity> dataEntityMap = new HashMap<String, ExtendedDataEntity>(this.getDataEntities().length);
                Object[] pkArray = new Object[this.getDataEntities().length];
                for (int i = 0; i < this.getDataEntities().length; ++i) {
                    dynamicObject = this.getDataEntities()[i].getDataEntity();
                    dataEntityMap.put(dynamicObject.getString("id"), this.getDataEntities()[i]);
                    pkArray[i] = dynamicObject.getLong("id");
                }
                DynamicObjectCollection dyos = QueryServiceHelper.query((String)"srm_categorychg", (String)"id,billno,org.id,supplier.id,entryentity.category.id,entryentity.categorytype,entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkArray)});
                HashMap<String, String> keyMap = new HashMap<String, String>((int)((double)dyos.size() / 0.75));
                for (int i = 0; i < dyos.size(); ++i) {
                    String org = ((DynamicObject)dyos.get(i)).getString("org.id");
                    String supplier = ((DynamicObject)dyos.get(i)).getString("supplier.id");
                    String catId = ((DynamicObject)dyos.get(i)).getString("entryentity.category.id");
                    String matId = ((DynamicObject)dyos.get(i)).getString("entryentity.material.id");
                    String type = ((DynamicObject)dyos.get(i)).getString("entryentity.categorytype");
                    keyMap.put(org + supplier + catId + matId + type, ((DynamicObject)dyos.get(i)).getString("billno"));
                }
                for (DynamicObject dyo : dyos) {
                    ExtendedDataEntity entity;
                    String org = dyo.getString("org.id");
                    String supplier = dyo.getString("supplier.id");
                    String catId = dyo.getString("entryentity.category.id");
                    String matId = dyo.getString("entryentity.material.id");
                    String type = dyo.getString("entryentity.categorytype");
                    if (!keyMap.containsKey(org + supplier + catId + matId + type) || ((String)keyMap.get(org + supplier + catId + matId + type)).equals(dyo.getString("billno")) || (entity = (ExtendedDataEntity)dataEntityMap.get(dyo.getString("id"))) == null) continue;
                    this.addErrorMessage(entity, MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u548c{1}\u5b58\u5728\u76f8\u540c\u7ec4\u7ec7\uff0c\u76f8\u540c\u4f9b\u5e94\u5546,\u76f8\u540c\u7c7b\u578b,\u76f8\u540c\u54c1\u7c7b,\u76f8\u540c\u7269\u6599\u7684\u5206\u5f55\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SrmCategoryChgAuditOp_2", (String)"scm-srm-opplugin", (Object[])new Object[0]), dyo.getString("billno"), keyMap.get(org + supplier + catId)));
                }
            }
        });
    }
}

