/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.SrmEvaPlanStatusEnum;
import kd.scm.common.util.SrmCommonUtil;

public class SrmEvaPlanAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("bizstatus");
        keys.add("scheme");
        keys.add("entry_scorer");
        keys.add("entry_scorer.indexclass");
        keys.add("entry_scorer.scorerweight");
        keys.add("entry_scorer.scorer");
        keys.add("entry_index");
        keys.add("entry_detail");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List validExtDataEntities = CollectionUtils.arrayToList((Object)dataEntities);
        for (DynamicObject obj : validExtDataEntities) {
            Map<String, Object> resultMap = this.setIndexAndScorerEntry(obj);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                throw new KDBizException(resultMap.get("message").toString());
            }
            obj.set("bizstatus", (Object)SrmEvaPlanStatusEnum.TOBEPUSH);
        }
    }

    private Map<String, Object> setIndexAndScorerEntry(DynamicObject obj) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        long billId = SrmCommonUtil.getPkValue((DynamicObject)obj);
        long schemeId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("scheme"));
        if (schemeId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bc4\u4f30\u65b9\u6848\u4e3a\u7a7a", (String)"SrmEvaPlanAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
        if (schemeObj == null) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bc4\u4f30\u65b9\u6848\u65e0\u6548\u3002", (String)"SrmEvaPlanAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObjectCollection indexRows = schemeObj.getDynamicObjectCollection("entryentity");
        if (indexRows == null || indexRows.size() == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u65b9\u6848\u7684\u6307\u6807\u5206\u5f55\u3002", (String)"SrmEvaPlanAuditOp_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObjectCollection scorerRows = obj.getDynamicObjectCollection("entry_scorer");
        DeleteServiceHelper.delete((String)"srm_evaplan_detail", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)billId)});
        ArrayList<DynamicObject> newindexObjs = new ArrayList<DynamicObject>();
        int indexSeq = 1;
        for (DynamicObject indexRow : indexRows) {
            DynamicObject row = ORMUtil.newDynamicObject((String)"srm_evaplan_detail");
            EntryProp scorerProp = (EntryProp)row.getDataEntityType().getProperties().get((Object)"entryentity");
            EntryType scorerType = (EntryType)scorerProp.getItemType();
            long indexClassId = (Long)indexRow.getDynamicObject("index.indexclass").getPkValue();
            long indexTypeId = (Long)indexRow.getDynamicObject("index.indextype").getPkValue();
            String indexScoretype = indexRow.getString("index.scoretype");
            row.set("billid", (Object)billId);
            row.set("fseq", (Object)indexSeq++);
            row.set("index", indexRow.getDynamicObject("index").getPkValue());
            row.set("weight", (Object)indexRow.getBigDecimal("weight"));
            int scorerSeq = 1;
            DynamicObjectCollection subRows = row.getDynamicObjectCollection("entryentity");
            if ("9".equals(indexScoretype)) {
                if (StringUtils.isNotEmpty((CharSequence)indexScoretype)) {
                    DynamicObject subRow = new DynamicObject((DynamicObjectType)scorerType);
                    subRow.set("seq", (Object)scorerSeq++);
                    subRow.set("scorer", null);
                    subRow.set("scorerweight", (Object)new BigDecimal(100));
                    subRows.add((Object)subRow);
                }
            } else {
                for (DynamicObject scorerRow : scorerRows) {
                    long classId = (Long)scorerRow.getDynamicObject("indexclass").getPkValue();
                    if (indexClassId != classId && indexTypeId != classId) continue;
                    DynamicObject subRow = new DynamicObject((DynamicObjectType)scorerType);
                    subRow.set("seq", (Object)scorerSeq++);
                    subRow.set("scorer", scorerRow.getDynamicObject("scorer").getPkValue());
                    subRow.set("scorerweight", (Object)scorerRow.getBigDecimal("scorerweight"));
                    subRows.add((Object)subRow);
                }
            }
            newindexObjs.add(row);
        }
        if (newindexObjs != null && newindexObjs.size() > 0) {
            resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_evaplan_detail", (DynamicObject[])newindexObjs.toArray(new DynamicObject[0]));
        }
        return resultMap;
    }
}

