/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public final class SrmGroupEvaPlanAuditOp
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("bizstatus");
        keys.add("billdate");
        keys.add("finishdate");
        keys.add("datefrom");
        keys.add("dateto");
        keys.add("scheme");
        keys.add("entryentity");
        keys.add("entry_scorer.seq");
        keys.add("entryentity.supplier");
        keys.add("entry_scorer");
        keys.add("entry_scorer.indexclass");
        keys.add("entry_scorer.scorer");
        keys.add("entry_scorer.scorerweight");
        keys.add("evamethod");
        keys.add("entryentity.subentryentity");
        keys.add("category");
        keys.add("evatype");
        keys.add("type");
        keys.add("name");
        keys.add("entryentity.subentryentity.material");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            String type = data.getString("type");
            String pushOp = "pushandsave";
            String targetBillName = "srm_evaplan";
            String seleces = "id,billno,name";
            if (type.equals("3") || type.equals("4")) {
                pushOp = "pushandsavenewplan";
                targetBillName = "srm_evaplan_batch";
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)pushOp, (String)"srm_groupevaplan", (DynamicObject[])new DynamicObject[]{data}, null);
            long id = data.getLong("id");
            String name = data.getString("name");
            if (!operationResult.isSuccess()) {
                this.log.info("\u96c6\u56e2\u8bc4\u4f30\u8ba1\u5212\u5ba1\u6838\u540e\u4e0b\u63a8" + pushOp + "\u5931\u8d25" + name);
                e.setCancel(true);
                String msg = "";
                if (operationResult.getAllErrorOrValidateInfo() != null) {
                    msg = operationResult.getAllErrorOrValidateInfo().toString();
                    msg = msg.substring(1);
                    msg = msg.substring(0, msg.length() - 1);
                } else {
                    msg = ResManager.loadKDString((String)"\u96c6\u56e2\u8bc4\u4f30\u8ba1\u5212\u5ba1\u6838\u540e\u4e0b\u63a8\u8bc4\u4f30\u8ba1\u5212\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6392\u67e5\u539f\u56e0\u3002", (String)"SrmGroupEvaPlanAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]);
                }
                e.setCancelMessage(msg);
                return;
            }
            DynamicObjectCollection tarData = QueryServiceHelper.query((String)targetBillName, (String)seleces, (QFilter[])new QFilter[]{new QFilter("groupevaplanno.id", "=", (Object)id)});
            if (!type.equals("2") && !type.equals("4")) continue;
            for (DynamicObject targetBill : tarData) {
                this.pushSrmScoreTask(targetBillName, targetBill.getLong("id"));
            }
        }
    }

    private void pushSrmScoreTask(String targetBillName, Object pk) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        option.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
        option.setVariableValue("WF", String.valueOf(false));
        OperationResult submitOperationResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetBillName, (Object[])new Object[]{pk}, (OperateOption)option);
        if (submitOperationResult.isSuccess()) {
            OperationResult auditOperationResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetBillName, (Object[])new Object[]{pk}, (OperateOption)option);
            if (auditOperationResult.isSuccess()) {
                OperationResult pushOperationResult = OperationServiceHelper.executeOperate((String)"pushandsave", (String)targetBillName, (Object[])new Object[]{pk}, (OperateOption)option);
                if (!pushOperationResult.isSuccess()) {
                    this.log.info("\u4e0b\u63a8\u8bc4\u4f30\u8ba1\u5212\u5355\u540e\u4e0b\u8fbe\u5931\u8d25" + pushOperationResult.getAllErrorOrValidateInfo() + pushOperationResult.getMessage());
                } else {
                    OperationResult sendMsgOperationResult = OperationServiceHelper.executeOperate((String)"sendmsg", (String)targetBillName, (Object[])new Object[]{pk}, (OperateOption)option);
                    if (!sendMsgOperationResult.isSuccess()) {
                        this.log.info("\u4e0b\u8fbe\u540e\u7ed9\u8bc4\u59d4\u53d1\u9001\u6d88\u606f\u5931\u8d25" + sendMsgOperationResult.getAllErrorOrValidateInfo() + sendMsgOperationResult.getMessage());
                    }
                }
            } else {
                this.log.info("\u4e0b\u63a8\u8bc4\u4f30\u8ba1\u5212\u5355\u540e\u5ba1\u6838\u5931\u8d25" + submitOperationResult.getAllErrorOrValidateInfo() + auditOperationResult.getMessage());
            }
        } else {
            this.log.info("\u4e0b\u63a8\u8bc4\u4f30\u8ba1\u5212\u5355\u540e\u63d0\u4ea4\u5931\u8d25" + submitOperationResult.getAllErrorOrValidateInfo() + submitOperationResult.getMessage());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }
}

