/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.srm.common.SrmAddSupplierRegUtil;
import kd.scm.srm.common.SrmSendEmailUtil;

public class SrmIssueRFIAuditOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(SrmIssueRFIAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("required");
        e.getFieldKeys().add("rficontent");
        e.getFieldKeys().add("suppliername");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("linkman");
        e.getFieldKeys().add("email");
        e.getFieldKeys().add("phone");
        e.getFieldKeys().add("mailvalidity");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject bill : dataEntities = e.getDataEntities()) {
            if (!Objects.isNull(bill.get("mailvalidity"))) continue;
            bill.set("mailvalidity", (Object)DateUtil.addDays((Date)DateUtil.formatEndDate((Date)TimeServiceHelper.now()), (int)7));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<String> nameList = new ArrayList<String>(10);
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        for (DynamicObject bill : dataEntities) {
            String name = bill.getString("suppliername");
            nameList.add(name);
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue((Object)bill.getLong("id"));
            listSelectedRows.add((Object)listSelectedRow);
        }
        SrmAddSupplierRegUtil.addSupplierReg((DynamicObject[])dataEntities, (ListSelectedRowCollection)listSelectedRows);
        Map<String, Long> ids = this.getSupplierRegId(nameList);
        SrmSendEmailUtil.sendEmail((DynamicObject[])dataEntities, ids);
    }

    private Map<String, Long> getSupplierRegId(List<String> nameList) {
        HashMap<String, Long> billIdsMap = new HashMap<String, Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_supplierreg", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "in", nameList)});
        if (!query.isEmpty()) {
            for (DynamicObject dyo : query) {
                String name = dyo.getString("name");
                Long id = dyo.getLong("id");
                billIdsMap.put(name, id);
            }
        }
        return billIdsMap;
    }
}

