/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;
import kd.scm.srm.opplugin.util.FlowNodeServiceUtil;
import kd.scm.srm.opplugin.validator.SrmAptitudeNoValidator;
import kd.scm.srm.service.SrmMaterialExamIsNodeCompleted;
import org.apache.commons.collections.CollectionUtils;

public class SrmMaterialExamAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("biztype")) {
            e.getFieldKeys().add("biztype");
        }
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("auditopinion")) {
            e.getFieldKeys().add("auditopinion");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        if (!fieldKeys.contains("aptitudeno")) {
            e.getFieldKeys().add("aptitudeno");
        }
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("tryresult");
        e.getFieldKeys().add("entryentity.category");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        int size = e.getValidExtDataEntities().size();
        if (size > 1) {
            String aptitudeEntityName = EntityMetadataCache.getDataEntityType((String)"srm_aptitudeexam").getDisplayName().getLocaleValue();
            String entityName = this.billEntityType.getDisplayName().getLocaleValue();
            HashMap<String, StringBuilder> aptitudeOfNumber = new HashMap<String, StringBuilder>(size);
            ArrayList<String> uniqueAptitude = new ArrayList<String>(size);
            HashSet<String> errorAptitude = new HashSet<String>(size);
            for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
                String billNo = extendedDataEntity.getBillNo();
                DynamicObject aptitudeDynamicObject = extendedDataEntity.getDataEntity().getDynamicObject("aptitudeno");
                if (Objects.isNull(aptitudeDynamicObject)) continue;
                String aptitudeName = aptitudeDynamicObject.getString("name");
                if (uniqueAptitude.contains(aptitudeName)) {
                    ((StringBuilder)aptitudeOfNumber.get(aptitudeName)).append('\u3001').append(billNo);
                    errorAptitude.add(aptitudeName);
                    continue;
                }
                uniqueAptitude.add(aptitudeName);
                aptitudeOfNumber.put(aptitudeName, new StringBuilder().append(billNo));
            }
            if (uniqueAptitude.size() < size && !errorAptitude.isEmpty()) {
                StringBuilder message = new StringBuilder(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u8d44\u8d28\u5ba1\u67e5\u5355\u53f7\u5bf9\u5e94\u7684\u591a\u884c\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u6570\u636e\u3002", (String)"SrmMaterialExamAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmMaterialExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                for (String billNo : errorAptitude) {
                    message.append(aptitudeEntityName).append('\uff1a').append(billNo).append("->").append(entityName).append((CharSequence)aptitudeOfNumber.get(billNo)).append('\uff1b');
                }
                e.setCancel(true);
                e.setCancelMessage(message.toString());
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        ArrayList<Long> idList = new ArrayList<Long>(e.getDataEntities().length);
        for (DynamicObject obj : e.getDataEntities()) {
            Map resultMap;
            if (Objects.isNull(obj.getDynamicObject("aptitudeno"))) {
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT);
                continue;
            }
            String bizType = obj.getString("biztype");
            Long aptitudeId = obj.getDynamicObject("aptitudeno").getLong("number");
            SrmMaterialExamIsNodeCompleted isNodeCompleted = new SrmMaterialExamIsNodeCompleted();
            DynamicObject org = obj.getDynamicObject("org");
            Boolean finished = Boolean.FALSE;
            if (SrmCategoryConfigUtil.isCategory((DynamicObject)org).booleanValue()) {
                String tryresult = obj.getString("tryresult");
                String billNo = obj.getString("billno");
                if (tryresult.equals("1")) {
                    finished = isNodeCompleted.isStepCompleted(aptitudeId, new String[]{billNo});
                }
            } else {
                long billId = Long.parseLong(obj.getPkValue().toString());
                finished = isNodeCompleted.isStepCompletedWhenUnUseCategoryParam("srm_materialexam", billId);
            }
            if (enableNewAccessFlow) {
                resultMap = FlowNodeServiceUtil.setAptitudeNodeStatus(obj, finished);
                if (finished.booleanValue()) {
                    idList.add(obj.getLong("id"));
                }
            } else {
                resultMap = SrmBillEditUtil.setAptitudeStatus((String)bizType, (DynamicObject)obj, (boolean)finished);
            }
            if (resultMap != null && resultMap.get("succed") != null && ((Boolean)resultMap.get("succed")).booleanValue()) {
                long supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
                DynamicObject supplierObj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"auditstatus", (String)"id", (Object)supplierId, null, null, null, null, null, null, null, (String)"loadBill", null);
                if (supplierObj != null && !supplierObj.getString("auditstatus").equals(SrmSupplierStatusEnum.SUCCESS.getValue())) {
                    supplierObj.set("auditstatus", (Object)SrmSupplierStatusEnum.APTITUDE.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierObj});
                }
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT);
                continue;
            }
            String message = resultMap == null ? "" : (String)resultMap.get("message");
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1", (String)"SrmMaterialExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmMaterialExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[]{message}));
        }
        if (!idList.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationServiceHelper.executeOperate((String)"pushbill", (String)"srm_materialexam", (Object[])idList.toArray(), (OperateOption)option);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject obj : e.getDataEntities()) {
            if (!Objects.isNull(obj.getDynamicObject("aptitudeno"))) continue;
        }
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            DynamicObject[] Objs;
            for (DynamicObject obj : Objs = e.getDataEntities()) {
                if (!Objects.nonNull(obj.getDynamicObject("aptitudeno"))) continue;
                SrmCommonUtil.recordAuditInfo((DynamicObject)obj);
            }
            if (SrmCommonUtil.enableNewAccessFlow()) {
                FlowNodeServiceUtil.setSupapproveNodeStatus(e.getDataEntities(), true);
            }
            this.updateAptitudeExam(e.getDataEntities(), "srm_supapprove");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmAptitudeNoValidator());
    }

    private void updateAptitudeExam(DynamicObject[] objects, String billType) {
        DynamicObject[] supplierapprove;
        ArrayList<Long> aptitudeIds = new ArrayList<Long>(objects.length);
        for (DynamicObject bill : objects) {
            DynamicObject dynamicObject = bill.getDynamicObject("aptitudeno");
            if (Objects.isNull(dynamicObject)) continue;
            Long aptitudeId = dynamicObject.getLong("id");
            aptitudeIds.add(aptitudeId);
        }
        if (CollectionUtils.isEmpty(aptitudeIds)) {
            return;
        }
        QFilter qFilter = new QFilter("aptitudeno", "in", aptitudeIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_aptitudeexam", (String)"id,isapprove,hasapprove", (QFilter[])new QFilter[]{new QFilter("id", "in", aptitudeIds)}, (String)"id");){
            dataSet.forEach(row -> {
                boolean hasSample = row.getBoolean("hasapprove");
                boolean isSample = row.getBoolean("isapprove");
                if (!isSample || hasSample) {
                    aptitudeIds.remove(row.getLong("id"));
                }
            });
        }
        ArrayList approvePkIds = new ArrayList();
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)billType, (String)"id", (QFilter[])new QFilter[]{qFilter.and(new QFilter("billstatus", "=", (Object)"A"))}, (String)"id");){
            dataSet.forEach(row -> approvePkIds.add(row.getLong("id")));
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject bill : supplierapprove = BusinessDataServiceHelper.load((Object[])approvePkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)billType))) {
            Long aptitudeId = bill.getDynamicObject("aptitudeno").getLong("id");
            DynamicObjectCollection materialObjs = QueryServiceHelper.query((String)"srm_materialexam", (String)"id,entryentity.category.id,entryentity.material.id,tryresult", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C").and(new QFilter("aptitudeno.number", "=", (Object)aptitudeId)).and(new QFilter("auditstatus", "=", (Object)"C"))});
            DynamicObjectCollection approveentryentity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row2 : approveentryentity) {
                DynamicObject category = row2.getDynamicObject("category");
                if (category == null) continue;
                long categoryId = category.getLong("id");
                long materialId = 0L;
                if (row2.getDynamicObject("material") != null) {
                    materialId = row2.getDynamicObject("material").getLong("id");
                }
                String categoryType = row2.getString("categorytype");
                DynamicObject materialObj = null;
                String materialObjTryresult = "3";
                for (DynamicObject tmpObj : materialObjs) {
                    String tryresult = tmpObj.getString("tryresult");
                    if (categoryType.equals("B")) {
                        Long curcategoryId = tmpObj.getLong("entryentity.category.id");
                        if (curcategoryId != categoryId) continue;
                        if (tryresult.equals("1")) {
                            materialObj = tmpObj;
                            materialObjTryresult = "1";
                            break;
                        }
                        if (materialObj != null) continue;
                        materialObj = tmpObj;
                        materialObjTryresult = "2";
                        continue;
                    }
                    Long curmaterialId = tmpObj.getLong("entryentity.material.id");
                    if (curmaterialId != materialId) continue;
                    if (tryresult.equals("1")) {
                        materialObj = tmpObj;
                        materialObjTryresult = "1";
                        break;
                    }
                    if (materialObj != null) continue;
                    materialObj = tmpObj;
                    materialObjTryresult = "2";
                }
                row2.set("tryresult", (Object)materialObjTryresult);
                if (materialObj == null) continue;
                row2.set("tryno_id", (Object)materialObj.getString("id"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])supplierapprove);
    }
}

