/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.enums.SrmSceneResultEnum;
import kd.scm.srm.opplugin.util.FlowNodeServiceUtil;
import kd.scm.srm.opplugin.validator.SrmAptitudeNoValidator;
import org.apache.commons.collections.CollectionUtils;

public class SrmSceneExamAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SrmSceneExamAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("biztype")) {
            e.getFieldKeys().add("biztype");
        }
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("auditopinion")) {
            e.getFieldKeys().add("auditopinion");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        if (!fieldKeys.contains("aptitudeno")) {
            e.getFieldKeys().add("aptitudeno");
        }
        if (!fieldKeys.contains("org")) {
            e.getFieldKeys().add("org");
        }
        if (!fieldKeys.contains("sceneresult")) {
            e.getFieldKeys().add("sceneresult");
        }
        e.getFieldKeys().add("entryentity.category");
        e.getFieldKeys().add("billno");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        int size = e.getValidExtDataEntities().size();
        if (size > 1) {
            String aptitudeEntityName = EntityMetadataCache.getDataEntityType((String)"srm_aptitudeexam").getDisplayName().getLocaleValue();
            String entityName = this.billEntityType.getDisplayName().getLocaleValue();
            HashMap<String, StringBuilder> aptitudeOfNumber = new HashMap<String, StringBuilder>(size);
            ArrayList<String> uniqueAptitude = new ArrayList<String>(size);
            HashSet<String> errorAptitude = new HashSet<String>(size);
            for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
                String billNo = extendedDataEntity.getBillNo();
                DynamicObject aptitudeDynamicObject = extendedDataEntity.getDataEntity().getDynamicObject("aptitudeno");
                if (Objects.isNull(aptitudeDynamicObject)) continue;
                String aptitudeName = aptitudeDynamicObject.getString("name");
                if (uniqueAptitude.contains(aptitudeName)) {
                    ((StringBuilder)aptitudeOfNumber.get(aptitudeName)).append('\u3001').append(billNo);
                    errorAptitude.add(aptitudeName);
                    continue;
                }
                uniqueAptitude.add(aptitudeName);
                aptitudeOfNumber.put(aptitudeName, new StringBuilder().append(billNo));
            }
            if (uniqueAptitude.size() < size && !errorAptitude.isEmpty()) {
                StringBuilder message = new StringBuilder(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u8d44\u8d28\u5ba1\u67e5\u5355\u53f7\u5bf9\u5e94\u7684\u591a\u884c\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u6570\u636e\u3002", (String)"SrmSceneExamAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmSceneExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                for (String billNo : errorAptitude) {
                    message.append(aptitudeEntityName).append('\uff1a').append(billNo).append("->").append(entityName).append((CharSequence)aptitudeOfNumber.get(billNo)).append('\uff1b');
                }
                e.setCancel(true);
                e.setCancelMessage(message.toString());
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        ArrayList<Long> idList = new ArrayList<Long>(e.getDataEntities().length);
        for (DynamicObject obj : e.getDataEntities()) {
            if (Objects.isNull(obj.getDynamicObject("aptitudeno"))) {
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT);
                continue;
            }
            Map<Object, Object> resultMap = new HashMap(2);
            String bizType = obj.getString("biztype");
            String sceneresult = obj.getString("sceneresult");
            boolean finished = true;
            if (StringUtils.isNotEmpty((CharSequence)sceneresult) && "4".equals(sceneresult)) {
                finished = false;
            }
            if (enableNewAccessFlow) {
                resultMap = FlowNodeServiceUtil.setAptitudeNodeStatus(obj, finished);
                if (finished) {
                    idList.add(obj.getLong("id"));
                }
            } else {
                resultMap = SrmBillEditUtil.setAptitudeStatus((String)bizType, (DynamicObject)obj, (boolean)finished);
            }
            if (resultMap != null && resultMap.get("succed") != null && ((Boolean)resultMap.get("succed")).booleanValue()) {
                long supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
                DynamicObject supplierObj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"auditstatus", (String)"id", (Object)supplierId, null, null, null, null, null, null, null, (String)"loadBill", null);
                if (supplierObj != null && !supplierObj.getString("auditstatus").equals(SrmSupplierStatusEnum.SUCCESS.getValue())) {
                    supplierObj.set("auditstatus", (Object)SrmSupplierStatusEnum.APTITUDE.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierObj});
                }
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT);
                continue;
            }
            String message = resultMap == null ? "" : (String)resultMap.get("message");
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1", (String)"SrmSceneExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmSceneExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[]{message}));
        }
        if (!idList.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationServiceHelper.executeOperate((String)"pushbill", (String)"srm_sceneexam", (Object[])idList.toArray(), (OperateOption)option);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            DynamicObject[] objs;
            for (DynamicObject obj : objs = e.getDataEntities()) {
                if (!Objects.nonNull(obj.getDynamicObject("aptitudeno"))) continue;
                SrmCommonUtil.recordAuditInfo((DynamicObject)obj);
            }
            this.pushImprove(objs);
            this.updateAptitudeExam(e.getDataEntities(), "srm_supapprove");
            if (SrmCommonUtil.enableNewAccessFlow()) {
                FlowNodeServiceUtil.setSupapproveNodeStatus(objs, true);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmAptitudeNoValidator());
    }

    public ConvertOperationResult pushImprove(DynamicObject[] dynCol) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("srm_sceneexam");
        pushArgs.setTargetEntityNumber("srm_improve");
        pushArgs.setBuildConvReport(false);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        for (DynamicObject dyn : dynCol) {
            if (!StringUtils.equals((CharSequence)SrmSceneResultEnum.RECTIFICATION_REVIEW.getVal(), (CharSequence)dyn.getString("sceneresult"))) continue;
            ListSelectedRow row = new ListSelectedRow((Object)dyn.getLong("id"));
            selectedRowList.add(row);
        }
        ConvertOperationResult result = null;
        if (selectedRowList.size() > 0) {
            pushArgs.setSelectedRows(selectedRowList);
            try {
                result = ConvertServiceHelper.push((PushArgs)pushArgs);
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"srm_improve");
                if (result.isSuccess()) {
                    List targetData = result.loadTargetDataObjects((objects, iDataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType), mainType);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", String.valueOf(true));
                    option.setVariableValue("isStrict", String.valueOf(false));
                    OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"srm_improve", (DynamicObject[])targetData.toArray(new DynamicObject[targetData.size()]), (OperateOption)option);
                    log.info(saveResult.getMessage() == null ? "@@\u6539\u5584\u5355\u4fdd\u5b58\u6210\u529f" : "@@\u6539\u5584\u5355\u4fdd\u5b58\u5931\u8d25" + saveResult.getMessage());
                    this.writeBackScene(targetData);
                } else {
                    log.info("@@\u4e0b\u63a8\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getMessage());
                }
            }
            catch (Exception e) {
                log.error("@@\u73b0\u573a\u8bc4\u5ba1\u4e0b\u63a8\u6539\u5584\u5355\u5931\u8d25:" + result + e.getMessage());
            }
        }
        return result;
    }

    public void writeBackScene(List<DynamicObject> targetDatas) {
        DynamicObject[] needUpdateDyns = new DynamicObject[targetDatas.size()];
        int index = 0;
        for (DynamicObject targetData : targetDatas) {
            DynamicObject sceneDyn = BusinessDataServiceHelper.loadSingle((Object)targetData.getString("srcbillid"), (String)"srm_sceneexam");
            sceneDyn.set("improvebillno", targetData.getPkValue());
            needUpdateDyns[index++] = sceneDyn;
        }
        SaveServiceHelper.save((DynamicObject[])needUpdateDyns);
    }

    private void updateAptitudeExam(DynamicObject[] objects, String billType) {
        DynamicObject[] supplierapprove;
        ArrayList<Long> aptitudeIds = new ArrayList<Long>(objects.length);
        HashMap<Long, Long> mapAptitudeOfSample = new HashMap<Long, Long>((int)((double)objects.length / 0.75));
        for (DynamicObject bill : objects) {
            DynamicObject dynamicObject = bill.getDynamicObject("aptitudeno");
            if (Objects.isNull(dynamicObject)) continue;
            Long aptitudeId = dynamicObject.getLong("id");
            aptitudeIds.add(aptitudeId);
            Long pkId = bill.getLong("id");
            mapAptitudeOfSample.put(aptitudeId, pkId);
        }
        if (CollectionUtils.isEmpty(aptitudeIds)) {
            return;
        }
        QFilter qFilter = new QFilter("aptitudeno", "in", aptitudeIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_aptitudeexam", (String)"id,isapprove,hasapprove", (QFilter[])new QFilter[]{new QFilter("id", "in", aptitudeIds)}, (String)"id");){
            dataSet.forEach(row -> {
                boolean hasSample = row.getBoolean("hasapprove");
                boolean isSample = row.getBoolean("isapprove");
                if (!isSample || hasSample) {
                    aptitudeIds.remove(row.getLong("id"));
                }
            });
        }
        ArrayList approvePkIds = new ArrayList();
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)billType, (String)"id", (QFilter[])new QFilter[]{qFilter.and(new QFilter("billstatus", "=", (Object)"A"))}, (String)"id");){
            dataSet.forEach(row -> approvePkIds.add(row.getLong("id")));
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject bill : supplierapprove = BusinessDataServiceHelper.load((Object[])approvePkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)billType))) {
            Long aptitudeId = bill.getDynamicObject("aptitudeno").getLong("id");
            Long sceneId = (Long)mapAptitudeOfSample.get(aptitudeId);
            bill.set("sceneno_id", (Object)sceneId);
        }
        SaveServiceHelper.save((DynamicObject[])supplierapprove);
    }
}

