/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmApproveUtil;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.SrmCategoryLibUtil;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;
import kd.scm.srm.opplugin.util.FlowNodeServiceUtil;
import kd.scm.srm.opplugin.validator.SrmAptitudeNoValidator;
import kd.scm.srm.service.SrmSupApproveIsNodeCompleted;

public class SrmSupApproveAuditOp
extends AbstractOperationServicePlugIn {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("biztype")) {
            e.getFieldKeys().add("biztype");
        }
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("auditopinion")) {
            e.getFieldKeys().add("auditopinion");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        if (!fieldKeys.contains("aptitudeno")) {
            e.getFieldKeys().add("aptitudeno");
        }
        if (!fieldKeys.contains("org")) {
            e.getFieldKeys().add("org");
        }
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("category");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("testresult");
        e.getFieldKeys().add("aptitudeno.issuppcolla");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            Long supplierId = obj.getLong("supplier_id");
            DynamicObject srmSupplier = obj.getDynamicObject("supplier");
            String name = srmSupplier.getString("name");
            String societyCreditCode = srmSupplier.getString("societycreditcode");
            Map resultMap = null;
            boolean succed = true;
            long billId = SrmCommonUtil.getPkValue((DynamicObject)obj);
            String bizType = obj.getString("biztype");
            if (billId == 0L || bizType == null || "".equals(bizType.trim()) || supplierId == 0L) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u5ba1\u6279\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636eID\u3001\u4e1a\u52a1\u7c7b\u578b\u548c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmSupApproveAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                e.cancel = true;
                return;
            }
            if (SrmCommonUtil.isBlackEnterpirse((long)0L, (String)societyCreditCode, (String)name)) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u5546\u540d\u79f0\u6216\u4fe1\u7528\u4ee3\u7801\u5df2\u88ab\u7eb3\u5165\u9ed1\u540d\u5355\uff0c\u4e0d\u5141\u8bb8\u751f\u6548\u3002", (String)"SrmSupApproveAuditOp_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                e.cancel = true;
                return;
            }
            Long aptitudeId = obj.getDynamicObject("aptitudeno").getLong("number");
            Boolean isMallIn = obj.getBoolean("aptitudeno.isshopmall");
            Boolean issuppcolla = obj.getBoolean("aptitudeno.issuppcolla");
            Date createTime = null;
            if (obj.getDataEntityType().getProperties().get((Object)"createtime") != null) {
                createTime = obj.getDate("createtime");
            }
            SrmApproveUtil.updateBdSupplierIssuppcolla((Long)obj.getLong("aptitudeno_id"), (Long)srmSupplier.getLong("supplier_id"));
            String orgnumber = obj.getString("org.number");
            resultMap = SrmApproveUtil.updateSupplierStatus((Long)supplierId, (Boolean)isMallIn, (Date)createTime, (String)orgnumber);
            succed = (Boolean)resultMap.get("succed");
            if (succed) {
                resultMap = SrmApproveUtil.updateSupplierUser((long)supplierId, (Boolean)issuppcolla);
                succed = (Boolean)resultMap.get("succed");
            }
            if (succed) {
                resultMap = SrmCategoryLibUtil.addToCategoryLib((String)"srm_supapprove", (long)billId);
                succed = (Boolean)resultMap.get("succed");
            }
            if (succed) {
                resultMap = SrmApproveUtil.updateBillBizpartner((long)supplierId, (String)name);
                succed = (Boolean)resultMap.get("succed");
            }
            DynamicObject org = obj.getDynamicObject("org");
            Boolean finished = Boolean.TRUE;
            if (SrmCategoryConfigUtil.isCategory((DynamicObject)org).booleanValue()) {
                String billNo = obj.getString("billno");
                SrmSupApproveIsNodeCompleted isNodeCompleted = new SrmSupApproveIsNodeCompleted();
                finished = isNodeCompleted.isStepCompleted(aptitudeId, new String[]{billNo});
            }
            if (succed) {
                if (enableNewAccessFlow) {
                    resultMap = FlowNodeServiceUtil.setAptitudeNodeStatus(obj, finished);
                    if (finished.booleanValue()) {
                        DynamicObject aptitudeObj = BusinessDataServiceHelper.loadSingle((Object)aptitudeId, (String)"srm_aptitudeexam");
                        aptitudeObj.set("auditstatus", (Object)"E");
                        SrmCommonUtil.saveDynamicObject((String)"srm_aptitudeexam", (DynamicObject)aptitudeObj);
                    }
                } else {
                    resultMap = SrmBillEditUtil.setAptitudeStatus((String)bizType, (DynamicObject)obj, (boolean)finished);
                }
                succed = (Boolean)resultMap.get("succed");
            }
            if (succed) {
                DynamicObject supplierObj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"auditstatus", (String)"id", (Object)supplierId, null, null, null, null, null, null, null, (String)"loadBill", null);
                if (supplierObj != null && !supplierObj.getString("auditstatus").equals(SrmSupplierStatusEnum.SUCCESS.getValue())) {
                    supplierObj.set("auditstatus", (Object)SrmSupplierStatusEnum.SUCCESS.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierObj});
                }
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
                continue;
            }
            e.setCancelMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1", (String)"SrmSupApproveAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmSupApproveAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[]{resultMap.get("message")}));
            e.cancel = true;
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            DynamicObject[] Objs = e.getDataEntities();
            ArrayList<Long> srmSupplierPkIds = new ArrayList<Long>(Objs.length);
            for (DynamicObject obj : Objs) {
                Long supplierId = obj.getLong("supplier_id");
                DynamicObject aptitudeObj = obj.getDynamicObject("aptitudeno");
                DynamicObject regSupplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"srm_supplier");
                SrmApproveUtil.BecomeFormalSupplier((DynamicObject)regSupplier, (DynamicObject)aptitudeObj, (DynamicObject)obj);
                SrmCommonUtil.recordAuditInfo((DynamicObject)obj);
                srmSupplierPkIds.add(obj.getLong("supplier_id"));
            }
            SrmApproveUtil.updateSupplierEnableStatus(srmSupplierPkIds);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject obj : e.getDataEntities()) {
            if (!Objects.isNull(obj.getDynamicObject("aptitudeno"))) continue;
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmAptitudeNoValidator());
    }
}

