/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.srm.common.SrmApproveUtil;
import kd.scm.srm.common.SrmCategoryLibUtil;
import kd.scm.srm.opplugin.validator.SrmSupQuitAuditValidator;

public class SrmSupQuitAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SrmSupQuitAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        if (!fieldKeys.contains("isquit")) {
            e.getFieldKeys().add("isquit");
        }
        if (!fieldKeys.contains("quitorg")) {
            e.getFieldKeys().add("quitorg");
        }
        if (!fieldKeys.contains("scope")) {
            e.getFieldKeys().add("scope");
        }
        if (!fieldKeys.contains("entryentity")) {
            e.getFieldKeys().add("entryentity");
        }
        e.getFieldKeys().add("supplier.createorg");
        fieldKeys.add("supplier.id");
        fieldKeys.add("supplier.name");
        fieldKeys.add("org");
        fieldKeys.add("org.id");
        fieldKeys.add("org.name");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            long supplierId = (Long)obj.getDynamicObject("supplier").getPkValue();
            long billId = (Long)obj.getPkValue();
            if (supplierId != 0L) continue;
            e.cancel = true;
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u5904\u7406\u3002", (String)"SrmSupQuitAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            long billId = (Long)obj.getPkValue();
            Map resultMap = SrmCategoryLibUtil.exitFromCategoryLib((String)"srm_supquit", (long)billId);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1", (String)"SrmSupQuitAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmSupQuitAuditOp_1", (String)"scm-srm-opplugin", (Object[])new Object[]{resultMap.get("message")}));
            }
            obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> srmSupplierPkIds = new ArrayList<Long>();
        for (DynamicObject bill : dataEntities) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            HashSet<String> numberSet = new HashSet<String>();
            HashSet orgNumber = new HashSet();
            Long orgId = bill.getLong("org_id");
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject bdSupplier = bill.getDynamicObject("supplier.supplier");
            Long createOrgId = bill.getLong("supplier.createorg.id");
            if (bdSupplier != null) {
                String bdSupplierNUmber = bdSupplier.getString("number");
                numberSet.add(bdSupplierNUmber);
            }
            param.put("quit", "0");
            if ("1".equals(bill.getString("scope"))) {
                QFilter qFilter = new QFilter("supplier", "=", (Object)bill.getLong("supplier_id"));
                DynamicObject[] categorys = null;
                if (orgId != null) {
                    if (orgId.equals(OrgUnitServiceHelper.getRootOrgId())) {
                        param.put("quit", "1");
                    } else {
                        ArrayList<Long> curOrgList = new ArrayList<Long>(10);
                        curOrgList.add(orgId);
                        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"02", curOrgList, (boolean)true);
                        qFilter.and("org.id", "in", (Object)allSubordinateOrgs);
                        categorys = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"org.number", (QFilter[])new QFilter[]{qFilter});
                        if (categorys != null) {
                            Arrays.stream(categorys).forEach(info -> orgNumber.add(info.getString("org.number")));
                        }
                    }
                    if (orgId.equals(createOrgId) && orgId.equals(OrgUnitServiceHelper.getRootOrgId())) {
                        srmSupplierPkIds.add(bill.getLong("supplier_id"));
                    } else if (orgId.equals(createOrgId) && !orgId.equals(OrgUnitServiceHelper.getRootOrgId())) {
                        this.addSrmDisableIds(orgId, bill.getLong("supplier_id"), srmSupplierPkIds);
                    }
                }
            } else {
                DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entryentity");
                entryCol.stream().forEach(entry -> {
                    if (entry.getBoolean("isquit")) {
                        DynamicObject quitorg = entry.getDynamicObject("quitorg");
                        orgNumber.add(quitorg.getString("number"));
                    }
                });
            }
            param.put("numbers", numberSet);
            param.put("operate", "disable");
            param.put("org", orgNumber);
            SrmApproveUtil.updateEASSupStatus(param);
        }
        SrmApproveUtil.updateSupplierStatus(srmSupplierPkIds);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmSupQuitAuditValidator());
    }

    private void addSrmDisableIds(Long orgId, Long sullierId, List<Long> srmSupplierPkIds) {
        List allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"02", (long)orgId);
        QFilter qFilter1 = new QFilter("org", "=", (Object)orgId).and(new QFilter("view.number", "=", (Object)"02"));
        DynamicObject bos_org_structure = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,org,level,view", (QFilter[])new QFilter[]{qFilter1});
        if (Objects.nonNull(bos_org_structure)) {
            int level = bos_org_structure.getInt("level");
            List orgByLevel = OrgUnitServiceHelper.getOrgByLevel((String)"02", (int)level, (boolean)false, (boolean)false);
            allSuperiorOrgs.addAll(orgByLevel);
        }
        if (!CollectionUtils.isEmpty((Collection)allSuperiorOrgs)) {
            allSuperiorOrgs.remove(orgId);
            boolean exists = QueryServiceHelper.exists((String)"srm_supcategory", (QFilter[])new QFilter[]{new QFilter("org.id", "in", (Object)allSuperiorOrgs).and(new QFilter("supplier", "=", (Object)sullierId)).and(new QFilter("auditstatus", "=", (Object)"1"))});
            if (!exists) {
                srmSupplierPkIds.add(sullierId);
            }
        }
    }
}

