/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.operation.message.base.AbstractPurRelSubSendMsgService;
import kd.scm.common.util.MessageUtil;
import org.apache.commons.lang.StringUtils;

public class SrmSupplierregSendMsgOp
extends AbstractPurRelSubSendMsgService {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("phone")) {
            fieldKeys.add("phone");
        }
        if (!fieldKeys.contains("email")) {
            fieldKeys.add("email");
        }
    }

    public void sendMsg(DynamicObject[] objects, String opKey) {
        ArrayList<String> phones = null;
        ArrayList<String> emails = null;
        HashMap<String, Long> phoneMapUserId = null;
        HashMap<String, Long> emailMapUserId = null;
        if ("audit".equals(opKey)) {
            phones = new ArrayList<String>();
            emails = new ArrayList<String>();
            for (DynamicObject object : objects) {
                Object email;
                Object phone = object.get("phone");
                if (null != phone && StringUtils.isNotBlank((String)phone.toString())) {
                    phones.add((String)phone);
                }
                if (null == (email = object.get("email")) || !StringUtils.isNotBlank((String)email.toString())) continue;
                emails.add((String)email);
            }
            phoneMapUserId = new HashMap<String, Long>();
            emailMapUserId = new HashMap<String, Long>();
            this.initPhoneEmailMap(phoneMapUserId, emailMapUserId, phones, emails);
        }
        for (DynamicObject object : objects) {
            String content;
            String email;
            String phone;
            Object pkvalue = object.get("id");
            Object name = object.get("org.name");
            if (null == pkvalue || null == name || this.isDisable(phone = object.getString("phone"), email = object.getString("email"))) continue;
            if ("audit".equals(opKey)) {
                List<Long> receiveUserIds = this.getRegsupplierUserId(phone, email, phoneMapUserId, emailMapUserId);
                HashMap<String, Object> msgParam = new HashMap<String, Object>(16);
                msgParam.put("receiveUserIds", receiveUserIds);
                msgParam.put("pkId", pkvalue);
                msgParam.put("title", ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u5ba1\u6279\u901a\u77e5", (String)"SrmSupplierregSendMsgOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                msgParam.put("entityNumber", "srm_supplierreg");
                msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
                msgParam.put("tplScene", "srmSupplierregcomfirm");
                msgParam.put("content", MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u7684\u6ce8\u518c\u8d44\u6599\uff0c{0}\u7684\u5ba1\u6279\u7ed3\u679c\u4e3a\u201c\u6ce8\u518c\u901a\u8fc7\u201d\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SrmSupplierregSendMsgOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), name));
                MessageUtil.sendMessage(msgParam, (boolean)false);
            }
            if ("reject".equals(opKey)) {
                content = MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u7684\u6ce8\u518c\u8d44\u6599\uff0c{0}\u7684\u5ba1\u6279\u7ed3\u679c\u4e3a\u201c\u6ce8\u518c\u9a73\u56de\u201d\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SrmSupplierregSendMsgOp_2", (String)"scm-srm-opplugin", (Object[])new Object[0]), name);
                this.regFailSendMsg(phone, email, content);
            }
            if (!"unsubmit".equals(opKey)) continue;
            content = MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u7684\u6ce8\u518c\u8d44\u6599\uff0c{0}\u7684\u5ba1\u6279\u7ed3\u679c\u4e3a\u201c\u9000\u56de\u4fee\u6539\u201d\uff0c\u8bf7\u60a8\u91cd\u65b0\u4fee\u6539\u3002", (String)"SrmSupplierregSendMsgOp_3", (String)"scm-srm-opplugin", (Object[])new Object[0]), name);
            this.regFailSendMsg(phone, email, content);
        }
    }

    private boolean isDisable(String phone, String email) {
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((String)phone)) {
            qFilter = new QFilter("number", "=", (Object)phone);
        } else if (StringUtils.isNotBlank((String)email)) {
            qFilter = new QFilter("email", "=", (Object)email);
        }
        if (null == qFilter) {
            return false;
        }
        qFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"srm_user", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return objs.isEmpty();
    }

    private List<Long> getRegsupplierUserId(String phone, String email, Map<String, Long> phoneMapUserId, Map<String, Long> emailMapUserId) {
        Long id;
        ArrayList<Long> list = new ArrayList<Long>();
        if (StringUtils.isNotBlank((String)phone) && null != (id = phoneMapUserId.get(phone))) {
            list.add(id);
        }
        if (StringUtils.isNotBlank((String)email) && null != (id = emailMapUserId.get(email))) {
            list.add(id);
        }
        return list;
    }

    private void initPhoneEmailMap(Map<String, Long> phoneMapUserId, Map<String, Long> emailMapUserId, List<String> phones, List<String> emails) {
        QFilter qFilter = null;
        if (!phones.isEmpty()) {
            qFilter = new QFilter("phone", "in", phones);
        }
        if (!emails.isEmpty()) {
            if (qFilter != null) {
                qFilter.or(new QFilter("email", "in", emails));
            } else {
                qFilter = new QFilter("email", "in", emails);
            }
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"bos_user", (String)"id,phone,email", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject obj : objs) {
            String email;
            String phone = obj.getString("phone");
            if (StringUtils.isNotBlank((String)phone)) {
                phoneMapUserId.put(phone, (Long)obj.get("id"));
            }
            if (!StringUtils.isNotBlank((String)(email = obj.getString("email")))) continue;
            emailMapUserId.put(email, (Long)obj.get("id"));
        }
    }

    public void sendSms(List<String> phones, String content) {
        MessageUtil.sendSms(phones, (String)content);
    }

    public void sendEmail(List<String> recEmails, String content, String title) {
        MessageUtil.sendEmail(recEmails, (String)content, (String)title);
    }

    public void regFailSendMsg(Object phone, Object email, String content) {
        String recEmail;
        String recPhone;
        if (null != phone && StringUtils.isNotBlank((String)(recPhone = phone.toString()))) {
            ArrayList<String> recPhones = new ArrayList<String>(1);
            recPhones.add(recPhone);
            this.sendSms(recPhones, content);
        }
        if (null != email && StringUtils.isNotBlank((String)(recEmail = email.toString()))) {
            ArrayList<String> recEmails = new ArrayList<String>(1);
            recEmails.add(recEmail);
            String title = ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u5ba1\u6279\u901a\u77e5", (String)"SrmSupplierregSendMsgOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]);
            this.sendEmail(recEmails, content, title);
        }
    }
}

