/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.upgrade;

import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.scm.srm.opplugin.upgrade.impl.AptitudeExamUpgradeService;
import kd.scm.srm.opplugin.upgrade.impl.EntertypeUpgradeService;
import kd.scm.srm.opplugin.upgrade.impl.SupapproveUpgradeService;

public class SrmAccessNodeUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SrmAccessNodeUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            boolean enableNewFlow = false;
            result.setLog("begin to update enableNewAccessFlow configuration!\n");
            DBRoute dbRoute = new DBRoute(dbKey);
            try (DataSet ds = DB.queryDataSet((String)"SrmAccessNodeUpgradeService.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)"select fid from t_pur_entertype", null);){
                if (ds == null || ds.isEmpty()) {
                    enableNewFlow = true;
                }
            }
            if (enableNewFlow) {
                this.enableNewAccessFlow();
            }
            result.setLog(pProcessInfo.append("end to update enableNewAccessFlow configuration\n!\n").toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public void enableNewAccessFlow() {
        this.enableNewAccessConfig("pur");
        this.upgradeAllAccessNode();
    }

    private void upgradeAllAccessNode() {
        EntertypeUpgradeService entertypeService = new EntertypeUpgradeService();
        entertypeService.nodeDataUpgrade();
        AptitudeExamUpgradeService aptitudeService = new AptitudeExamUpgradeService();
        aptitudeService.nodeDataUpgrade();
        SupapproveUpgradeService supapproveService = new SupapproveUpgradeService();
        supapproveService.nodeDataUpgrade();
    }

    private void enableNewAccessConfig(String dbKey) {
        DBRoute purdbRoute = new DBRoute(dbKey);
        String updatesql = "update t_pur_updateparamconfig set fparamvalue ='Y' where  fparamkey='enableNewAccessFlow' ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        logger.info("\u542f\u7528\u65b0\u51c6\u5165\u6d41\u7a0b\u6210\u529f\uff1aenableNewAccessFlow.fparamvalue=Y");
    }
}

