/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SrmIndexUpgradeService
implements IUpgradeService {
    int PAGE_SIZE = 500;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("begin to upgrade SrmIndexUpgradeService!\n");
            boolean checkData = this.checkData(pProcessInfo);
            if (checkData) {
                this.indexDataUpgrade();
            }
            result.setLog(pProcessInfo.append("end to upgrade SrmIndexUpgradeService\n!\n").toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean checkData(StringBuilder pProcessInfo) {
        DBRoute dbRoute = new DBRoute("pur");
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct fid from t_pur_indexentry1");
        try (DataSet dataSet1 = DB.queryDataSet((String)"SrmIndexUpgradeService.indexDataUpgrade", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList idList = new ArrayList();
            dataSet1.forEach(row -> idList.add(row.getLong("fid")));
            if (idList.size() > 0) {
                pProcessInfo.append("upgrade success!\n");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public void indexDataUpgrade() {
        DBRoute dbRoute = new DBRoute("pur");
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct fid from t_pur_indexentry");
        try (DataSet dataSet1 = DB.queryDataSet((String)"SrmIndexUpgradeService.indexDataUpgrade", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList idList = new ArrayList();
            dataSet1.forEach(row -> idList.add(row.getLong("fid")));
            int count = idList.size();
            int totalPages = count / this.PAGE_SIZE;
            if (count % this.PAGE_SIZE != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object[]> paramSubs;
                List<Long> subIdList = (pageIndex + 1) * this.PAGE_SIZE > idList.size() ? idList.subList(pageIndex * this.PAGE_SIZE, idList.size()) : idList.subList(pageIndex * this.PAGE_SIZE, (pageIndex + 1) * this.PAGE_SIZE);
                if (subIdList == null || subIdList.isEmpty()) continue;
                List<Object[]> params = this.setIndexEntryData(subIdList);
                if (params != null && !params.isEmpty()) {
                    this.insertIndexEntry1(dbRoute, params);
                }
                if ((paramSubs = this.selectIndexEntrySubData(subIdList, dbRoute)) == null || paramSubs.isEmpty()) continue;
                this.insertIndexEntry1SubData(dbRoute, paramSubs);
            }
        }
    }

    private List<Object[]> setIndexEntryData(List<Long> subIdList) {
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(subIdList.size());
        for (Long fid : subIdList) {
            Object[] param = new Object[]{fid, fid, 1, Character.valueOf('1')};
            insertList.add(param);
        }
        return insertList;
    }

    private List<Object[]> selectIndexEntrySubData(List<Long> subIdList, DBRoute dbRoute) {
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(subIdList.size());
        StringBuilder sb = new StringBuilder();
        sb.append(" select distinct s.fid,s.fentryid,s.fformula,s.fitem,s.fitemscore,s.fformula,s.fnote,s.fseq,s.fvaluefrom,s.fvalueto,s.faccordance,s.fveto");
        sb.append(" from t_pur_indexentry s");
        sb.append(" where s.fid in (").append(StringUtils.join((Object[])subIdList.toArray(new Long[subIdList.size()]), (char)',')).append(')');
        sb.append(" order by s.fid desc ");
        try (DataSet dataSet1 = DB.queryDataSet((String)"SrmIndexUpgradeService.selectIndexEntrySubData", (DBRoute)dbRoute, (String)sb.toString(), null);){
            dataSet1.forEach(row -> {
                Object[] tempList = this.getInsertIndexEntryData((Row)row, dbRoute);
                if (tempList != null && tempList.length > 0) {
                    insertList.add(tempList);
                }
            });
        }
        return insertList;
    }

    private Object[] getInsertIndexEntryData(Row row, DBRoute dbRoute) {
        Long id = row.getLong("fid");
        Long entryid = row.getLong("fentryid");
        Long seq = row.getLong("fseq");
        String item = row.getString("fitem");
        BigDecimal valuefrom = row.getBigDecimal("fvaluefrom");
        BigDecimal valueto = row.getBigDecimal("fvalueto");
        BigDecimal itemscore = row.getBigDecimal("fitemscore");
        String veto = row.getString("fveto");
        String note = row.getString("fnote");
        String accordance = row.getString("faccordance");
        String formula = row.getString("fformula");
        Object[] param = new Object[]{id, entryid, seq, item, valuefrom, valueto, itemscore, formula, veto, accordance, note};
        return param;
    }

    private void insertIndexEntry1(DBRoute dbRoute, List<Object[]> parms) {
        String insertSql = " insert into t_pur_indexentry1(fid,fentryid,fseq,fisgenericrule)values(?,?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, parms);
    }

    private void insertIndexEntry1SubData(DBRoute dbRoute, List<Object[]> parms) {
        String insertSql = " insert into t_pur_indexentry1sub(fentryid,fdetailid,fseq,fitem,fvaluefrom,fvalueto,fitemscore,fformula,fveto,faccordance,fnote)values(?,?,?,?,?,?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, parms);
    }
}

